/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.carol.jndi.intercept.ContextInterceptor;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerManager;

public abstract class AbsContextInterceptor
implements ContextInterceptor {
    private IResourceCheckerManager resourceCheckerManager = null;
    private String jndiRegexp = ".*";

    protected boolean filterOnJndiName(String jndiName) {
        Pattern pattern = Pattern.compile(this.jndiRegexp);
        Matcher matcher = pattern.matcher(jndiName);
        return matcher.matches();
    }

    protected boolean filterOnMethodName(Method method) {
        return "lookup".equals(method.getName()) || "lookupLink".equals(method.getName());
    }

    public IResourceCheckerManager getResourceCheckerManager() {
        return this.resourceCheckerManager;
    }

    public void setResourceCheckerManager(IResourceCheckerManager resourceCheckerManager) {
        this.resourceCheckerManager = resourceCheckerManager;
    }

    public String getJndiRegexp() {
        return this.jndiRegexp;
    }

    public void setJndiRegexp(String jndiRegexp) {
        this.jndiRegexp = jndiRegexp;
    }
}

