/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.gui.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.felix.shell.gui.Plugin;
import org.apache.felix.shell.gui.plugin.OutputAreaStream;
import org.apache.felix.shell.gui.plugin.ScrollableOutputArea;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.obr.Capability;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

public class OBRPlugin
extends JPanel
implements Plugin {
    private static final String DEPLOY_BUTTON = "Deploy";
    private static final String START_BUTTON = "Deploy & start";
    private BundleContext m_context = null;
    private ServiceReference m_repoRef = null;
    private RepositoryAdmin m_repoAdmin = null;
    private SimpleTreeNode m_rootNode = null;
    private CreateRootRunnable m_createRootRunnable = new CreateRootRunnable();
    private SetRootRunnable m_setRootRunnable = new SetRootRunnable();
    private JButton m_addRepoButton = null;
    private JButton m_removeRepoButton = null;
    private JButton m_refreshRepoButton = null;
    private JTree m_bundleTree = null;
    private JButton m_deployButton = null;
    private JButton m_startButton = null;
    private JButton m_infoButton = null;
    private ScrollableOutputArea m_soa = null;
    private JButton m_clearButton = null;
    private PrintStream m_out = null;

    public String getName() {
        return "OBR";
    }

    public Component getGUI() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBRPlugin(BundleContext context) {
        this.m_context = context;
        this.m_soa = new ScrollableOutputArea(5, 30);
        this.m_out = new PrintStream(new OutputAreaStream(this.m_soa));
        this.createUserInterface();
        OBRPlugin oBRPlugin = this;
        synchronized (oBRPlugin) {
            ServiceListener sl = new ServiceListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void serviceChanged(ServiceEvent event) {
                    OBRPlugin oBRPlugin = OBRPlugin.this;
                    synchronized (oBRPlugin) {
                        if (event.getType() == 1 && OBRPlugin.this.m_repoRef != null) {
                            return;
                        }
                        if (event.getType() == 1 && OBRPlugin.this.m_repoRef == null) {
                            OBRPlugin.this.lookupService();
                        } else if (event.getType() == 4 && event.getServiceReference().equals(OBRPlugin.this.m_repoRef)) {
                            OBRPlugin.this.m_context.ungetService(OBRPlugin.this.m_repoRef);
                            OBRPlugin.this.m_repoRef = null;
                            OBRPlugin.this.m_repoAdmin = null;
                            OBRPlugin.this.lookupService();
                        }
                    }
                }
            };
            try {
                this.m_context.addServiceListener(sl, "(objectClass=" + RepositoryAdmin.class.getName() + ")");
            }
            catch (InvalidSyntaxException ex) {
                System.err.println("OBRPlugin: " + (Object)((Object)ex));
            }
            this.lookupService();
        }
    }

    private synchronized void lookupService() {
        if (this.m_repoAdmin != null) {
            return;
        }
        this.m_repoRef = this.m_context.getServiceReference(RepositoryAdmin.class.getName());
        if (this.m_repoRef != null) {
            this.m_repoAdmin = (RepositoryAdmin)this.m_context.getService(this.m_repoRef);
        }
        this.initializeRootNode();
    }

    private void createEventListeners() {
        this.m_addRepoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                OBRPlugin oBRPlugin = OBRPlugin.this;
                synchronized (oBRPlugin) {
                    if (OBRPlugin.this.m_repoAdmin == null) {
                        return;
                    }
                    String s = JOptionPane.showInputDialog(OBRPlugin.this, (Object)"Enter repository URL:");
                    if (s != null) {
                        try {
                            OBRPlugin.this.m_repoAdmin.addRepository(new URL(s));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    OBRPlugin.this.initializeRootNode();
                }
            }
        });
        this.m_removeRepoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                OBRPlugin oBRPlugin = OBRPlugin.this;
                synchronized (oBRPlugin) {
                    if (OBRPlugin.this.m_repoAdmin == null) {
                        return;
                    }
                    TreePath[] paths = OBRPlugin.this.m_bundleTree.getSelectionPaths();
                    for (int i = 0; i < paths.length; ++i) {
                        SimpleTreeNode node = (SimpleTreeNode)paths[i].getLastPathComponent();
                        if (!(node.getObject() instanceof Repository)) continue;
                        OBRPlugin.this.m_repoAdmin.removeRepository(((Repository)((SimpleTreeNode)paths[i].getLastPathComponent()).getObject()).getURL());
                    }
                    OBRPlugin.this.initializeRootNode();
                }
            }
        });
        this.m_refreshRepoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                OBRPlugin oBRPlugin = OBRPlugin.this;
                synchronized (oBRPlugin) {
                    if (OBRPlugin.this.m_repoAdmin == null) {
                        return;
                    }
                    TreePath[] paths = OBRPlugin.this.m_bundleTree.getSelectionPaths();
                    for (int i = 0; i < paths.length; ++i) {
                        SimpleTreeNode node = (SimpleTreeNode)paths[i].getLastPathComponent();
                        if (!(node.getObject() instanceof Repository)) continue;
                        try {
                            OBRPlugin.this.m_repoAdmin.addRepository(((Repository)node.getObject()).getURL());
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    OBRPlugin.this.initializeRootNode();
                }
            }
        });
        ActionListener al = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                boolean start = event.getActionCommand().equals(OBRPlugin.START_BUTTON);
                OBRPlugin oBRPlugin = OBRPlugin.this;
                synchronized (oBRPlugin) {
                    if (OBRPlugin.this.m_repoAdmin == null) {
                        return;
                    }
                    Resolver resolver = OBRPlugin.this.m_repoAdmin.resolver();
                    TreePath[] paths = OBRPlugin.this.m_bundleTree.getSelectionPaths();
                    for (int i = 0; i < paths.length; ++i) {
                        SimpleTreeNode node = (SimpleTreeNode)paths[i].getLastPathComponent();
                        if (!(node.getObject() instanceof Resource)) continue;
                        resolver.add((Resource)node.getObject());
                    }
                    if (resolver.getAddedResources() != null && resolver.getAddedResources().length > 0) {
                        if (resolver.resolve()) {
                            int resIdx;
                            OBRPlugin.this.m_out.println("Target resource(s):");
                            OBRPlugin.printUnderline(OBRPlugin.this.m_out, 19);
                            Resource[] resources = resolver.getAddedResources();
                            for (resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
                                OBRPlugin.this.m_out.println("   " + resources[resIdx].getPresentationName() + " (" + resources[resIdx].getVersion() + ")");
                            }
                            resources = resolver.getRequiredResources();
                            if (resources != null && resources.length > 0) {
                                OBRPlugin.this.m_out.println("\nRequired resource(s):");
                                OBRPlugin.printUnderline(OBRPlugin.this.m_out, 21);
                                for (resIdx = 0; resIdx < resources.length; ++resIdx) {
                                    OBRPlugin.this.m_out.println("   " + resources[resIdx].getPresentationName() + " (" + resources[resIdx].getVersion() + ")");
                                }
                            }
                            if ((resources = resolver.getOptionalResources()) != null && resources.length > 0) {
                                OBRPlugin.this.m_out.println("\nOptional resource(s):");
                                OBRPlugin.printUnderline(OBRPlugin.this.m_out, 21);
                                for (resIdx = 0; resIdx < resources.length; ++resIdx) {
                                    OBRPlugin.this.m_out.println("   " + resources[resIdx].getPresentationName() + " (" + resources[resIdx].getVersion() + ")");
                                }
                            }
                            try {
                                OBRPlugin.this.m_out.print("\nDeploying...");
                                resolver.deploy(start);
                                OBRPlugin.this.m_out.println("done.");
                            }
                            catch (IllegalStateException ex) {
                                OBRPlugin.this.m_out.println(ex);
                            }
                        } else {
                            Requirement[] reqs = resolver.getUnsatisfiedRequirements();
                            if (reqs != null && reqs.length > 0) {
                                OBRPlugin.this.m_out.println("Unsatisfied requirement(s):");
                                OBRPlugin.printUnderline(OBRPlugin.this.m_out, 27);
                                for (int reqIdx = 0; reqIdx < reqs.length; ++reqIdx) {
                                    OBRPlugin.this.m_out.println("   " + reqs[reqIdx].getFilter());
                                    Resource[] resources = resolver.getResources(reqs[reqIdx]);
                                    for (int resIdx = 0; resIdx < resources.length; ++resIdx) {
                                        OBRPlugin.this.m_out.println("      " + resources[resIdx].getPresentationName());
                                    }
                                }
                            } else {
                                OBRPlugin.this.m_out.println("Could not resolve targets.");
                            }
                        }
                        OBRPlugin.this.m_out.println("");
                    }
                }
            }
        };
        this.m_deployButton.addActionListener(al);
        this.m_startButton.addActionListener(al);
        this.m_infoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                OBRPlugin oBRPlugin = OBRPlugin.this;
                synchronized (oBRPlugin) {
                    if (OBRPlugin.this.m_repoAdmin == null) {
                        return;
                    }
                    TreePath[] paths = OBRPlugin.this.m_bundleTree.getSelectionPaths();
                    for (int i = 0; i < paths.length; ++i) {
                        if (i != 0) {
                            OBRPlugin.this.m_out.println("");
                        }
                        OBRPlugin.this.printInfo(OBRPlugin.this.m_out, ((SimpleTreeNode)paths[i].getLastPathComponent()).getObject());
                    }
                    OBRPlugin.this.m_out.println("");
                }
            }
        });
        this.m_clearButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                OBRPlugin oBRPlugin = OBRPlugin.this;
                synchronized (oBRPlugin) {
                    OBRPlugin.this.m_soa.setText("");
                }
            }
        });
        this.m_bundleTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (OBRPlugin.this.m_repoAdmin == null) {
                    return;
                }
                TreePath[] paths = OBRPlugin.this.m_bundleTree.getSelectionPaths();
                boolean repoOnly = true;
                if (paths != null) {
                    for (int i = 0; repoOnly && i < paths.length; ++i) {
                        SimpleTreeNode node = (SimpleTreeNode)paths[i].getLastPathComponent();
                        if (node.getObject() instanceof Repository) continue;
                        repoOnly = false;
                    }
                }
                OBRPlugin.this.m_removeRepoButton.setEnabled(paths != null && repoOnly);
                OBRPlugin.this.m_refreshRepoButton.setEnabled(paths != null && repoOnly);
                OBRPlugin.this.m_infoButton.setEnabled(paths != null && paths.length > 0);
            }
        });
    }

    private void printInfo(PrintStream out, Object obj) {
        if (obj != null) {
            if (obj instanceof Repository) {
                Repository repo = (Repository)obj;
                out.println(repo.getName());
                out.println("   URL = " + repo.getURL());
                out.println("   Modified = " + new Date(repo.getLastModified()));
            } else if (obj instanceof Resource) {
                Resource res = (Resource)obj;
                out.println(res.getPresentationName());
                Map map = res.getProperties();
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    out.println("   " + entry.getKey() + " = " + entry.getValue());
                }
                Requirement[] reqs = res.getRequirements();
                for (int i = 0; reqs != null && i < reqs.length; ++i) {
                    if (i == 0) {
                        out.println("   requirements:");
                    }
                    out.println("      " + reqs[i].getFilter());
                }
                Capability[] caps = res.getCapabilities();
                for (int i = 0; caps != null && i < caps.length; ++i) {
                    if (i == 0) {
                        out.println("   capabilities:");
                    }
                    out.println("      " + caps[i].getName() + " = " + caps[i].getProperties());
                }
            }
        }
    }

    private void createUserInterface() {
        JSplitPane split = new JSplitPane(0, this.createTree(), this.createConsole());
        split.setResizeWeight(1.0);
        split.setDividerSize(5);
        this.setLayout(new BorderLayout());
        this.add((Component)split, "Center");
        this.createEventListeners();
    }

    private JPanel createTree() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createRepoPanel(), "North");
        panel.add((Component)this.createResourcePanel(), "Center");
        return panel;
    }

    private JPanel createRepoPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Repositories"));
        this.m_addRepoButton = new JButton("Add");
        panel.add(this.m_addRepoButton);
        this.m_addRepoButton.setMnemonic('A');
        this.m_removeRepoButton = new JButton("Remove");
        panel.add(this.m_removeRepoButton);
        this.m_removeRepoButton.setMnemonic('R');
        this.m_refreshRepoButton = new JButton("Refresh");
        panel.add(this.m_refreshRepoButton);
        this.m_refreshRepoButton.setMnemonic('f');
        this.m_removeRepoButton.setEnabled(false);
        this.m_refreshRepoButton.setEnabled(false);
        return panel;
    }

    private JPanel createResourcePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Resources"));
        JScrollPane scroll = null;
        this.m_bundleTree = new JTree(new SimpleTreeNode(null, null));
        scroll = new JScrollPane(this.m_bundleTree);
        panel.add((Component)scroll, "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        scroll.setPreferredSize(new Dimension(100, 100));
        this.m_bundleTree.setMinimumSize(new Dimension(0, 0));
        this.m_bundleTree.setRootVisible(false);
        this.m_bundleTree.setShowsRootHandles(true);
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        this.m_deployButton = new JButton(DEPLOY_BUTTON);
        panel.add(this.m_deployButton);
        this.m_startButton = new JButton(START_BUTTON);
        panel.add(this.m_startButton);
        this.m_infoButton = new JButton("Info");
        panel.add(this.m_infoButton);
        this.m_deployButton.setMnemonic('D');
        this.m_startButton.setMnemonic('S');
        this.m_infoButton.setMnemonic('I');
        this.m_infoButton.setEnabled(false);
        return panel;
    }

    private JPanel createConsole() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_soa, "Center");
        this.m_clearButton = new JButton("Clear");
        panel.add((Component)this.m_clearButton, "East");
        this.m_clearButton.setMnemonic('C');
        return panel;
    }

    private static void printUnderline(PrintStream out, int length) {
        for (int i = 0; i < length; ++i) {
            out.print('-');
        }
        out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRootNode() {
        CreateRootRunnable createRootRunnable = this.m_createRootRunnable;
        synchronized (createRootRunnable) {
            new Thread(this.m_createRootRunnable).start();
        }
    }

    private static class SimpleTreeNode
    implements TreeNode {
        private TreeNode m_parent = null;
        private Object m_obj = null;
        private TreeNode[] m_children = null;
        private String m_toString = null;

        public SimpleTreeNode(TreeNode parent, Object obj) {
            this.m_parent = parent;
            this.m_obj = obj;
        }

        public Object getObject() {
            return this.m_obj;
        }

        public TreeNode getChildAt(int index) {
            if (this.m_children == null) {
                this.initialize();
            }
            if (this.m_children != null && index >= 0 && index < this.m_children.length) {
                return this.m_children[index];
            }
            return null;
        }

        public int getChildCount() {
            if (this.m_children == null) {
                this.initialize();
            }
            return this.m_children == null ? 0 : this.m_children.length;
        }

        public TreeNode getParent() {
            return this.m_parent;
        }

        public int getIndex(TreeNode node) {
            if (this.m_children == null) {
                this.initialize();
            }
            for (int i = 0; this.m_children != null && i < this.m_children.length; ++i) {
                if (this.m_children[i] != node) continue;
                return i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public Enumeration children() {
            return null;
        }

        private void initialize() {
            block4: {
                Resource[] objs;
                block3: {
                    if (this.m_obj == null || !(this.m_obj instanceof RepositoryAdmin)) break block3;
                    Repository[] objs2 = ((RepositoryAdmin)this.m_obj).listRepositories();
                    if (objs2 == null) break block4;
                    this.m_children = new TreeNode[objs2.length];
                    for (int i = 0; i < objs2.length; ++i) {
                        this.m_children[i] = new SimpleTreeNode(this, objs2[i]);
                    }
                    break block4;
                }
                if (this.m_obj instanceof Repository && (objs = ((Repository)this.m_obj).getResources()) != null) {
                    this.m_children = new TreeNode[objs.length];
                    for (int i = 0; i < objs.length; ++i) {
                        this.m_children[i] = new SimpleTreeNode(this, objs[i]);
                    }
                }
            }
        }

        public String toString() {
            if (this.m_toString == null) {
                this.m_toString = this.m_obj instanceof RepositoryAdmin ? "ROOT" : (this.m_obj instanceof Repository ? ((Repository)this.m_obj).getName() : (this.m_obj instanceof Resource ? ((Resource)this.m_obj).getPresentationName() + " (" + ((Resource)this.m_obj).getVersion() + ")" : (this.m_obj != null ? this.m_obj.toString() : "null")));
            }
            return this.m_toString;
        }
    }

    private class SetRootRunnable
    implements Runnable {
        private SetRootRunnable() {
        }

        public void run() {
            ((DefaultTreeModel)OBRPlugin.this.m_bundleTree.getModel()).setRoot(OBRPlugin.this.m_rootNode);
        }
    }

    private class CreateRootRunnable
    implements Runnable {
        private CreateRootRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OBRPlugin oBRPlugin = OBRPlugin.this;
            synchronized (oBRPlugin) {
                if (OBRPlugin.this.m_repoAdmin != null) {
                    OBRPlugin.this.m_repoAdmin.listRepositories();
                }
                OBRPlugin.this.m_rootNode = new SimpleTreeNode(null, OBRPlugin.this.m_repoAdmin);
                try {
                    SwingUtilities.invokeAndWait(OBRPlugin.this.m_setRootRunnable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

