/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.MessageAcks;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.XAContext;
import org.objectweb.joram.client.jms.XidImpl;
import org.objectweb.joram.shared.client.SessAckRequest;
import org.objectweb.joram.shared.client.XACnxCommit;
import org.objectweb.joram.shared.client.XACnxPrepare;
import org.objectweb.joram.shared.client.XACnxRecoverReply;
import org.objectweb.joram.shared.client.XACnxRecoverRequest;
import org.objectweb.joram.shared.client.XACnxRollback;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class XAResourceMngr {
    public static final int STARTED = 0;
    public static final int SUSPENDED = 1;
    public static final int SUCCESS = 2;
    public static final int ROLLBACK_ONLY = 3;
    public static final int PREPARED = 4;
    private static Logger logger = Debug.getLogger(XAResourceMngr.class.getName());
    private Hashtable transactions;
    Connection cnx;
    Hashtable sessionTable;

    public XAResourceMngr(Connection cnx) {
        this.cnx = cnx;
        this.transactions = new Hashtable();
        this.sessionTable = new Hashtable();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" XAResourceMngr cnx = " + cnx));
        }
    }

    synchronized void start(Xid xid, int flag, Session sess) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" XAResourceMngr start(" + xid + ", " + flag + ", " + sess + ")"));
        }
        sess.setTransacted(true);
        this.sessionTable.put(xid, sess);
        if (flag == 0) {
            if (this.transactions.containsKey(xid)) {
                throw new XAException("Can't start transaction already known by RM.");
            }
            this.transactions.put(xid, new XAContext());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": involved in transaction " + xid.toString()));
            }
        } else if (flag == 0x8000000) {
            if (!this.transactions.containsKey(xid)) {
                throw new XAException("Can't resume unknown transaction.");
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": resumes transaction " + xid.toString()));
            }
        } else if (flag == 0x200000) {
            if (!this.transactions.containsKey(xid)) {
                throw new XAException("Can't join unknown transaction.");
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": joins transaction " + xid.toString()));
            }
        } else {
            throw new XAException("Invalid flag: " + flag);
        }
        this.setStatus(xid, 0);
    }

    synchronized void end(Xid xid, int flag, Session sess) throws XAException {
        boolean saveResourceState = true;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": end(" + xid + ", " + flag + ", " + sess + ")"));
        }
        if (flag == 0x2000000) {
            if (this.getStatus(xid) != 0) {
                throw new XAException("Can't suspend non started transaction.");
            }
            this.setStatus(xid, 1);
        } else {
            if (this.getStatus(xid) != 0 && this.getStatus(xid) != 1) {
                throw new XAException("Can't end non active or non suspended transaction.");
            }
            if (this.getStatus(xid) == 1) {
                saveResourceState = false;
            }
            if (flag == 0x4000000) {
                this.setStatus(xid, 2);
            } else if (flag == 0x20000000) {
                this.setStatus(xid, 3);
            } else {
                throw new XAException("Invalid flag: " + flag);
            }
        }
        if (saveResourceState) {
            XAContext xaC = (XAContext)this.transactions.get(xid);
            xaC.addSendings(sess.sendings);
            xaC.addDeliveries(sess.deliveries);
        }
        Session session = (Session)this.sessionTable.get(xid);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": end(...) session=" + session));
        }
        if (session != null) {
            session.setTransacted(false);
            this.sessionTable.remove(xid);
        }
    }

    synchronized void prepare(Xid xid) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": prepare(" + xid + ")"));
        }
        try {
            String target;
            if (this.getStatus(xid) == 3) {
                throw new XAException("Can't prepare resource in ROLLBACK_ONLY state.");
            }
            XAContext xaC = (XAContext)this.transactions.get(xid);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": prepares transaction " + xid.toString()));
            }
            Vector pMs = new Vector();
            Vector<SessAckRequest> sessAcks = new Vector<SessAckRequest>();
            Enumeration targets = xaC.sendings.keys();
            while (targets.hasMoreElements()) {
                target = (String)targets.nextElement();
                pMs.add(xaC.sendings.remove(target));
            }
            targets = xaC.deliveries.keys();
            while (targets.hasMoreElements()) {
                target = (String)targets.nextElement();
                MessageAcks acks = (MessageAcks)xaC.deliveries.remove(target);
                sessAcks.add(new SessAckRequest(target, acks.getIds(), acks.getQueueMode()));
            }
            this.cnx.syncRequest(new XACnxPrepare(xid.getBranchQualifier(), xid.getFormatId(), xid.getGlobalTransactionId(), pMs, sessAcks));
            this.setStatus(xid, 4);
        }
        catch (JMSException exc) {
            this.setStatus(xid, 3);
            throw new XAException("Prepare request failed: " + (Object)((Object)exc));
        }
        catch (XAException exc) {
            this.setStatus(xid, 3);
            throw exc;
        }
    }

    synchronized void commit(Xid xid) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": commit(" + xid + ")"));
        }
        try {
            if (this.getStatus(xid) != 4) {
                throw new XAException("Can't commit non prepared transaction.");
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": commits transaction " + xid.toString()));
            }
            this.cnx.syncRequest(new XACnxCommit(xid.getBranchQualifier(), xid.getFormatId(), xid.getGlobalTransactionId()));
            this.transactions.remove(xid);
            Session session = (Session)this.sessionTable.get(xid);
            if (session != null) {
                session.setTransacted(false);
            }
        }
        catch (JMSException exc) {
            this.setStatus(xid, 3);
            throw new XAException("Commit request failed: " + (Object)((Object)exc));
        }
        catch (XAException exc) {
            this.setStatus(xid, 3);
            throw exc;
        }
    }

    synchronized void rollback(Xid xid) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": rollback(" + xid + ")"));
        }
        try {
            XAContext xaC = (XAContext)this.transactions.get(xid);
            if (xaC == null) {
                throw new XAException("Unknown transaction.");
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": rolls back transaction " + xid.toString()));
            }
            Enumeration targets = xaC.deliveries.keys();
            XACnxRollback rollbackRequest = new XACnxRollback(xid.getBranchQualifier(), xid.getFormatId(), xid.getGlobalTransactionId());
            while (targets.hasMoreElements()) {
                String target = (String)targets.nextElement();
                MessageAcks acks = (MessageAcks)xaC.deliveries.remove(target);
                rollbackRequest.add(target, acks.getIds(), acks.getQueueMode());
            }
            this.cnx.syncRequest(rollbackRequest);
            this.transactions.remove(xid);
            Session session = (Session)this.sessionTable.get(xid);
            if (session != null) {
                session.setTransacted(false);
                this.sessionTable.remove(xid);
            }
        }
        catch (JMSException exc) {
            this.setStatus(xid, 3);
            throw new XAException("Rollback request failed: " + (Object)((Object)exc));
        }
        catch (XAException exc) {
            this.setStatus(xid, 3);
            throw exc;
        }
    }

    synchronized Xid[] recover(int flag) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": recovers transactions."));
        }
        if (flag == 0x1000000 || flag == 0x800000) {
            throw new XAException("Non supported recovery flag: " + flag);
        }
        try {
            XACnxRecoverReply reply = (XACnxRecoverReply)this.cnx.syncRequest(new XACnxRecoverRequest());
            if (reply == null) {
                return new Xid[0];
            }
            Xid[] xids = new Xid[reply.getSize()];
            for (int i = 0; i < reply.getSize(); ++i) {
                xids[i] = new XidImpl(reply.getBranchQualifier(i), reply.getFormatId(i), reply.getGlobalTransactionId(i));
                this.transactions.put(xids[i], new XAContext());
                this.setStatus(xids[i], 4);
            }
            return xids;
        }
        catch (Exception exc) {
            throw new XAException("Recovery request failed: " + exc.getMessage());
        }
    }

    private void setStatus(Xid xid, int status) throws XAException {
        XAContext xac = (XAContext)this.transactions.get(xid);
        if (xac == null) {
            throw new XAException("Unknown transaction.");
        }
        xac.status = status;
    }

    private int getStatus(Xid xid) throws XAException {
        XAContext xac = (XAContext)this.transactions.get(xid);
        if (xac == null) {
            throw new XAException("Unknown transaction.");
        }
        return xac.status;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XAResourceMngr)) {
            return false;
        }
        XAResourceMngr other = (XAResourceMngr)o;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": equals other = " + other.cnx + ", this.cnx = " + this.cnx + ", equals = " + this.cnx.equals(other.cnx)));
        }
        return this.cnx.equals(other.cnx);
    }
}

