/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer;

import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Plugin;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Verifier;
import aQute.libg.reporter.Reporter;
import aQute.libg.version.Version;
import aQute.libg.version.VersionRange;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRepo
implements Plugin,
RepositoryPlugin {
    public static String LOCATION = "location";
    public static String READONLY = "readonly";
    File[] EMPTY_FILES = new File[0];
    File root;
    boolean canWrite = true;
    Pattern REPO_FILE = Pattern.compile("([-a-zA-z0-9_\\.]+)-([0-9\\.]+)\\.jar");
    Reporter reporter;

    @Override
    public void setProperties(Map<String, String> map) {
        String location = map.get(LOCATION);
        if (location == null) {
            throw new IllegalArgumentException("Location muse be set on a FileRepo plugin");
        }
        this.root = new File(location);
        if (!this.root.isDirectory()) {
            throw new IllegalArgumentException("Repository is not a valid directory " + this.root);
        }
        String readonly = map.get(READONLY);
        if (readonly != null && Boolean.valueOf(readonly).booleanValue()) {
            this.canWrite = false;
        }
    }

    @Override
    public File[] get(String bsn, String versionRange) throws MalformedURLException {
        if (versionRange != null && versionRange.equals("project")) {
            return null;
        }
        File f = new File(this.root, bsn);
        if (!f.isDirectory()) {
            return null;
        }
        VersionRange range = versionRange == null || versionRange.equals("latest") ? new VersionRange("0") : new VersionRange(versionRange);
        File[] instances = f.listFiles();
        TreeMap<Version, File> versions = new TreeMap<Version, File>();
        int i = 0;
        while (i < instances.length) {
            String versionString;
            Version version;
            Matcher m = this.REPO_FILE.matcher(instances[i].getName());
            if (m.matches() && m.group(1).equals(bsn) && range.includes(version = (versionString = m.group(2)).equals("latest") ? new Version(Integer.MAX_VALUE) : new Version(versionString))) {
                versions.put(version, instances[i]);
            }
            ++i;
        }
        return versions.values().toArray(this.EMPTY_FILES);
    }

    @Override
    public boolean canWrite() {
        return this.canWrite;
    }

    @Override
    public File put(Jar jar) throws Exception {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            throw new IllegalArgumentException("No manifest in JAR: " + jar);
        }
        String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        if (bsn == null) {
            throw new IllegalArgumentException("No Bundle SymbolicName set");
        }
        Map<String, Map<String, String>> b = Processor.parseHeader(bsn, null);
        if (b.size() != 1) {
            throw new IllegalArgumentException("Multiple bsn's specified " + b);
        }
        for (String key : b.keySet()) {
            bsn = key;
            if (Verifier.SYMBOLICNAME.matcher(bsn).matches()) continue;
            throw new IllegalArgumentException("Bundle SymbolicName has wrong format: " + bsn);
        }
        String versionString = manifest.getMainAttributes().getValue("Bundle-Version");
        Version version = versionString == null ? new Version() : new Version(versionString);
        File dir = new File(this.root, bsn);
        dir.mkdirs();
        String fName = String.valueOf(bsn) + "-" + version.getMajor() + "." + version.getMinor() + "." + version.getMicro() + ".jar";
        File file = new File(dir, fName);
        if (file.lastModified() < jar.lastModified()) {
            System.out.println("Updating " + fName);
            jar.write(file);
        } else {
            this.reporter.progress("Did not update " + jar + " because repo has a newer version");
            System.out.println("NOT Updating " + fName + " (repo is newer)");
        }
        file = new File(dir, String.valueOf(bsn) + "-latest.jar");
        if (file.isFile() && file.lastModified() < jar.lastModified()) {
            jar.write(file);
        }
        return file;
    }

    public void setLocation(String string) {
        this.root = new File(string);
        if (!this.root.isDirectory()) {
            throw new IllegalArgumentException("Invalid repository directory");
        }
    }

    @Override
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public List<String> list(String regex) {
        return Arrays.asList(this.root.list());
    }
}

