/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer;

import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Verifier;
import aQute.libg.version.Version;
import java.io.File;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class RepoDeployer {
    File repo;
    File file;
    String bsn;
    String version;

    public File deploy() throws Exception {
        if (this.repo == null) {
            throw new IllegalArgumentException("Repository not set");
        }
        if (!this.repo.isDirectory()) {
            throw new IllegalArgumentException("Repository must be a directory");
        }
        if (this.file == null) {
            throw new IllegalArgumentException("No file set");
        }
        if (!this.file.isFile()) {
            throw new IllegalArgumentException("File does not exist: " + this.file);
        }
        Jar jar = new Jar(this.file);
        try {
            Manifest manifest = jar.getManifest();
            if (manifest == null && this.bsn == null) {
                throw new IllegalArgumentException("Bundle has no Manifest and -bsn <bsn> is given");
            }
            if (manifest != null) {
                Attributes main = manifest.getMainAttributes();
                if (this.bsn == null) {
                    this.bsn = main.getValue("Bundle-SymbolicName");
                }
                if (this.version == null) {
                    this.version = main.getValue("Bundle-Version");
                }
            }
            if (this.bsn == null) {
                throw new IllegalArgumentException("Bundle has no Bundle-SymbolicName");
            }
            int n = this.bsn.indexOf(59);
            if (n > 0) {
                this.bsn = this.bsn.substring(0, n).trim();
            }
            if (!Verifier.SYMBOLICNAME.matcher(this.bsn).matches()) {
                throw new IllegalArgumentException("Bundle Symbolic Name does not match syntax: " + this.bsn);
            }
            if (this.version == null) {
                this.version = "0";
            }
            Version v = new Version(this.version);
            String fullVersion = String.valueOf(v.getMajor()) + "." + v.getMinor() + "." + v.getMicro();
            File dir = new File(this.repo, this.bsn);
            dir.mkdirs();
            File file = new File(dir, String.valueOf(this.bsn) + "-" + fullVersion + ".jar");
            jar.write(file);
            File file2 = file;
            return file2;
        }
        finally {
            jar.close();
        }
    }

    public String[] list() {
        if (this.repo == null) {
            throw new IllegalArgumentException("Repository not set");
        }
        if (!this.repo.isDirectory()) {
            throw new IllegalArgumentException("Repository must be a directory");
        }
        return this.repo.list();
    }

    public String getBsn() {
        return this.bsn;
    }

    public void setBsn(String bsn) {
        this.bsn = bsn;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getRepo() {
        return this.repo;
    }

    public void setRepo(File repo) {
        this.repo = repo;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

