/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.ow2.jonas.ws.jaxws.handler.PostConstructProcessor;
import org.ow2.jonas.ws.jaxws.handler.builder.AnnotationHandlerChainBuilder;
import org.ow2.jonas.ws.jaxws.handler.builder.HandlerChainBuilder;
import org.ow2.util.annotation.processor.DefaultAnnotationProcessor;
import org.ow2.util.annotation.processor.IAnnotationHandler;
import org.ow2.util.annotation.processor.ProcessorException;

public class JOnASJaxWsServerFactoryBean
extends JaxWsServerFactoryBean {
    private HandlerChainBuilder handlerChainBuilder;

    public JOnASJaxWsServerFactoryBean(JaxWsServiceFactoryBean serviceFactory) {
        super(serviceFactory);
        this.doInit = false;
    }

    public void setHandlerChainBuilder(HandlerChainBuilder builder) {
        this.handlerChainBuilder = builder;
    }

    public Server create() {
        Server server = super.create();
        this.buildHandlerChain();
        return server;
    }

    private void buildHandlerChain() {
        if (this.handlerChainBuilder == null) {
            this.handlerChainBuilder = new AnnotationHandlerChainBuilder(this.getServiceBeanClass());
        }
        final JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)this.getServiceFactory();
        PortInfo portInfo = new PortInfo(){

            public QName getServiceName() {
                return sf.getServiceQName();
            }

            public QName getPortName() {
                return sf.getEndpointInfo().getName();
            }

            public String getBindingID() {
                return JOnASJaxWsServerFactoryBean.this.getBindingId();
            }
        };
        ArrayList chain = new ArrayList(this.handlers);
        chain.addAll(this.handlerChainBuilder.buildHandlerChain(portInfo, this.getHandlerClassLoader()));
        for (Handler h : chain) {
            this.injectHandler(h);
            this.constructHandler(h);
        }
        ((JaxWsEndpointImpl)this.getServer().getEndpoint()).getJaxwsBinding().setHandlerChain(chain);
    }

    protected ClassLoader getHandlerClassLoader() {
        return this.getServiceBeanClass().getClassLoader();
    }

    private void injectHandler(Handler handler) {
        DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
        try {
            processor.process((Object)handler);
        }
        catch (ProcessorException e) {
            throw new WebServiceException("Cannot inject resources", (Throwable)e);
        }
    }

    private void constructHandler(Handler handler) {
        DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
        processor.addAnnotationHandler((IAnnotationHandler)new PostConstructProcessor());
        try {
            processor.process((Object)handler);
        }
        catch (ProcessorException e) {
            throw new WebServiceException("Cannot start handler", (Throwable)e);
        }
    }
}

