/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.metainfo;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMultiMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbExternalTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbGenClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbPrimitiveElementMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.GenClassMapping;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.MappingPrinter;
import org.objectweb.jorm.metainfo.api.MappingStructure;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;

public class RdbMappingPrinter
extends MappingPrinter {
    public void print(String p, ClassMapping _cm, PrintStream out) {
        RdbClassMapping cm = (RdbClassMapping)_cm;
        boolean isMulti = cm instanceof RdbClassMultiMapping;
        out.println((isMulti ? "RdbClassMultiMapping: '" : "RdbClassMapping: '") + ((Class)cm.getLinkedMO()).getFQName() + "'");
        this.print(p, cm.getRdbTable(), out);
        if (isMulti) {
            RdbClassMultiMapping rcm = (RdbClassMultiMapping)cm;
            Iterator it = rcm.getRdbExternalTables().iterator();
            while (it.hasNext()) {
                this.print(p, (RdbTable)it.next(), out);
            }
        }
        super.print(p, _cm, out);
    }

    public void print(String p, GenClassMapping _gcm, PrintStream out) {
        RdbGenClassMapping gcm = (RdbGenClassMapping)_gcm;
        out.println("RdbGenClassMapping: '" + ((GenClassRef)gcm.getLinkedMO()).getGenClassId() + "'");
        this.print(p, gcm.getRdbTable(), out);
        super.print(p, gcm, out);
    }

    public void print(String p, PrimitiveElementMapping pem, PrintStream out) {
        RdbPrimitiveElementMapping rpem = (RdbPrimitiveElementMapping)pem;
        Map m = rpem.getPrimitiveElementByRdbJoin();
        if (m == null || m.size() <= 1) {
            PrimitiveElement pe = (PrimitiveElement)pem.getLinkedMO();
            out.println(p + "Column '" + rpem.getName() + "' / field '" + pe.getName());
        } else {
            out.print(p + "Column '" + rpem.getName() + "'");
            Iterator it = m.entrySet().iterator();
            String sep = " / ";
            while (it.hasNext()) {
                Map.Entry me = it.next();
                RdbJoin j = (RdbJoin)me.getKey();
                PrimitiveElement pe = (PrimitiveElement)me.getValue();
                out.print(sep + "(field:" + pe.getName() + ", join:" + j.getName() + ")");
                sep = ", ";
            }
            out.println();
        }
    }

    public boolean canPrint(MappingStructure ms) {
        return true;
    }

    public void print(String p, RdbTable t, PrintStream out) {
        boolean isExternal = t instanceof RdbExternalTable;
        out.println(p + (isExternal ? "External" : "Main") + " table: " + t.getName() + " colocated:" + t.isColocated() + " colocatedMaster:" + t.isColocatedMaster() + " readOnly:" + t.isReadOnly());
        Iterator it = t.getPrimitiveElementMappings().iterator();
        while (it.hasNext()) {
            this.print(p + "    ", (PrimitiveElementMapping)it.next(), out);
        }
        if (isExternal) {
            it = ((RdbExternalTable)t).getRdbJoins().iterator();
            while (it.hasNext()) {
                RdbJoin j = (RdbJoin)it.next();
                out.println(p + "Join '" + j.getName() + "': " + j.getPTJoinColumnNames() + " == " + j.getETJoinColumnNames());
            }
        }
    }
}

