/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.generator;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genbase.utils.TempRepository;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsGenerator {
    private static I18n i18n = I18n.getInstance(AbsGenerator.class);
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.generators.genbase");
    private Config config;
    private File classes;
    private File sources;

    public AbsGenerator(Config config) throws GenBaseException {
        this.config = config;
        TempRepository tr = TempRepository.getInstance();
        try {
            this.sources = tr.createDir();
            this.classes = tr.createDir();
        }
        catch (IOException ioe) {
            String err = i18n.getMessage("AbsGenerator.constr.ioe");
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new GenBaseException(err, ioe);
        }
    }

    public abstract void generate() throws GenBaseException;

    public abstract void compile() throws GenBaseException;

    protected List<String> getJavaSources(File rootSrc, File src) {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        File[] files = src.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".java");
            }
        });
        for (i = 0; i < files.length; ++i) {
            result.add(files[i].getPath().substring(rootSrc.getPath().length() + 1));
        }
        files = src.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        for (i = 0; i < files.length; ++i) {
            List<String> deeperList = this.getJavaSources(rootSrc, files[i]);
            result.addAll(deeperList);
        }
        return result;
    }

    public abstract void addFiles(Archive var1) throws GenBaseException;

    public Config getConfig() {
        return this.config;
    }

    public static Logger getLogger() {
        return logger;
    }

    public File getClasses() {
        return this.classes;
    }

    public File getSources() {
        return this.sources;
    }
}

