/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.Http11AprProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;

public class Http11AprProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected static Log log = LogFactory.getLog(Http11AprProtocol.class);
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    protected Adapter adapter;
    ObjectName tpOname;
    ObjectName rgOname;
    protected AprEndpoint endpoint = new AprEndpoint();
    protected HashMap<String, Object> attributes = new HashMap();
    private Http11ConnectionHandler cHandler = new Http11ConnectionHandler(this);
    protected int processorCache = -1;
    protected int socketBuffer = 9000;
    protected int maxSavePostSize = 4096;
    protected int maxHttpHeaderSize = 8192;
    protected boolean disableUploadTimeout = true;
    protected String compression = "off";
    protected String noCompressionUserAgents = null;
    protected String compressableMimeTypes = "text/html,text/xml,text/plain";
    protected int compressionMinSize = 2048;
    protected String restrictedUserAgents = null;
    protected String protocol = null;
    protected int maxKeepAliveRequests = 100;
    protected String server;
    protected int timeout = 300000;
    protected boolean secure;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public Http11AprProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public void setAttribute(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("http11protocol.setattribute", name, value));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        if (log.isTraceEnabled()) {
            log.trace(sm.getString("http11protocol.getattribute", key));
        }
        return this.attributes.get(key);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void init() throws Exception {
        this.endpoint.setName(this.getName());
        this.endpoint.setHandler(this.cHandler);
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.initerror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.init", this.getName()));
        }
    }

    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                log.error("Can't register threadpool");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.starterror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.start", this.getName()));
        }
    }

    public void pause() throws Exception {
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.pauseerror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.pause", this.getName()));
        }
    }

    public void resume() throws Exception {
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            log.error(sm.getString("http11protocol.endpoint.resumeerror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.resume", this.getName()));
        }
    }

    public void destroy() throws Exception {
        if (log.isInfoEnabled()) {
            log.info(sm.getString("http11protocol.stop", this.getName()));
        }
        this.endpoint.destroy();
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.endpoint.getPort();
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getSoTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.endpoint.setSoTimeout(soTimeout);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int timeout) {
        this.endpoint.setKeepAliveTimeout(timeout);
    }

    public boolean getUseSendfile() {
        return this.endpoint.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        this.endpoint.setUseSendfile(useSendfile);
    }

    public int getPollTime() {
        return this.endpoint.getPollTime();
    }

    public void setPollTime(int pollTime) {
        this.endpoint.setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        this.endpoint.setPollerSize(pollerSize);
    }

    public int getPollerSize() {
        return this.endpoint.getPollerSize();
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        this.endpoint.setPollerThreadCount(pollerThreadCount);
    }

    public int getPollerThreadCount() {
        return this.endpoint.getPollerThreadCount();
    }

    public int getSendfileSize() {
        return this.endpoint.getSendfileSize();
    }

    public void setSendfileSize(int sendfileSize) {
        this.endpoint.setSendfileSize(sendfileSize);
    }

    public void setSendfileThreadCount(int sendfileThreadCount) {
        this.endpoint.setSendfileThreadCount(sendfileThreadCount);
    }

    public int getSendfileThreadCount() {
        return this.endpoint.getSendfileThreadCount();
    }

    public boolean getDeferAccept() {
        return this.endpoint.getDeferAccept();
    }

    public void setDeferAccept(boolean deferAccept) {
        this.endpoint.setDeferAccept(deferAccept);
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.setSecure(true);
        this.protocol = protocol;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public boolean getKeepAlive() {
        return this.maxKeepAliveRequests != 0 && this.maxKeepAliveRequests != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public boolean isSSLEnabled() {
        return this.endpoint.isSSLEnabled();
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.endpoint.setSSLEnabled(SSLEnabled);
    }

    public String getSSLProtocol() {
        return this.endpoint.getSSLProtocol();
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.endpoint.setSSLProtocol(SSLProtocol);
    }

    public String getSSLPassword() {
        return this.endpoint.getSSLPassword();
    }

    public void setSSLPassword(String SSLPassword) {
        this.endpoint.setSSLPassword(SSLPassword);
    }

    public String getSSLCipherSuite() {
        return this.endpoint.getSSLCipherSuite();
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.endpoint.setSSLCipherSuite(SSLCipherSuite);
    }

    public String getSSLCertificateFile() {
        return this.endpoint.getSSLCertificateFile();
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.endpoint.setSSLCertificateFile(SSLCertificateFile);
    }

    public String getSSLCertificateKeyFile() {
        return this.endpoint.getSSLCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.endpoint.setSSLCertificateKeyFile(SSLCertificateKeyFile);
    }

    public String getSSLCertificateChainFile() {
        return this.endpoint.getSSLCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.endpoint.setSSLCertificateChainFile(SSLCertificateChainFile);
    }

    public String getSSLCACertificatePath() {
        return this.endpoint.getSSLCACertificatePath();
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.endpoint.setSSLCACertificatePath(SSLCACertificatePath);
    }

    public String getSSLCACertificateFile() {
        return this.endpoint.getSSLCACertificateFile();
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.endpoint.setSSLCACertificateFile(SSLCACertificateFile);
    }

    public String getSSLCARevocationPath() {
        return this.endpoint.getSSLCARevocationPath();
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.endpoint.setSSLCARevocationPath(SSLCARevocationPath);
    }

    public String getSSLCARevocationFile() {
        return this.endpoint.getSSLCARevocationFile();
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.endpoint.setSSLCARevocationFile(SSLCARevocationFile);
    }

    public String getSSLVerifyClient() {
        return this.endpoint.getSSLVerifyClient();
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.endpoint.setSSLVerifyClient(SSLVerifyClient);
    }

    public int getSSLVerifyDepth() {
        return this.endpoint.getSSLVerifyDepth();
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.endpoint.setSSLVerifyDepth(SSLVerifyDepth);
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    static class Http11ConnectionHandler
    implements AprEndpoint.Handler {
        protected Http11AprProtocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<Long, Http11AprProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<Http11AprProcessor> recycledProcessors = new ConcurrentLinkedQueue<Http11AprProcessor>(){
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(Http11AprProcessor processor) {
                boolean offer = Http11ConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < Http11ConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    Http11ConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public Http11AprProcessor poll() {
                Http11AprProcessor result = (Http11AprProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                Http11AprProcessor next = this.poll();
                while (next != null) {
                    Http11ConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        Http11ConnectionHandler(Http11AprProtocol proto) {
            this.proto = proto;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AprEndpoint.Handler.SocketState event(long socket, SocketStatus status) {
            Http11AprProcessor result = this.connections.get(socket);
            AprEndpoint.Handler.SocketState state = AprEndpoint.Handler.SocketState.CLOSED;
            if (result != null) {
                try {
                    state = result.event(status);
                }
                catch (SocketException e) {
                    log.debug(sm.getString("http11protocol.proto.socketexception.debug"), e);
                }
                catch (IOException e) {
                    log.debug(sm.getString("http11protocol.proto.ioexception.debug"), e);
                }
                catch (Throwable e) {
                    log.error(sm.getString("http11protocol.proto.error"), e);
                }
                finally {
                    if (state != AprEndpoint.Handler.SocketState.LONG) {
                        this.connections.remove(socket);
                        this.recycledProcessors.offer(result);
                        if (state == AprEndpoint.Handler.SocketState.OPEN) {
                            this.proto.endpoint.getPoller().add(socket);
                        }
                    } else {
                        this.proto.endpoint.getCometPoller().add(socket);
                    }
                }
            }
            return state;
        }

        public AprEndpoint.Handler.SocketState process(long socket) {
            Http11AprProcessor processor = this.recycledProcessors.poll();
            try {
                AprEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_START, null);
                }
                if ((state = processor.process(socket)) == AprEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    this.proto.endpoint.getCometPoller().add(socket);
                } else {
                    this.recycledProcessors.offer(processor);
                }
                return state;
            }
            catch (SocketException e) {
                log.debug(sm.getString("http11protocol.proto.socketexception.debug"), e);
            }
            catch (IOException e) {
                log.debug(sm.getString("http11protocol.proto.ioexception.debug"), e);
            }
            catch (Throwable e) {
                log.error(sm.getString("http11protocol.proto.error"), e);
            }
            this.recycledProcessors.offer(processor);
            return AprEndpoint.Handler.SocketState.CLOSED;
        }

        protected Http11AprProcessor createProcessor() {
            Http11AprProcessor processor = new Http11AprProcessor(this.proto.maxHttpHeaderSize, this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.maxKeepAliveRequests);
            processor.setTimeout(this.proto.timeout);
            processor.setDisableUploadTimeout(this.proto.disableUploadTimeout);
            processor.setCompressionMinSize(this.proto.compressionMinSize);
            processor.setCompression(this.proto.compression);
            processor.setNoCompressionUserAgents(this.proto.noCompressionUserAgents);
            processor.setCompressableMimeTypes(this.proto.compressableMimeTypes);
            processor.setRestrictedUserAgents(this.proto.restrictedUserAgents);
            processor.setSocketBuffer(this.proto.socketBuffer);
            processor.setMaxSavePostSize(this.proto.maxSavePostSize);
            processor.setServer(this.proto.server);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(Http11AprProcessor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=HttpRequest" + count);
                        if (log.isDebugEnabled()) {
                            log.debug("Register " + rpName);
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        log.warn("Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Http11AprProcessor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (log.isDebugEnabled()) {
                            log.debug("Unregister " + rpName);
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn("Error unregistering request", e);
                    }
                }
            }
        }
    }
}

