/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.gui.impl;

import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.EventListenerList;
import org.apache.felix.shell.gui.Plugin;
import org.apache.felix.shell.gui.impl.ShellPanel;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    private BundleContext m_context = null;
    private List m_pluginList = new ArrayList();
    private EventListenerList m_listenerList = new EventListenerList();
    private JFrame m_frame = null;
    public static final String PLUGIN_LIST_PROPERTY = "pluginList";

    public synchronized int getPluginCount() {
        if (this.m_pluginList == null) {
            return 0;
        }
        return this.m_pluginList.size();
    }

    public synchronized Plugin getPlugin(int i) {
        if (i < 0 || i >= this.getPluginCount()) {
            return null;
        }
        return (Plugin)this.m_pluginList.get(i);
    }

    public synchronized boolean pluginExists(Plugin plugin) {
        for (int i = 0; i < this.m_pluginList.size(); ++i) {
            if (this.m_pluginList.get(i) != plugin) continue;
            return true;
        }
        return false;
    }

    public void start(BundleContext context) {
        this.m_context = context;
        ServiceListener sl = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceChanged(ServiceEvent event) {
                ServiceReference ref = event.getServiceReference();
                Object svcObj = Activator.this.m_context.getService(ref);
                if (event.getType() == 1 && svcObj instanceof Plugin) {
                    Activator activator = Activator.this;
                    synchronized (activator) {
                        if (!Activator.this.m_pluginList.contains(svcObj)) {
                            Activator.this.m_pluginList.add(svcObj);
                            Activator.this.firePropertyChangedEvent(Activator.PLUGIN_LIST_PROPERTY, null, null);
                        }
                    }
                } else if (event.getType() == 4 && svcObj instanceof Plugin) {
                    Activator activator = Activator.this;
                    synchronized (activator) {
                        Activator.this.m_pluginList.remove(svcObj);
                        Activator.this.firePropertyChangedEvent(Activator.PLUGIN_LIST_PROPERTY, null, null);
                    }
                } else {
                    Activator.this.m_context.ungetService(ref);
                }
            }
        };
        try {
            this.m_context.addServiceListener(sl, "(objectClass=" + Plugin.class.getName() + ")");
        }
        catch (InvalidSyntaxException ex) {
            System.err.println("ShellGuiActivator: Cannot add service listener.");
            System.err.println("ShellGuiActivator: " + (Object)((Object)ex));
        }
        this.initializePlugins();
        if (this.m_frame == null) {
            ShellPanel panel = new ShellPanel(this);
            this.m_frame = new JFrame("Felix GUI Shell");
            this.m_frame.getContentPane().setLayout(new BorderLayout());
            this.m_frame.getContentPane().add(panel);
            this.m_frame.pack();
            this.m_frame.setSize(700, 400);
            this.m_frame.setDefaultCloseOperation(0);
            this.m_frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    if (Activator.this.m_context.getBundle().getState() == 32) {
                        try {
                            Activator.this.m_context.getBundle().stop();
                        }
                        catch (Exception ex) {
                            System.err.println("ShellGuiActivator: " + ex);
                        }
                    }
                }
            });
        }
        this.m_frame.setVisible(true);
    }

    private synchronized void initializePlugins() {
        try {
            ServiceReference[] refs = this.m_context.getServiceReferences(Plugin.class.getName(), null);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    Object svcObj = this.m_context.getService(refs[i]);
                    if (this.m_pluginList.contains(svcObj)) continue;
                    this.m_pluginList.add(svcObj);
                }
                this.firePropertyChangedEvent(PLUGIN_LIST_PROPERTY, null, null);
            }
        }
        catch (Exception ex) {
            System.err.println("ShellGuiActivator: Error initializing model list.");
            System.err.println("ShellGuiActivator: " + ex);
            ex.printStackTrace();
        }
    }

    public void stop(BundleContext context) {
        if (this.m_frame != null) {
            this.m_frame.setVisible(false);
            this.m_frame.dispose();
            this.m_frame = null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_listenerList.add(PropertyChangeListener.class, l);
    }

    public void removeFooListener(PropertyChangeListener l) {
        this.m_listenerList.remove(PropertyChangeListener.class, l);
    }

    protected void firePropertyChangedEvent(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent event = null;
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$beans$PropertyChangeListener == null ? Activator.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
            if (event == null) {
                event = new PropertyChangeEvent(this, name, oldValue, newValue);
            }
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }
}

