/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.metainfo;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbFilter;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.metainfo.lib.BasicMappingStructure;

public class RdbPrimitiveElementMapping
extends BasicMappingStructure
implements PrimitiveElementMapping,
Comparable {
    private String name;
    private String type;
    private boolean notNull;
    private Map join2pe;

    public RdbPrimitiveElementMapping(String name, String type, boolean notNull, MetaObject linkedMO, MetaObject parent) {
        super(parent, linkedMO);
        this.name = name;
        this.type = type;
        this.notNull = notNull;
        this.join2pe = new TreeMap();
    }

    public RdbPrimitiveElementMapping(String name, String type, boolean notNull, MetaObject linkedMO, MetaObject parent, RdbJoin join) {
        this(name, type, notNull, linkedMO, parent);
        this.join2pe.put(join, linkedMO);
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((RdbPrimitiveElementMapping)o).getName());
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public RdbFilter getRdbFilter() {
        RdbFilter filter = ((RdbClassMapping)this.getParent().getParent()).getRdbFilter();
        return filter;
    }

    public boolean isFilter() {
        RdbFilter filter = this.getRdbFilter();
        if (filter == null) {
            return false;
        }
        return filter.isFilter((PrimitiveElement)this.linkedMO);
    }

    public String getEqualPredicateValue() throws PException {
        RdbFilter filter = this.getRdbFilter();
        return filter.getEqualPredicateValue(((PrimitiveElement)this.linkedMO).getName());
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public void setName(String columnName) {
        this.name = columnName;
    }

    public void setType(String sqlType) {
        this.type = sqlType;
    }

    public void setIsNotNull(boolean isNotNull) {
        this.notNull = isNotNull;
    }

    public void bindPrimitiveElement(RdbJoin join, PrimitiveElement pe) {
        this.join2pe.put(join, pe);
    }

    public PrimitiveElement lookupPrimitiveElement(RdbJoin join) {
        return (PrimitiveElement)this.join2pe.get(join);
    }

    public Map getPrimitiveElementByRdbJoin() {
        return this.join2pe;
    }

    public RdbJoin getJoinByPrimitiveElement(PrimitiveElement pe) {
        RdbJoin join = null;
        if (!this.join2pe.keySet().isEmpty()) {
            Iterator joinIterator = this.join2pe.keySet().iterator();
            while (joinIterator.hasNext()) {
                RdbJoin currentJoin = (RdbJoin)joinIterator.next();
                if (this.join2pe.get(currentJoin) != pe) continue;
                join = currentJoin;
                return join;
            }
        }
        return join;
    }
}

