/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.resource;

import java.io.InputStream;
import java.net.URL;
import org.apache.cxf.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderResolver
implements ResourceResolver {
    private final ClassLoader loader;

    public ClassLoaderResolver() {
        this(ClassLoaderResolver.class.getClassLoader());
    }

    public ClassLoaderResolver(ClassLoader l) {
        this.loader = l;
    }

    @Override
    public <T> T resolve(String resourceName, Class<T> resourceType) {
        if (resourceName == null || resourceType == null) {
            return null;
        }
        URL url = this.loader.getResource(resourceName);
        if (resourceType.isInstance(url)) {
            return resourceType.cast(url);
        }
        return null;
    }

    @Override
    public InputStream getAsStream(String name) {
        return this.loader.getResourceAsStream(name);
    }
}

