/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Vector;
import javax.transaction.xa.XAException;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.jotm.RecoverRmInfo;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.TxRecovered;
import org.objectweb.jotm.TxxidRecovered;
import org.objectweb.jotm.XidImpl;
import org.objectweb.jotm.processResourceManager;

public class JotmRecovery {
    private static JotmRecovery unique = null;
    private static Vector vTxRecovered = new Vector();
    private static Vector vRecoverRmInfo = new Vector();
    private Vector userRecoveryRecords = new Vector();

    public JotmRecovery() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"JotmRecovery constructor");
        }
        unique = this;
    }

    public static JotmRecovery getJotmRecovery() {
        return unique;
    }

    public static Vector getTxRecovered() {
        return vTxRecovered;
    }

    public static Vector getRecoverRmInfo() {
        return vRecoverRmInfo;
    }

    public Vector getmyRecoverRmInfo() {
        return vRecoverRmInfo;
    }

    public int getRmIndex(byte[] pxares) {
        int numRm = vRecoverRmInfo.size();
        for (int i = 0; i < numRm; ++i) {
            RecoverRmInfo myrecoverRmInfo = (RecoverRmInfo)vRecoverRmInfo.elementAt(i);
            byte[] inrmxares = myrecoverRmInfo.getRecoverXaRes();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("XAResource param " + Arrays.toString(pxares)));
                TraceTm.recovery.debug((Object)("XAResource in rm " + Arrays.toString(inrmxares)));
            }
            if (inrmxares != pxares) continue;
            return myrecoverRmInfo.getRecoverIndex();
        }
        return 99;
    }

    public Vector getUserRecoveryVector() {
        return this.userRecoveryRecords;
    }

    public void rebuildTransaction(XALogRecord lr) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"rebuildTransaction");
        }
        byte[] rt = new byte[3];
        int xarescount = 0;
        byte[] rt2 = new byte[3];
        XACommittingTx myxacommittx = lr.getTx();
        byte[] tempRec = lr.getFields()[0];
        ByteBuffer rr = ByteBuffer.wrap(tempRec);
        rr.get(rt, 0, 3);
        String trt = new String(rt);
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("Recovery Record type= " + trt));
        }
        if (trt.equals("RM1")) {
            Long rmdatetime = rr.getLong();
            int rmcount = rr.getInt();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("Resource Manager count= " + rmcount));
            }
            for (int i = 1; i <= rmcount; ++i) {
                byte[] resmgr2 = lr.getFields()[i];
                ByteBuffer resm2 = ByteBuffer.wrap(resmgr2);
                resm2.get(rt2, 0, 3);
                trt = new String(rt2);
                if (!trt.equals("RM2")) continue;
                int rmlength = resm2.getInt();
                byte[] rmname = new byte[rmlength];
                resm2.get(rmname, 0, rmlength);
                int xareslength = resm2.getInt();
                byte[] xares = new byte[xareslength];
                resm2.get(xares, 0, xareslength);
                int xaresnamelength = resm2.getInt();
                byte[] xaresname = new byte[xaresnamelength];
                resm2.get(xaresname, 0, xaresnamelength);
                int rmindx = resm2.getInt();
                String myrmname = new String(rmname);
                String myxaresname = new String(xaresname);
                RecoverRmInfo myrecoverRmInfo = new RecoverRmInfo();
                myrecoverRmInfo.addRecoverRmXaRes(myrmname, xares, myxaresname, rmindx);
                vRecoverRmInfo.addElement(myrecoverRmInfo);
            }
        } else if (trt.equals("RR1")) {
            long rcdatetime = rr.getLong();
            int txxidlength = rr.getInt();
            byte[] txXid = new byte[txxidlength];
            rr.get(txXid, 0, txxidlength);
            int txdatelength = rr.getInt();
            byte[] txdatetime = new byte[txdatelength];
            rr.get(txdatetime, 0, txdatelength);
            xarescount = rr.getInt();
            String mytxdatetime = new String(txdatetime);
            TxRecovered mytxRecovered = new TxRecovered();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("XAResource count= " + xarescount));
            }
            mytxRecovered.addtxrecovered(rcdatetime, txXid, mytxdatetime, xarescount, myxacommittx);
            for (int i = 1; i <= xarescount; ++i) {
                TxxidRecovered myrecoverTxInfo = new TxxidRecovered();
                byte[] recov2 = lr.getFields()[i];
                ByteBuffer rr2 = ByteBuffer.wrap(recov2);
                rr2.get(rt2, 0, 3);
                trt = new String(rt2);
                if (!trt.equals("RR2")) continue;
                int xaresindex = rr2.getInt();
                int xareslength = rr2.getInt();
                byte[] xares = new byte[xareslength];
                rr2.get(xares, 0, xareslength);
                int xaresnamelength = rr2.getInt();
                byte[] xaresname = new byte[xaresnamelength];
                rr2.get(xaresname, 0, xaresnamelength);
                int xidlength = rr2.getInt();
                byte[] recoveryxid = new byte[xidlength];
                rr2.get(recoveryxid, 0, xidlength);
                int xidstatus = rr2.getInt();
                String myxaresname = new String(xaresname);
                myrecoverTxInfo.addXidInfo(xaresindex, xares, myxaresname, recoveryxid, xidstatus);
                mytxRecovered.setRecoverTxXidInfo(myrecoverTxInfo, i - 1);
            }
            vTxRecovered.addElement(mytxRecovered);
        } else if (trt.equals("RU1")) {
            XidImpl.setUuids(rr.getLong(), rr.getLong());
        } else {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("Unknown record type during replay = " + trt));
            }
            rr.rewind();
            this.userRecoveryRecords.add(rr);
            this.userRecoveryRecords.add(myxacommittx);
        }
    }

    public void recoverTransactions(Vector rmreg) throws XAException {
        int i;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"recoverTransactions");
        }
        int rmregsize = rmreg.size();
        int rmsize = vRecoverRmInfo.size();
        if (rmsize == 0) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"Nothing to recover");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("number Resource Manager recover= " + rmsize));
        }
        ThreadGroup resourceManagerThreadGroup = new ThreadGroup("ResourceManagerTG");
        for (i = 0; i < rmregsize; ++i) {
            RmRegistration myrmreg = (RmRegistration)rmreg.elementAt(i);
            String myregrm = myrmreg.rmGetName();
            processResourceManager rmthread = new processResourceManager(resourceManagerThreadGroup, vTxRecovered, vRecoverRmInfo, rmreg, rmsize, i);
            Thread processrm = new Thread(resourceManagerThreadGroup, rmthread, myregrm);
            processrm.start();
        }
        for (int w = 0; w < 10; ++w) {
            boolean rmsinthread = false;
            int numThreads = resourceManagerThreadGroup.activeCount();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("resourceManager active count= " + numThreads));
            }
            if (numThreads == 0) break;
            Thread[] listOfThreads = new Thread[numThreads];
            resourceManagerThreadGroup.enumerate(listOfThreads);
            for (int i2 = 0; i2 < numThreads; ++i2) {
                if (listOfThreads[i2] == null) continue;
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)("resourceManager in thread= " + listOfThreads[i2].getName()));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                rmsinthread = true;
                break;
            }
            if (!rmsinthread) break;
        }
        this.doCleanupXidRecover();
        for (i = 0; i < rmregsize; ++i) {
            RmRegistration myrmreg = (RmRegistration)rmreg.elementAt(i);
            myrmreg.rmSetRmRecovered(true);
        }
    }

    private void doCleanupXidRecover() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"doCleanupXidRecover");
        }
        TxxidRecovered myTxxidRecovered = null;
        TxRecovered mytxRecovered = null;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("vTxRecovered.size= " + vTxRecovered.size()));
        }
        for (int i = vTxRecovered.size() - 1; i >= 0; --i) {
            boolean possibleheuristic = false;
            XACommittingTx myxacommittingtx = null;
            mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("mytxRecovered.xidcount= " + mytxRecovered.getxidcount()));
            }
            for (int j = 0; j < mytxRecovered.getxidcount(); ++j) {
                myTxxidRecovered = mytxRecovered.getRecoverTxXidInfo(j);
                if (myTxxidRecovered == null || myTxxidRecovered.getRecoveraction() == 0 || myTxxidRecovered.getRecoveraction() == 1) continue;
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)"possibleheuristic");
                }
                possibleheuristic = true;
            }
            if (possibleheuristic) continue;
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"write howlDonelog");
            }
            myxacommittingtx = mytxRecovered.getXACommittingTx();
            byte[] rmDone = new byte[11];
            byte[][] rmDoneRecord = new byte[1][11];
            rmDone = "RR3JOTMDONE".getBytes();
            try {
                rmDoneRecord[0] = rmDone;
                TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(rmDoneRecord, myxacommittingtx);
            }
            catch (Exception f) {
                String howlerror = "Cannot howlDoneLog:" + f + "--" + f.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + howlerror));
            }
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"remove txRecovered entry");
            }
            vTxRecovered.remove(i);
        }
    }
}

