/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.provider;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.rmi.PortableRemoteObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.annotation.Cluster;
import org.ow2.cmi.annotation.Policy;
import org.ow2.cmi.annotation.Strategy;
import org.ow2.cmi.controller.client.IUpdatedClientConfig;
import org.ow2.cmi.controller.common.ClusterViewManagerException;
import org.ow2.cmi.controller.common.ImmutableClusteredObjectInfos;
import org.ow2.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.cmi.controller.provider.ClientClusterViewProviderException;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.lb.policy.FirstAvailable;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.lb.strategy.LocalPreference;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cluster(name="System")
@Policy(value=FirstAvailable.class)
@Strategy(value=LocalPreference.class)
@ThreadSafe
public class ClusteredClientClusterViewProvider
extends PortableRemoteObject
implements ClientClusterViewProvider {
    private static Log logger = LogFactory.getLog(ClusteredClientClusterViewProvider.class);
    private final ServerClusterViewManager serverClusterViewManager;
    private static final int BUF_APPEND = 1000;

    public ClusteredClientClusterViewProvider(ServerClusterViewManager serverClusterViewManager) throws RemoteException {
        this.serverClusterViewManager = serverClusterViewManager;
    }

    @Override
    public int getDelayToRefresh() throws RemoteException {
        return this.serverClusterViewManager.getDelayToRefresh();
    }

    @Override
    public Class<? extends IPolicy<?>> getPolicyClass(String objectName) throws RemoteException, ObjectNotFoundException, ClusterViewManagerException {
        return this.serverClusterViewManager.getPolicyClass(objectName);
    }

    @Override
    public Class<? extends IStrategy<?>> getStrategyClass(String objectName) throws RemoteException, ObjectNotFoundException, ClusterViewManagerException {
        return this.serverClusterViewManager.getStrategyClass(objectName);
    }

    @Override
    public Collection<CMIReference> getCMIReferences(String objectName, String protocolName) throws RemoteException, ObjectNotFoundException {
        HashSet<Object> qualities = new HashSet<Object>();
        return this.serverClusterViewManager.getCMIReferences(objectName, protocolName, qualities);
    }

    @Override
    public Map<String, Object> getPropertiesForPolicy(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getPropertiesForPolicy(objectName);
    }

    @Override
    public long getDateOfProperties(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getDateOfProperties(objectName);
    }

    @Override
    public byte[] getBytecode(String binaryName) throws RemoteException, ClientClusterViewProviderException {
        String encodedClassName = binaryName.replaceAll("\\.", "/").concat(".class");
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(encodedClassName);
        byte[] bytecode = null;
        try {
            bytecode = ClusteredClientClusterViewProvider.readClass(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            logger.error((Object)"Cannot read class {0}", new Object[]{binaryName, e});
            throw new ClientClusterViewProviderException("Cannot read class " + binaryName, e);
        }
        return bytecode;
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Given input stream is null");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    @Override
    public boolean isClustered(String name) throws RemoteException {
        return this.serverClusterViewManager.isClustered(name);
    }

    @Override
    public String getPolicyClassName(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getPolicyClassName(objectName);
    }

    @Override
    public IPoolConfiguration getPoolConfiguration(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getPoolConfiguration(objectName);
    }

    @Override
    public String getStrategyClassName(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getStrategyClassName(objectName);
    }

    @Override
    public boolean isPoolToEmpty(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.isPoolToEmpty(objectName);
    }

    @Override
    public int getLoadFactor(ServerRef serverRef) throws RemoteException, ServerNotFoundException {
        return this.serverClusterViewManager.getLoadFactor(serverRef);
    }

    @Override
    public void registerClient(UUID uuid) throws RemoteException {
        this.serverClusterViewManager.registerClient(uuid);
    }

    @Override
    public boolean isReplicated(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.isReplicated(objectName);
    }

    @Override
    public IUpdatedClientConfig getConfiguration() throws RemoteException {
        return this.serverClusterViewManager.getClientConfig();
    }

    @Override
    public long getDateOfConfiguration() throws RemoteException {
        return this.serverClusterViewManager.getDateOfConfiguration();
    }

    @Override
    public ImmutableClusteredObjectInfos getImmutableInfos(String objectName) throws RemoteException, ObjectNotFoundException {
        return this.serverClusterViewManager.getImmutableInfos(objectName);
    }
}

