/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.SecurityRole;
import org.ow2.jonas.deployment.web.MethodsDesc;
import org.ow2.jonas.deployment.web.Pattern;
import org.ow2.jonas.deployment.web.PatternEntry;
import org.ow2.jonas.deployment.web.xml.AuthConstraint;
import org.ow2.jonas.deployment.web.xml.SecurityConstraint;
import org.ow2.jonas.deployment.web.xml.UserDataConstraint;
import org.ow2.jonas.deployment.web.xml.WebApp;
import org.ow2.jonas.deployment.web.xml.WebResourceCollection;
import org.ow2.jonas.lib.util.Log;

public class SecurityConstraintListDesc {
    private static final String DEFAULT_PATTERN = "/";
    private WebApp webApp = null;
    private Map mapPatterns = null;
    private PermissionCollection excludedPermissions = null;
    private PermissionCollection uncheckedPermissions = null;
    private Map permissionsByRole = null;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.security.jacc");

    public SecurityConstraintListDesc(WebApp webApp) {
        this.webApp = webApp;
        this.mapPatterns = new HashMap();
        this.excludedPermissions = new Permissions();
        this.uncheckedPermissions = new Permissions();
        this.permissionsByRole = new HashMap();
        try {
            this.initConstraints();
            this.qualifyPatterns();
            this.buildPermissions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initConstraints() {
        String[] securityRoles = new String[this.webApp.getSecurityRoleList().size()];
        int r = 0;
        Iterator itSecurityRoles = this.webApp.getSecurityRoleList().iterator();
        while (itSecurityRoles.hasNext()) {
            securityRoles[r] = ((SecurityRole)itSecurityRoles.next()).getRoleName();
            ++r;
        }
        SecurityConstraint securityConstraint2 = null;
        for (SecurityConstraint securityConstraint2 : this.webApp.getSecurityConstraintList()) {
            JLinkedList webResourceCollectionList = securityConstraint2.getWebResourceCollectionList();
            AuthConstraint authConstraint = securityConstraint2.getAuthConstraint();
            UserDataConstraint userDataConstraint = securityConstraint2.getUserDataConstraint();
            JLinkedList rolesList = null;
            boolean hasAuthConstraint = false;
            boolean isExcludingAuthConstraint = false;
            if (authConstraint != null) {
                rolesList = authConstraint.getRoleNameList();
                hasAuthConstraint = true;
                isExcludingAuthConstraint = rolesList.size() == 0;
            }
            String transportGuarantee = null;
            if (userDataConstraint != null) {
                transportGuarantee = userDataConstraint.getTransportGuarantee();
            }
            WebResourceCollection webRC2 = null;
            for (WebResourceCollection webRC2 : webResourceCollectionList) {
                JLinkedList methodList = webRC2.getHttpMethodList();
                String urlPatternString2 = null;
                for (String urlPatternString2 : webRC2.getUrlPatternList()) {
                    PatternEntry patternEntry = (PatternEntry)this.mapPatterns.get(urlPatternString2);
                    if (patternEntry == null) {
                        patternEntry = new PatternEntry(urlPatternString2);
                        this.mapPatterns.put(urlPatternString2, patternEntry);
                    }
                    String[] methods = null;
                    methods = methodList.isEmpty() ? MethodsDesc.METHODS : methodList.toArray(new String[methodList.size()]);
                    if (hasAuthConstraint) {
                        if (isExcludingAuthConstraint) {
                            patternEntry.addExcludedMethods(methods, transportGuarantee);
                            continue;
                        }
                        for (String roleName : rolesList) {
                            if (roleName.equals("*")) {
                                patternEntry.addMethodsOnRoles(methods, securityRoles, transportGuarantee);
                                continue;
                            }
                            patternEntry.addMethodsOnRole(methods, roleName, transportGuarantee);
                        }
                        continue;
                    }
                    patternEntry.addUncheckedMethods(methods, transportGuarantee);
                }
            }
        }
    }

    private synchronized void qualifyPatterns() {
        PatternEntry defaultPatternEntry = (PatternEntry)this.mapPatterns.get(DEFAULT_PATTERN);
        if (defaultPatternEntry == null) {
            defaultPatternEntry = new PatternEntry(DEFAULT_PATTERN);
            defaultPatternEntry.setUncheckedLastEntry();
            this.mapPatterns.put(DEFAULT_PATTERN, defaultPatternEntry);
        }
        PatternEntry patternEntry = null;
        Pattern otherPattern2 = null;
        String patternString2 = null;
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String patternString2 : this.mapPatterns.keySet()) {
            patterns.add(new Pattern(patternString2));
        }
        Collections.sort(patterns);
        Pattern pattern = null;
        for (String patternString2 : this.mapPatterns.keySet()) {
            pattern = new Pattern(patternString2);
            patternEntry = (PatternEntry)this.mapPatterns.get(patternString2);
            for (Pattern otherPattern2 : patterns) {
                if (pattern.isPathPrefix() && pattern.isMatching(otherPattern2)) {
                    if (otherPattern2.isPathPrefix() && !pattern.equals(otherPattern2)) {
                        patternEntry.addQualifiedPattern(otherPattern2);
                        continue;
                    }
                    if (!otherPattern2.isExactPattern()) continue;
                    patternEntry.addQualifiedPattern(otherPattern2);
                    continue;
                }
                if (pattern.isExtensionPattern()) {
                    if (!otherPattern2.isPathPrefix() && (!pattern.isMatching(otherPattern2) || !otherPattern2.isExactPattern())) continue;
                    patternEntry.addQualifiedPattern(otherPattern2);
                    continue;
                }
                if (!pattern.isDefaultPattern() || otherPattern2.isDefaultPattern()) continue;
                patternEntry.addQualifiedPattern(otherPattern2);
            }
        }
    }

    private void buildPermissions() {
        PatternEntry patternEntry2 = null;
        for (PatternEntry patternEntry2 : this.mapPatterns.values()) {
            if (patternEntry2.isIrrelevant()) continue;
            if (patternEntry2.isUncheckedLastEntry()) {
                this.addUncheckedPermissions(patternEntry2.getUncheckedPermissions());
                continue;
            }
            this.addExcludedPermissions(patternEntry2.getExcludedPermissions());
            this.addUncheckedPermissions(patternEntry2.getUncheckedPermissions());
            this.addRolePermissions(patternEntry2.getRolesPermissionsMap());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Excluded permissions = " + this.excludedPermissions));
            logger.log(BasicLevel.DEBUG, (Object)("Unchecked permissions = " + this.uncheckedPermissions));
            logger.log(BasicLevel.DEBUG, (Object)"Roles Permissions = ");
            String roleName2 = null;
            for (String roleName2 : this.permissionsByRole.keySet()) {
                logger.log(BasicLevel.DEBUG, (Object)("Permissions for role " + roleName2 + " are " + this.permissionsByRole.get(roleName2)));
            }
        }
    }

    private void addExcludedPermissions(PermissionCollection permissions) {
        if (permissions == null) {
            return;
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            this.excludedPermissions.add(e.nextElement());
        }
    }

    private void addUncheckedPermissions(PermissionCollection permissions) {
        if (permissions == null) {
            return;
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            this.uncheckedPermissions.add(e.nextElement());
        }
    }

    private void addRolePermissions(Map rolePermissionsMap) {
        if (rolePermissionsMap == null) {
            return;
        }
        String roleName2 = null;
        PermissionCollection permissions = null;
        PermissionCollection existingRolePermissions = null;
        for (String roleName2 : rolePermissionsMap.keySet()) {
            permissions = (PermissionCollection)rolePermissionsMap.get(roleName2);
            if (permissions == null) continue;
            existingRolePermissions = (PermissionCollection)this.permissionsByRole.get(roleName2);
            if (existingRolePermissions == null) {
                existingRolePermissions = new Permissions();
                this.permissionsByRole.put(roleName2, existingRolePermissions);
            }
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                existingRolePermissions.add(e.nextElement());
            }
        }
    }

    public PermissionCollection getExcludedPermissions() {
        return this.excludedPermissions;
    }

    public PermissionCollection getUncheckedPermissions() {
        return this.uncheckedPermissions;
    }

    public Map getPermissionsByRole() {
        return this.permissionsByRole;
    }
}

