/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.XAResourceMngr;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class XAResource
implements javax.transaction.xa.XAResource {
    private boolean enlisted = false;
    private Xid currentXid = null;
    XAResourceMngr rm;
    Session sess;
    private static Logger logger = Debug.getLogger(XAResource.class.getName());

    public XAResource(XAResourceMngr rm, Session sess) {
        this.rm = rm;
        this.sess = sess;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" XAResource rm = " + rm + ", sess = " + sess));
        }
    }

    public void start(Xid xid, int flag) throws XAException {
        if (this.enlisted) {
            throw new XAException("Resource already enlisted.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": start(" + xid + ", " + flag + ")"));
        }
        this.rm.start(xid, flag, this.sess);
        this.enlisted = true;
        this.currentXid = xid;
    }

    public void end(Xid xid, int flag) throws XAException {
        if (!this.enlisted || !xid.equals(this.currentXid)) {
            throw new XAException("Resource is not enlisted in specified transaction.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": end(" + xid + ", " + flag + ")"));
        }
        this.rm.end(xid, flag, this.sess);
        this.enlisted = false;
        this.currentXid = null;
    }

    public int prepare(Xid xid) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": prepare(" + xid + ")"));
        }
        this.rm.prepare(xid);
        return 0;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": commit(" + xid + ", " + onePhase + ")"));
        }
        if (onePhase) {
            this.rm.prepare(xid);
        }
        this.rm.commit(xid);
    }

    public void rollback(Xid xid) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": rollback(" + xid + ")"));
        }
        if (this.enlisted && this.currentXid.equals(xid)) {
            this.rm.end(xid, 0x20000000, this.sess);
            this.enlisted = false;
            this.currentXid = null;
        }
        this.rm.rollback(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.rm.recover(flag);
    }

    public void forget(Xid xid) throws XAException {
        throw new XAException("Non implemented method.");
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(javax.transaction.xa.XAResource o) throws XAException {
        if (!(o instanceof XAResource)) {
            return false;
        }
        XAResource other = (XAResource)o;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": isSameRM  other.rm = " + other.rm + ", this.rm = " + this.rm + ", equals = " + this.rm.equals(other.rm)));
        }
        return this.rm.equals(other.rm);
    }
}

