/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.shared.admin.SetReader;
import org.objectweb.joram.shared.admin.SetWriter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ClusterDestination
extends Destination {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Debug.getLogger(ClusterDestination.class.getName());
    protected Hashtable cluster = null;

    public ClusterDestination() {
    }

    public ClusterDestination(Hashtable cluster) {
        this.cluster = cluster;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": cluster = " + cluster));
        }
    }

    public void setCluster(Hashtable cluster) {
        this.cluster = cluster;
    }

    public Hashtable getCluster() {
        return this.cluster;
    }

    public void addDestination(Destination dest) {
        String location = System.getProperty("location");
        this.addDestination(location, dest);
    }

    public void addDestination(String location, Destination dest) {
        if (this.cluster == null) {
            this.cluster = new Hashtable();
        }
        if (location == null) {
            String destname = dest.getName();
            location = "server" + destname.substring(0, destname.indexOf(46));
        }
        this.cluster.put(location, dest);
    }

    protected Destination getDestination() {
        if (this.cluster != null && !this.cluster.isEmpty()) {
            Destination dest = null;
            String location = System.getProperty("location");
            if (location == null || location.equals("")) {
                int idx = new Random().nextInt(this.cluster.size());
                Object[] key = this.cluster.keySet().toArray();
                location = (String)key[idx];
                System.setProperty("location", location);
            }
            if ((dest = (Destination)this.cluster.get(location)) == null) {
                Enumeration e = this.cluster.elements();
                dest = (Destination)e.nextElement();
            }
            return dest;
        }
        return null;
    }

    public String getName() {
        return this.getDestination().getName();
    }

    public void setReader(User user) throws ConnectException, AdminException {
        Enumeration dests = this.cluster.elements();
        while (dests.hasMoreElements()) {
            Destination dest = (Destination)dests.nextElement();
            AdminModule.doRequest(new SetReader(user.getProxyId(), dest.getName()));
        }
    }

    public void setWriter(User user) throws ConnectException, AdminException {
        Enumeration dests = this.cluster.elements();
        while (dests.hasMoreElements()) {
            Destination dest = (Destination)dests.nextElement();
            AdminModule.doRequest(new SetWriter(user.getProxyId(), dest.getName()));
        }
    }

    public void setFreeReading() throws ConnectException, AdminException {
        Enumeration dests = this.cluster.elements();
        while (dests.hasMoreElements()) {
            Destination dest = (Destination)dests.nextElement();
            AdminModule.doRequest(new SetReader(null, dest.getName()));
        }
    }

    public void setFreeWriting() throws ConnectException, AdminException {
        Enumeration dests = this.cluster.elements();
        while (dests.hasMoreElements()) {
            Destination dest = (Destination)dests.nextElement();
            AdminModule.doRequest(new SetWriter(null, dest.getName()));
        }
    }

    public void toReference(Reference ref) throws NamingException {
        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
        this.cluster.entrySet().toArray(entries);
        StringBuffer strbuf = new StringBuffer(20);
        for (int i = 0; i < entries.length; ++i) {
            strbuf.setLength(0);
            strbuf.append("cluster#").append(i).append(".key");
            ref.add(new StringRefAddr(strbuf.toString(), (String)entries[i].getKey()));
            Destination dest = (Destination)entries[i].getValue();
            strbuf.setLength(0);
            strbuf.append("cluster#").append(i).append(".destName");
            ref.add(new StringRefAddr(strbuf.toString(), dest.getName()));
        }
    }

    public void fromReference(Reference ref) throws NamingException {
        this.cluster = new Hashtable();
        int i = 0;
        Destination dest = null;
        StringBuffer strbuf = new StringBuffer(20);
        while (true) {
            strbuf.setLength(0);
            strbuf.append("cluster#").append(i).append(".key");
            RefAddr refAddr = ref.get(strbuf.toString());
            if (refAddr == null) break;
            strbuf.setLength(0);
            strbuf.append("cluster#").append(i).append(".destName");
            dest = this.isQueue() ? new Queue((String)ref.get(strbuf.toString()).getContent()) : new Topic((String)ref.get(strbuf.toString()).getContent());
            this.cluster.put((String)refAddr.getContent(), dest);
            ++i;
        }
    }

    public Hashtable code() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
        this.cluster.entrySet().toArray(entries);
        StringBuffer strbuf = new StringBuffer(20);
        for (int i = 0; i < entries.length; ++i) {
            strbuf.setLength(0);
            strbuf.append("cluster#").append(i).append(".key");
            h.put(strbuf.toString(), (String)entries[i].getKey());
            Destination dest = (Destination)entries[i].getValue();
            strbuf.setLength(0);
            strbuf.append("cluster#").append(i).append(".destName");
            h.put(strbuf.toString(), dest.getName());
        }
        return h;
    }

    public void decode(Hashtable h) {
        this.cluster = new Hashtable();
        int i = 0;
        Destination dest = null;
        StringBuffer strbuf = new StringBuffer(20);
        while (true) {
            strbuf.setLength(0);
            strbuf.append("cluster#").append(i).append(".key");
            String key = (String)h.get(strbuf.toString());
            if (key == null) break;
            strbuf.setLength(0);
            strbuf.append("cluster#").append(i).append(".destName");
            dest = this.isQueue() ? new Queue((String)h.get(strbuf.toString())) : new Topic((String)h.get(strbuf.toString()));
            this.cluster.put(key, dest);
            ++i;
        }
    }
}

