/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.tcp;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Daemon;
import fr.dyade.aaa.common.Debug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.objectweb.joram.mom.notifications.GetProxyIdNot;
import org.objectweb.joram.mom.proxies.GetConnectionNot;
import org.objectweb.joram.mom.proxies.OpenConnectionNot;
import org.objectweb.joram.mom.proxies.ReliableConnectionContext;
import org.objectweb.joram.mom.proxies.tcp.IOControl;
import org.objectweb.joram.mom.proxies.tcp.TcpConnection;
import org.objectweb.joram.mom.proxies.tcp.TcpProxyService;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.stream.MetaData;
import org.objectweb.joram.shared.stream.StreamUtil;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class TcpConnectionListener
extends Daemon {
    public static Logger logger = Debug.getLogger(TcpConnectionListener.class.getName());
    private TcpProxyService proxyService;
    private int timeout;

    public TcpConnectionListener(TcpProxyService proxyService, int timeout) {
        super("TcpConnectionListener");
        this.proxyService = proxyService;
        this.timeout = timeout;
    }

    public void run() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"TcpConnectionListener.run()");
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        while (this.running) {
            this.canStop = true;
            try {
                this.acceptConnection();
            }
            catch (Exception exception) {}
        }
    }

    private void acceptConnection() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"TcpConnectionListener.acceptConnection()");
        }
        Socket sock = this.proxyService.getServerSocket().accept();
        String inaddr = sock.getInetAddress().getHostAddress();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)" -> accept connection");
        }
        try {
            IOControl ioctrl;
            ReliableConnectionContext ctx;
            AgentId proxyId;
            sock.setTcpNoDelay(true);
            sock.setSoTimeout(this.timeout);
            InputStream is = sock.getInputStream();
            NetOutputStream nos = new NetOutputStream(sock);
            byte[] magic = StreamUtil.readByteArrayFrom(is, 8);
            for (int i = 0; i < 5; ++i) {
                if (magic[i] == MetaData.joramMagic[i]) continue;
                throw new IllegalAccessException("Bad magic number:" + new String(magic, 0, 5) + magic[5] + '.' + magic[6] + '/' + magic[7]);
            }
            if (magic[7] != MetaData.joramMagic[7]) {
                throw new IllegalAccessException("Bad protocol version number");
            }
            Identity identity = Identity.read(is);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> read identity = " + identity));
            }
            int key = StreamUtil.readIntFrom(is);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> read key = " + key));
            }
            int heartBeat = 0;
            if (key == -1) {
                heartBeat = StreamUtil.readIntFrom(is);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> read heartBeat = " + heartBeat));
                }
            }
            GetProxyIdNot gpin = new GetProxyIdNot(identity, inaddr);
            try {
                gpin.invoke(new AgentId(AgentServer.getServerId(), AgentServer.getServerId(), AgentId.JoramAdminStamp));
                proxyId = gpin.getProxyId();
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
                StreamUtil.writeTo(1, (OutputStream)nos);
                StreamUtil.writeTo(exc.getMessage(), (OutputStream)nos);
                nos.send();
                return;
            }
            if (key == -1) {
                OpenConnectionNot ocn = new OpenConnectionNot(true, heartBeat);
                ocn.invoke(proxyId);
                StreamUtil.writeTo(0, (OutputStream)nos);
                ctx = (ReliableConnectionContext)ocn.getConnectionContext();
                key = ctx.getKey();
                StreamUtil.writeTo(key, (OutputStream)nos);
                nos.send();
                ioctrl = new IOControl(sock);
            } else {
                GetConnectionNot gcn = new GetConnectionNot(key);
                try {
                    gcn.invoke(proxyId);
                }
                catch (Exception exc) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                    }
                    StreamUtil.writeTo(1, (OutputStream)nos);
                    StreamUtil.writeTo(exc.getMessage(), (OutputStream)nos);
                    nos.send();
                    return;
                }
                ctx = (ReliableConnectionContext)gcn.getConnectionContext();
                StreamUtil.writeTo(0, (OutputStream)nos);
                nos.send();
                ioctrl = new IOControl(sock, ctx.getInputCounter());
                TcpConnection tcpConnection = this.proxyService.getConnection(proxyId, key);
                if (tcpConnection != null) {
                    tcpConnection.close();
                }
            }
            sock.setSoTimeout(0);
            TcpConnection tcpConnection = new TcpConnection(ioctrl, ctx, proxyId, this.proxyService, identity);
            tcpConnection.start();
        }
        catch (IllegalAccessException exc) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            sock.close();
            throw exc;
        }
        catch (IOException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            sock.close();
            throw exc;
        }
    }

    protected void shutdown() {
        this.close();
    }

    protected void close() {
        this.proxyService.resetServerSocket();
    }

    static class NetOutputStream
    extends ByteArrayOutputStream {
        private OutputStream os = null;

        NetOutputStream(Socket sock) throws IOException {
            super(1024);
            this.reset();
            this.os = sock.getOutputStream();
        }

        public void reset() {
            this.count = 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send() throws IOException {
            try {
                this.buf[0] = (byte)(this.count - 4 >>> 24);
                this.buf[1] = (byte)(this.count - 4 >>> 16);
                this.buf[2] = (byte)(this.count - 4 >>> 8);
                this.buf[3] = (byte)(this.count - 4 >>> 0);
                this.writeTo(this.os);
                this.os.flush();
            }
            finally {
                this.reset();
            }
        }
    }
}

