/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.multi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.carol.util.configuration.TraceCarol;

public class MultiPRODelegate
implements PortableRemoteObjectDelegate {
    private Hashtable<String, Integer> exported = new Hashtable();
    private List<PortableRemoteObjectDelegate> proDelegates = null;

    public MultiPRODelegate() {
        ProtocolConfiguration[] protocolConfigurations = ConfigurationRepository.getConfigurations();
        this.proDelegates = new ArrayList<PortableRemoteObjectDelegate>();
        for (ProtocolConfiguration protocolConfiguration : protocolConfigurations) {
            PortableRemoteObjectDelegate proDelegate = protocolConfiguration.getProtocol().getPortableRemoteObject();
            this.proDelegates.add(proDelegate);
        }
    }

    public void exportObject(Remote obj) throws RemoteException {
        for (PortableRemoteObjectDelegate proDelegate : this.proDelegates) {
            String protocol = System.getProperty("carol.multipro.protocol");
            if (protocol != null && !protocol.equals("any") && (protocol == null || !ConfigurationRepository.getProtocol(protocol).getPortableRemoteObject().equals(proDelegate))) continue;
            proDelegate.exportObject(obj);
        }
        if (TraceCarol.isDebugExportCarol()) {
            TraceCarol.debugExportCarol("Export object " + obj.getClass().getName());
            this.addObject(obj.getClass().getName());
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        for (PortableRemoteObjectDelegate proDelegate : this.proDelegates) {
            String protocol = System.getProperty("carol.multipro.protocol");
            if (protocol != null && !protocol.equals("any") && (protocol == null || !ConfigurationRepository.getProtocol(protocol).getPortableRemoteObject().equals(proDelegate))) continue;
            proDelegate.unexportObject(obj);
        }
        if (TraceCarol.isDebugExportCarol()) {
            TraceCarol.debugExportCarol("Unexport object " + obj.getClass().getName());
            TraceCarol.debugExportCarol("UnExported objects list:\n" + this.getExportedObjects());
            this.removeObject(obj.getClass().getName());
        }
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        for (PortableRemoteObjectDelegate proDelegate : this.proDelegates) {
            String protocol = System.getProperty("carol.multipro.protocol");
            if (protocol != null && !protocol.equals("any") && (protocol == null || !ConfigurationRepository.getProtocol(protocol).getPortableRemoteObject().equals(proDelegate))) continue;
            proDelegate.connect(target, source);
        }
    }

    public Object narrow(Object narrowFrom, Class narrowTo) throws ClassCastException {
        return ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject().narrow(narrowFrom, narrowTo);
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        return ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject().toStub(obj);
    }

    private String getExportedObjects() {
        String result = "Exported Objects:\n";
        int resultInt = 0;
        Enumeration<String> e = this.exported.keys();
        while (e.hasMoreElements()) {
            String ck = e.nextElement();
            int on = this.exported.get(ck);
            result = result + "" + on + " instances of  " + ck + "\n";
            resultInt += on;
        }
        result = result + "Total number of exported objects=" + resultInt;
        return result;
    }

    private void removeObject(String className) {
        if (this.exported.containsKey(className)) {
            if (this.exported.get(className) != 1) {
                this.exported.put(className, new Integer(this.exported.get(className) - 1));
            } else {
                this.exported.remove(className);
            }
        }
    }

    private void addObject(String className) {
        if (this.exported.containsKey(className)) {
            this.exported.put(className, new Integer(this.exported.get(className) + 1));
        } else {
            this.exported.put(className, new Integer(1));
        }
    }
}

