/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIMappingInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(URIMappingInterceptor.class);

    public URIMappingInterceptor() {
        super("unmarshal");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        BindingOperationInfo op;
        String method = (String)message.get(Message.HTTP_REQUEST_METHOD);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Invoking HTTP method " + method);
        }
        if (!this.isGET(message)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "URIMappingInterceptor can only handle HTTP GET, not HTTP " + method);
            }
            return;
        }
        String opName = this.getOperationName(message);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("URIMappingInterceptor get operation: " + opName);
        }
        if ((op = ServiceModelUtil.getOperation(message.getExchange(), opName)) == null || opName == null || op.getName() == null || StringUtils.isEmpty(op.getName().getLocalPart()) || !opName.equals(op.getName().getLocalPart())) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION_PATH", LOG, opName, message.get(Message.PATH_INFO)));
        }
        message.getExchange().put(BindingOperationInfo.class, op);
        MessageContentsList params = this.getParameters(message, op);
        message.setContent(List.class, params);
    }

    private Method getMethod(Message message, BindingOperationInfo operation) {
        MethodDispatcher md = (MethodDispatcher)message.getExchange().get(Service.class).get(MethodDispatcher.class.getName());
        return md.getMethod(operation);
    }

    private boolean isFixedParameterOrder(Message message) {
        Boolean order = (Boolean)message.get(Message.FIXED_PARAMETER_ORDER);
        return order != null && order != false;
    }

    protected Map<String, String> keepInOrder(Map<String, String> params, OperationInfo operation, List<String> order) {
        if (params == null || params.size() == 0) {
            return params;
        }
        if (order == null || order.size() == 0) {
            return params;
        }
        LinkedHashMap<String, String> orderedParameters = new LinkedHashMap<String, String>();
        for (String name : order) {
            orderedParameters.put(name, params.get(name));
        }
        if (order.size() != params.size()) {
            LOG.info(order.size() + " parameters definded in WSDL but found " + params.size() + " in request!");
            Collection<String> rest = CollectionUtils.diff(order, params.keySet());
            if (rest != null && rest.size() > 0) {
                LOG.info("Set the following parameters to null: " + rest);
                for (String key : rest) {
                    orderedParameters.put(key, null);
                }
            }
        }
        return orderedParameters;
    }

    protected MessageContentsList getParameters(Message message, BindingOperationInfo operation) {
        MessageContentsList parameters = new MessageContentsList();
        Map<String, String> queries = this.getQueries(message);
        if (!this.isFixedParameterOrder(message)) {
            boolean emptyQueries = CollectionUtils.isEmpty(queries.values());
            List<String> names = ServiceModelUtil.getOperationInputPartNames(operation.getOperationInfo());
            queries = this.keepInOrder(queries, operation.getOperationInfo(), names);
            if (!emptyQueries && CollectionUtils.isEmpty(queries.values())) {
                if (operation.isUnwrappedCapable()) {
                    return this.getParameters(message, operation.getUnwrappedOperation());
                }
                throw new Fault(new org.apache.cxf.common.i18n.Message("ORDERED_PARAM_REQUIRED", LOG, names.toString()));
            }
        }
        Method method = this.getMethod(message, operation);
        Class<?>[] types = method.getParameterTypes();
        for (String key : queries.keySet()) {
            Class<?> type;
            MessagePartInfo inf = null;
            for (MessagePartInfo p : operation.getOperationInfo().getInput().getMessageParts()) {
                if (!p.getConcreteName().getLocalPart().equals(key)) continue;
                inf = p;
                break;
            }
            if (inf == null && operation.isUnwrappedCapable()) {
                for (MessagePartInfo p : operation.getUnwrappedOperation().getOperationInfo().getInput().getMessageParts()) {
                    if (!p.getConcreteName().getLocalPart().equals(key)) continue;
                    inf = p;
                    break;
                }
            }
            int idx = 0;
            if (inf != null) {
                idx = inf.getIndex();
            }
            if ((type = types[idx]) == null) {
                LOG.warning("URIMappingInterceptor MessagePartInfo NULL ");
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_PART_FOUND", LOG, "index: " + idx + " on key " + key));
            }
            Object param = null;
            param = type != null && type.isPrimitive() && queries.get(key) != null ? PrimitiveUtils.read(queries.get(key), type) : queries.get(key);
            parameters.set(idx, param);
            idx = parameters.size();
        }
        return parameters;
    }

    private String uriDecode(String query) {
        try {
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warning(query + " can not be decoded: " + e.getMessage());
        }
        return query;
    }

    protected Map<String, String> getQueries(Message message) {
        LinkedHashMap<String, String> queries = new LinkedHashMap<String, String>();
        String query = (String)message.get(Message.QUERY_STRING);
        if (!StringUtils.isEmpty(query)) {
            List<String> parts = Arrays.asList(query.split("&"));
            for (String part : parts) {
                String[] keyValue = part.split("=");
                queries.put(keyValue[0], this.uriDecode(keyValue[1]));
            }
            return queries;
        }
        String rest = this.getRest(message);
        List<String> parts = StringUtils.getParts(rest, "/");
        for (int i = 1; i < parts.size(); i += 2) {
            if (i + 1 > parts.size()) {
                queries.put(parts.get(i), null);
                continue;
            }
            queries.put(parts.get(i), this.uriDecode(parts.get(i + 1)));
        }
        return queries;
    }

    private String getBasePath(Message message) {
        return (String)message.get(Message.BASE_PATH);
    }

    private String getRest(Message message) {
        String path = (String)message.get(Message.PATH_INFO);
        String basePath = this.getBasePath(message);
        return StringUtils.diff(path, basePath);
    }

    protected String getOperationName(Message message) {
        String rest = this.getRest(message);
        String opName = StringUtils.getFirstNotEmpty(rest, "/");
        if (opName.indexOf("?") != -1) {
            opName = opName.split("\\?")[0];
        }
        return opName;
    }
}

