/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest.jmsbridge;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.DeleteNot;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeAckNot;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeDeliveryNot;
import org.objectweb.joram.mom.dest.jmsbridge.JMSBridgeModule;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.QueueMsgReply;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;

public class JMSBridgeQueueImpl
extends QueueImpl {
    private static final long serialVersionUID = 1L;
    private JMSBridgeModule jmsModule;
    private Hashtable outTable = new Hashtable();

    public JMSBridgeQueueImpl(AgentId adminId, Properties prop) {
        super(adminId, prop);
        this.jmsModule = new JMSBridgeModule(prop);
    }

    public void initialize(boolean firstTime) {
        block7: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("initialize(" + firstTime + ')'));
            }
            super.initialize(firstTime);
            this.jmsModule.init(this.getId());
            try {
                this.jmsModule.connect();
                for (int i = 0; i < this.requests.size(); ++i) {
                    this.jmsModule.receive();
                }
                Vector<org.objectweb.joram.mom.messages.Message> outMessages = new Vector<org.objectweb.joram.mom.messages.Message>();
                Enumeration keys = this.outTable.keys();
                while (keys.hasMoreElements()) {
                    int i;
                    org.objectweb.joram.mom.messages.Message momMsg = (org.objectweb.joram.mom.messages.Message)this.outTable.get(keys.nextElement());
                    for (i = 0; i < outMessages.size(); ++i) {
                        org.objectweb.joram.mom.messages.Message currentMsg = (org.objectweb.joram.mom.messages.Message)outMessages.get(i);
                        if (momMsg.order < currentMsg.order) break;
                    }
                    outMessages.insertElementAt(momMsg, i);
                }
                while (!outMessages.isEmpty()) {
                    org.objectweb.joram.mom.messages.Message momMsg = (org.objectweb.joram.mom.messages.Message)outMessages.remove(0);
                    this.jmsModule.send(momMsg.getFullMessage());
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block7;
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
        }
    }

    public String toString() {
        return "BridgeQueueImpl:" + this.getId().toString();
    }

    public void bridgeDelivery(AgentId from, JMSBridgeDeliveryNot not) {
        ClientMessages clientMessages = new ClientMessages();
        clientMessages.addMessage(not.getMessage());
        super.doClientMessages(this.getId(), clientMessages);
    }

    public void bridgeAck(JMSBridgeAckNot not) {
        this.outTable.remove(not.getIdentifier());
    }

    public void receiveRequest(AgentId from, ReceiveRequest not) throws AccessException {
        block11: {
            if (!this.isReader(from)) {
                throw new AccessException("READ right not granted");
            }
            not.requester = from;
            not.setExpiration(System.currentTimeMillis());
            this.requests.add(not);
            int reqIndex = this.requests.size() - 1;
            this.deliverMessages(reqIndex);
            if (this.requests.size() - 1 == reqIndex) {
                if (not.getTimeOut() == -1L) {
                    Message message;
                    block10: {
                        this.requests.remove(reqIndex);
                        message = null;
                        try {
                            message = this.jmsModule.receiveNoWait();
                        }
                        catch (Exception exc) {
                            if (!logger.isLoggable(BasicLevel.ERROR)) break block10;
                            logger.log(BasicLevel.ERROR, (Object)"Failing receive request on remote destination: ", (Throwable)exc);
                        }
                    }
                    if (message != null && !Selector.matches(message, not.getSelector())) {
                        message = null;
                    }
                    QueueMsgReply reply = new QueueMsgReply(not);
                    reply.addMessage(message);
                    this.forward(from, reply);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"Receive answered.");
                    }
                } else {
                    try {
                        this.jmsModule.receive();
                    }
                    catch (Exception exc) {
                        if (!logger.isLoggable(BasicLevel.ERROR)) break block11;
                        logger.log(BasicLevel.ERROR, (Object)"Failing receive request on remote destination: ", (Throwable)exc);
                    }
                }
            }
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages not) {
        if (this.getId().equals(from)) {
            return not;
        }
        Enumeration msgs = not.getMessages().elements();
        while (msgs.hasMoreElements()) {
            org.objectweb.joram.mom.messages.Message message = new org.objectweb.joram.mom.messages.Message((Message)msgs.nextElement());
            ++this.arrivalsCounter;
            message.order = message.order;
            this.outTable.put(message.getIdentifier(), message);
            try {
                this.jmsModule.send(message.getFullMessage());
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, (Object)"Failing sending to remote  destination: ", (Throwable)exc);
                }
                this.outTable.remove(message.getIdentifier());
                DMQManager dmqManager = new DMQManager(not.getDMQId(), this.dmqId, this.getId());
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)6);
                dmqManager.sendToDMQ();
            }
        }
        return null;
    }

    protected void doDeleteNot(DeleteNot not) {
        this.jmsModule.close();
        super.doDeleteNot(not);
    }
}

