/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.connection;

import fr.dyade.aaa.common.Debug;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.connection.AbortedRequestException;
import org.objectweb.joram.client.jms.connection.ErrorListener;
import org.objectweb.joram.client.jms.connection.ReplyListener;
import org.objectweb.joram.client.jms.connection.RequestMultiplexer;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Requestor
implements ReplyListener,
ErrorListener {
    private static Logger logger = Debug.getLogger(Requestor.class.getName());
    public static final String DEFAULT_REQUEST_TIMEOUT_PROPERTY = "org.objectweb.joram.client.jms.connection.Requestor.defaultRequestTimeout";
    public static final long DEFAULT_REQUEST_TIMEOUT_VALUE = 0L;
    private long defaultRequestTimeout;
    private RequestMultiplexer mtpx;
    private Object reply;
    private int requestId;
    private int status;

    public Requestor(RequestMultiplexer mtpx) {
        this.mtpx = mtpx;
        this.init();
    }

    private void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Requestor.setStatus(" + Status.toString(status) + ')'));
        }
        this.status = status;
    }

    public final synchronized int getRequestId() {
        return this.requestId;
    }

    private void init() {
        this.defaultRequestTimeout = Long.getLong(DEFAULT_REQUEST_TIMEOUT_PROPERTY, 0L);
        if (this.status == 2) {
            this.setStatus(0);
            this.reply = null;
            this.requestId = -1;
        }
    }

    public synchronized AbstractJmsReply request(AbstractJmsRequest request) throws JMSException {
        return this.request(request, this.defaultRequestTimeout);
    }

    public synchronized AbstractJmsReply request(AbstractJmsRequest request, long timeout) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Requestor.request(" + request + ',' + timeout + ')'));
        }
        if (this.status != 0) {
            if (this.status == 3) {
                return null;
            }
            throw new IllegalStateException("Requestor already used");
        }
        this.mtpx.sendRequest(request, this);
        this.setStatus(1);
        this.requestId = request.getRequestId();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> request #" + this.requestId + " wait"));
        }
        try {
            this.wait(timeout);
        }
        catch (InterruptedException exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)exc);
            }
            this.setStatus(2);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> request #" + this.requestId + " awake"));
        }
        try {
            if (this.status == 1) {
                this.mtpx.abortRequest(this.requestId);
                AbstractJmsReply abstractJmsReply = null;
                return abstractJmsReply;
            }
            if (this.status == 3) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> deny " + this.reply));
                }
                if (this.reply instanceof ConsumerMessages) {
                    this.mtpx.deny((ConsumerMessages)this.reply);
                }
                AbstractJmsReply abstractJmsReply = null;
                return abstractJmsReply;
            }
            if (this.status == 2) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> request #" + this.requestId + " done"));
                }
                if (this.reply instanceof AbstractJmsReply) {
                    AbstractJmsReply abstractJmsReply = (AbstractJmsReply)this.reply;
                    return abstractJmsReply;
                }
                if (this.reply instanceof JMSException) {
                    throw (JMSException)((Object)this.reply);
                }
                AbstractJmsReply abstractJmsReply = null;
                return abstractJmsReply;
            }
            throw new Error();
        }
        finally {
            this.init();
        }
    }

    public synchronized boolean replyReceived(AbstractJmsReply reply) throws AbortedRequestException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Requestor.replyReceived(" + reply + ')'));
        }
        if (this.status == 1 && reply.getCorrelationId() == this.requestId) {
            this.reply = reply;
            this.setStatus(2);
            this.notify();
            return true;
        }
        throw new AbortedRequestException();
    }

    public synchronized void errorReceived(int replyId, JMSException exc) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Requestor.errorReceived(" + replyId + ',' + (Object)((Object)exc) + ')'));
        }
        if (this.status == 1 && replyId == this.requestId) {
            this.reply = exc;
            this.setStatus(2);
            this.notify();
        }
    }

    public synchronized void replyAborted(int replyId) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Requestor.replyAborted(" + replyId + ')'));
        }
        if (this.status == 1 && replyId == this.requestId) {
            this.reply = null;
            this.setStatus(2);
            this.notify();
        }
    }

    public synchronized void abortRequest() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Requestor[" + Status.toString(this.status) + ',' + this.requestId + "].abortRequest()"));
        }
        if (this.status == 1 && this.requestId > 0) {
            this.mtpx.abortRequest(this.requestId);
            this.setStatus(2);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> notify requestor");
            }
            this.notify();
        }
    }

    public synchronized void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Requestor.close()");
        }
        if (this.status != 3) {
            this.abortRequest();
            this.setStatus(3);
        }
    }

    private static class Status {
        public static final int INIT = 0;
        public static final int RUN = 1;
        public static final int DONE = 2;
        public static final int CLOSE = 3;
        private static final String[] names = new String[]{"INIT", "RUN", "DONE", "CLOSE"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

