/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.tcp;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.IOException;
import java.util.Date;
import org.objectweb.joram.mom.proxies.ReliableConnectionContext;
import org.objectweb.joram.mom.proxies.tcp.IOControl;
import org.objectweb.joram.mom.proxies.tcp.TcpConnectionMBean;
import org.objectweb.joram.mom.proxies.tcp.TcpProxyService;
import org.objectweb.joram.mom.proxies.tcp.TcpReader;
import org.objectweb.joram.mom.proxies.tcp.TcpWriter;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class TcpConnection
implements TcpConnectionMBean {
    public static Logger logger = Debug.getLogger(TcpConnection.class.getName());
    private IOControl ioctrl;
    private AgentId proxyId;
    private ReliableConnectionContext ctx;
    private TcpReader tcpReader;
    private TcpWriter tcpWriter;
    private TcpProxyService proxyService;
    private boolean closeConnection;
    private Identity identity;
    private Date creationDate = new Date();

    public TcpConnection(IOControl ioctrl, ReliableConnectionContext ctx, AgentId proxyId, TcpProxyService proxyService, Identity identity) throws IOException {
        this.ioctrl = ioctrl;
        this.proxyId = proxyId;
        this.ctx = ctx;
        this.proxyService = proxyService;
        this.closeConnection = ctx.getHeartBeat() == 0;
        this.identity = identity;
        try {
            MXWrapper.registerMBean(this, "Joram#" + AgentServer.getServerId(), this.getMBeanName());
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)"registerMBean", (Throwable)e);
        }
    }

    private String getMBeanName() {
        return this.proxyService.getMBeanName() + ",id=" + this.identity.getUserName() + "[" + this.ctx.getKey() + "]";
    }

    public final AgentId getProxyId() {
        return this.proxyId;
    }

    public final int getKey() {
        return this.ctx.getKey();
    }

    void start() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"TcpConnection.start()");
        }
        try {
            this.tcpWriter = new TcpWriter(this.ioctrl, this.ctx.getQueue(), this);
            this.tcpReader = new TcpReader(this.ioctrl, this.proxyId, this, this.closeConnection);
            this.proxyService.registerConnection(this);
            this.tcpWriter.start();
            this.tcpReader.start();
        }
        catch (Exception exc) {
            this.close();
            throw exc;
        }
    }

    public void close() {
        if (this.tcpWriter != null) {
            this.tcpWriter.stop();
        }
        if (this.tcpReader != null) {
            this.tcpReader.stop();
        }
        if (this.ioctrl != null) {
            this.ioctrl.close();
        }
        try {
            MXWrapper.unregisterMBean("Joram#" + AgentServer.getServerId(), this.getMBeanName());
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)"unregisterMBean", (Throwable)e);
        }
        this.ioctrl = null;
        this.proxyService.unregisterConnection(this);
    }

    public String getUserName() {
        return this.identity.getUserName();
    }

    public String getAddress() {
        return this.ioctrl.getSocket().toString();
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public long getReceivedCount() {
        return this.ioctrl.getReceivedCount();
    }

    public long getSentCount() {
        return this.ioctrl.getSentCount();
    }
}

