/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.base;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.AdminHelper;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.base.RealmItem;
import org.ow2.jonas.lib.management.extensions.base.RealmItemByNameComparator;
import org.ow2.jonas.lib.management.extensions.base.mbean.CatalinaObjectName;
import org.ow2.jonas.lib.management.extensions.base.mbean.MbeanItem;
import org.ow2.jonas.lib.management.extensions.container.ContainerManagement;
import org.ow2.jonas.lib.management.extensions.util.FileManagementUtils;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.extensions.base.api.ManagementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminJmxHelper {
    protected static Object s_Synchro = new Object();
    protected static final String J2EEApplication = "J2EEApplication";
    protected static final String AppClientModule = "AppClientModule";
    protected static final String EJBModule = "EJBModule";
    protected static final String WebModule = "WebModule";
    protected static final String ResourceAdapterModule = "ResourceAdapterModule";
    private static String DIR_CONF = "conf";
    private static String DIR_DEPLAN_JONAS = "repositories/url-internal";
    private static String REPO_MAVAEN2_INTERNAL = "repositories/maven2-internal";
    private static String REPO_MAVAEN2_DEV = ".m2/repository";

    protected AdminJmxHelper() {
    }

    public static String replace(String template, String placeholder, String value) {
        int index;
        if (template == null) {
            return null;
        }
        if (placeholder == null || value == null) {
            return template;
        }
        String sRet = new String(template);
        while ((index = sRet.indexOf(placeholder)) >= 0) {
            StringBuffer temp = new StringBuffer(sRet.substring(0, index));
            temp.append(value);
            temp.append(sRet.substring(index + placeholder.length()));
            sRet = temp.toString();
        }
        return sRet;
    }

    public static ObjectName getArchiveConfigObjectName(String domainName, String serverName) {
        ObjectName onUtils = JonasObjectName.ArchiveConfig((String)domainName);
        return AdminJmxHelper.getFirstMbean(onUtils, serverName);
    }

    public static ObjectName getRarConfigObjectName(String domainName, String serverName) {
        ObjectName onUtils = JonasObjectName.RarConfig((String)domainName);
        return AdminJmxHelper.getFirstMbean(onUtils, serverName);
    }

    public static ObjectName getJ2eeServerObjectName(String p_DomainName, String serverName) throws ManagementException {
        ObjectName pattern_server_on = J2eeObjectName.J2EEServers((String)p_DomainName);
        ObjectName server_on = null;
        Iterator it = JonasManagementRepr.queryNames(pattern_server_on, serverName).iterator();
        if (it.hasNext()) {
            server_on = (ObjectName)it.next();
        }
        return server_on;
    }

    public static ObjectName getJ2eeServerObjectName(String serverName) {
        ObjectName pattern_server_on = J2eeObjectName.J2EEServers();
        ObjectName server_on = null;
        Iterator it = JonasManagementRepr.queryNames(pattern_server_on, serverName).iterator();
        if (it.hasNext()) {
            server_on = (ObjectName)it.next();
        }
        return server_on;
    }

    private static String getJ2eeType(ObjectName pObjectName) {
        return pObjectName.getKeyProperty("j2eeType");
    }

    public static boolean isJ2EEApplication(ObjectName pObjectName) {
        return J2EEApplication.equals(AdminJmxHelper.getJ2eeType(pObjectName));
    }

    public static boolean isAppClientModule(ObjectName pObjectName) {
        return AppClientModule.equals(AdminJmxHelper.getJ2eeType(pObjectName));
    }

    public static boolean isEJBModule(ObjectName pObjectName) {
        return EJBModule.equals(AdminJmxHelper.getJ2eeType(pObjectName));
    }

    public static boolean isWebModule(ObjectName pObjectName) {
        return WebModule.equals(AdminJmxHelper.getJ2eeType(pObjectName));
    }

    public static boolean isResourceAdapterModule(ObjectName pObjectName) {
        return ResourceAdapterModule.equals(AdminJmxHelper.getJ2eeType(pObjectName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMBeanName(ObjectName p_On, String serverName) throws ManagementException {
        Object object = s_Synchro;
        synchronized (object) {
            ArrayList al = new ArrayList();
            Iterator itNames = JonasManagementRepr.queryNames(p_On, serverName).iterator();
            return itNames.hasNext();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFirstMBeanName(ObjectName p_On, String serverName) throws ManagementException {
        Object object = s_Synchro;
        synchronized (object) {
            ArrayList al = new ArrayList();
            Iterator itNames = JonasManagementRepr.queryNames(p_On, serverName).iterator();
            if (itNames.hasNext()) {
                return itNames.next().toString();
            }
            return null;
        }
    }

    public static List getListMBeanName(ObjectName p_On, String serverName) {
        return BaseManagement.getInstance().getListMbean(p_On, serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectName getFirstMbean(ObjectName p_On, String serverName) throws ManagementException {
        Object object = s_Synchro;
        synchronized (object) {
            Iterator itNames = JonasManagementRepr.queryNames(p_On, serverName).iterator();
            if (itNames.hasNext()) {
                return (ObjectName)itNames.next();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getListMbean(ObjectName p_On, String serverName) throws ManagementException {
        Object object = s_Synchro;
        synchronized (object) {
            ArrayList<ObjectName> al = new ArrayList<ObjectName>();
            Iterator itNames = JonasManagementRepr.queryNames(p_On, serverName).iterator();
            while (itNames.hasNext()) {
                al.add((ObjectName)itNames.next());
            }
            return al;
        }
    }

    public static String extractValueMbeanName(String pName, String pMBeanName) {
        String sValue = null;
        try {
            String sSearch = pName.trim() + "=";
            int iPos = pMBeanName.indexOf(sSearch);
            if (iPos > -1 && (iPos = (sValue = pMBeanName.substring(iPos + sSearch.length())).indexOf(",")) > -1) {
                sValue = sValue.substring(0, iPos);
            }
        }
        catch (NullPointerException e) {
            sValue = null;
        }
        return sValue;
    }

    public static String extractFilename(String p_Path) {
        return FileManagementUtils.extractFilename(p_Path);
    }

    private static ArrayList getFilenames(String p_Directory, String p_Extension) {
        ArrayList<String> al = new ArrayList<String>();
        String sExt = "." + p_Extension.toLowerCase();
        File oFile = new File(p_Directory);
        String[] asFiles = oFile.list();
        if (asFiles != null) {
            for (int i = 0; i < asFiles.length; ++i) {
                String sFile;
                int iPos;
                oFile = new File(p_Directory, asFiles[i]);
                if (!oFile.isFile() || (iPos = (sFile = oFile.getName().toLowerCase()).lastIndexOf(sExt)) <= -1 || iPos != sFile.length() - sExt.length()) continue;
                al.add(oFile.getName());
            }
        }
        Collections.sort(al);
        return al;
    }

    private static ArrayList getDirectories(String p_Directory) {
        ArrayList<String> al = new ArrayList<String>();
        File oFile = new File(p_Directory);
        String[] asFiles = oFile.list();
        if (asFiles != null) {
            for (int i = 0; i < asFiles.length; ++i) {
                oFile = new File(p_Directory, asFiles[i]);
                if (!oFile.isDirectory()) continue;
                al.add(oFile.getName());
            }
        }
        Collections.sort(al);
        return al;
    }

    private static void appendDirectory(ArrayList p_List, String p_Dir) {
        String sDir = p_Dir + "/";
        for (int i = 0; i < p_List.size(); ++i) {
            p_List.set(i, sDir + p_List.get(i));
        }
    }

    public static void initRepositoryDirs(String domainName, String serverName) throws ManagementException {
        String[] depmonitorDirs = new String[]{"deploy"};
        try {
            depmonitorDirs = AdminJmxHelper.getDepmonitorDirs(domainName, serverName);
        }
        catch (ManagementException me) {
            // empty catch block
        }
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        Object[] params = new Object[]{depmonitorDirs};
        String[] sign = new String[]{"[Ljava.lang.String;"};
        JonasManagementRepr.invoke(on, "initRepositoryDirs", params, sign, serverName);
        String[] repositoryDirs = AdminJmxHelper.getRepositoryDirs(domainName, serverName);
        Object[] params1 = new Object[]{repositoryDirs};
        String[] sign1 = new String[]{"[Ljava.lang.String;"};
        JonasManagementRepr.invoke(on, "setRepositories", params1, sign1, serverName);
    }

    public static boolean isDepmonitorDir(String dir, String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        Object[] params = new Object[]{dir};
        String[] sign = new String[]{"java.lang.String"};
        return (Boolean)JonasManagementRepr.invoke(on, "isDepmonitorDir", params, sign, serverName);
    }

    public static String[] getDepmonitorDirs(String domainName, String serverName) throws ManagementException {
        ArrayList<String> result = new ArrayList<String>();
        ObjectName on = JonasObjectName.deployableMonitorService((String)domainName);
        if (on != null) {
            String[] dirs;
            for (String dir : dirs = (String[])JonasManagementRepr.getAttribute(on, "directoryNames", serverName)) {
                result.add(dir);
            }
            Collections.sort(result);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getRepositoryDirs(String domainName, String serverName) throws ManagementException {
        ArrayList<String> result = new ArrayList<String>();
        ObjectName on = null;
        try {
            on = JonasObjectName.repository((String)domainName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "URLRepositories", serverName);
        String filePrefix = "file:";
        for (String url : al) {
            File tmpFile = new File(url);
            String path = tmpFile.getPath();
            if (!path.startsWith(filePrefix)) continue;
            result.add(path.substring(filePrefix.length()));
        }
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public static void setRepositoryDirs(String[] dirs, String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        Object[] params = new Object[]{dirs};
        String[] sign = new String[]{"[Ljava.lang.String;"};
        JonasManagementRepr.invoke(on, "setRepositories", params, sign, serverName);
    }

    public static ArrayList getFilesDeployable(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployableFiles", serverName);
        Collections.sort(al);
        return al;
    }

    public static ArrayList getJarFilesDeployable(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployableJars", serverName);
        Collections.sort(al);
        return al;
    }

    public static ArrayList getJarFilesDeployed(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployedJars", serverName);
        Collections.sort(al);
        return al;
    }

    public static ArrayList getEarFilesDeployable(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployableEars", serverName);
        Collections.sort(al);
        return al;
    }

    public static ArrayList getWarFilesDeployable(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployableWars", serverName);
        Collections.sort(al);
        return al;
    }

    public static ArrayList getRarFilesDeployable(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployableRars", serverName);
        Collections.sort(al);
        return al;
    }

    public static ArrayList getWarFilesDeployed(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployedWars", serverName);
        Collections.sort(al);
        return al;
    }

    public static ArrayList getEarFilesDeployed(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployedEars", serverName);
        Collections.sort(al);
        return al;
    }

    public static ArrayList getRarFilesDeployed(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployedRars", serverName);
        Collections.sort(al);
        return al;
    }

    public static ArrayList getFilesDeployed(String domainName, String serverName) throws ManagementException {
        ObjectName on = J2eeObjectName.J2EEServer((String)domainName, (String)serverName);
        ArrayList al = (ArrayList)JonasManagementRepr.getAttribute(on, "deployedFiles", serverName);
        try {
            String[] dplans;
            on = JonasObjectName.deploymentPlan((String)domainName);
            for (String dplan : dplans = (String[])JonasManagementRepr.getAttribute(on, "DeploymentPlans", serverName)) {
                boolean filtered = false;
                if (dplan.indexOf(DIR_DEPLAN_JONAS) > 0) {
                    filtered = true;
                }
                if (filtered) continue;
                al.add(dplan);
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        Collections.sort(al);
        return al;
    }

    public static ArrayList prepareContainersToDisplay(ArrayList p_Containers, String p_ContainerDir, String p_EarDir) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < p_Containers.size(); ++i) {
            String sPath = p_Containers.get(i).toString();
            int iPos = sPath.indexOf(p_ContainerDir);
            if (iPos > -1) {
                sPath = sPath.substring(p_ContainerDir.length());
            }
            if (sPath.endsWith("/")) {
                sPath = sPath.substring(0, sPath.length() - 1);
            }
            boolean bAdd = true;
            if (p_EarDir != null && (iPos = sPath.indexOf(p_EarDir)) > -1) {
                bAdd = false;
            }
            if (!bAdd) continue;
            al.add(sPath);
        }
        Collections.sort(al);
        return al;
    }

    private static ArrayList getFilesDeployed(ObjectName on, String serverName) throws ManagementException {
        ArrayList<String> alDeployed = new ArrayList<String>();
        Iterator itNames = AdminJmxHelper.getListMBeanName(on, serverName).iterator();
        while (itNames.hasNext()) {
            String sPath = AdminJmxHelper.extractValueMbeanName("fname", itNames.next().toString());
            String sFile = AdminJmxHelper.extractFilename(sPath);
            if (sFile == null) continue;
            alDeployed.add(sFile);
        }
        Collections.sort(alDeployed);
        return alDeployed;
    }

    public static ArrayList getMailFilesDeployable(String domainName, String serverName) throws ManagementException {
        ObjectName on = JonasObjectName.mailService((String)domainName);
        return (ArrayList)JonasManagementRepr.invoke(on, "getMailFactoryPropertiesFiles", new Object[0], new String[0], serverName);
    }

    public static ArrayList getMimePartMailFilesDeployable(String domainName, String serverName) throws ManagementException {
        ObjectName on = JonasObjectName.mailService((String)domainName);
        return (ArrayList)JonasManagementRepr.invoke(on, "getMimePartMailFactoryPropertiesFiles", new Object[0], new String[0], serverName);
    }

    public static ArrayList getSessionMailFilesDeployable(String domainName, String serverName) throws ManagementException {
        ObjectName on = JonasObjectName.mailService((String)domainName);
        return (ArrayList)JonasManagementRepr.invoke(on, "getSessionMailFactoryPropertiesFiles", new Object[0], new String[0], serverName);
    }

    public static ArrayList getMimePartMailFilesDeployed(AdminHelper p_AdminHelper) throws ManagementException {
        ArrayList<String> alDeployed = new ArrayList<String>();
        String domainName = p_AdminHelper.getCurrentDomainName();
        String serverName = p_AdminHelper.getCurrentJonasServerName();
        ObjectName on = J2eeObjectName.JavaMailResources((String)domainName, (String)serverName, (String)"javax.mail.internet.MimePartDataSource");
        for (ObjectName it_on : JonasManagementRepr.queryNames(on, serverName)) {
            String sName = it_on.getKeyProperty("name");
            if (sName == null) continue;
            alDeployed.add(sName);
        }
        Collections.sort(alDeployed);
        return alDeployed;
    }

    public static ArrayList<String> getDeployed(ArrayList<String> filesDeployed) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fileDeployed : filesDeployed) {
            boolean convert = false;
            if (fileDeployed.indexOf(REPO_MAVAEN2_INTERNAL) > 0) {
                convert = true;
            } else if (fileDeployed.indexOf(REPO_MAVAEN2_DEV) > 0) {
                convert = true;
            }
            if (convert) {
                result.add(AdminJmxHelper.convertDeployed(fileDeployed));
                continue;
            }
            result.add(fileDeployed);
        }
        return result;
    }

    public static String findDeployedPath(ArrayList<String> filesDeployed, String resourceName) {
        for (String fileDeployed : filesDeployed) {
            boolean convertible = false;
            if (fileDeployed.indexOf(REPO_MAVAEN2_INTERNAL) > 0) {
                convertible = true;
            } else if (fileDeployed.indexOf(REPO_MAVAEN2_DEV) > 0) {
                convertible = true;
            }
            if (!convertible || !resourceName.equals(AdminJmxHelper.convertDeployed(fileDeployed))) continue;
            return fileDeployed;
        }
        return resourceName;
    }

    private static String convertDeployed(String fileDeployedPath) {
        String convertedName = null;
        int iPosSeparator = fileDeployedPath.lastIndexOf("/");
        convertedName = iPosSeparator < 0 ? ((iPosSeparator = fileDeployedPath.lastIndexOf("\\")) < 0 ? new String(fileDeployedPath) : fileDeployedPath.substring(iPosSeparator + 1)) : fileDeployedPath.substring(iPosSeparator + 1);
        return convertedName;
    }

    public static ArrayList getSessionMailFilesDeployed(AdminHelper p_AdminHelper) throws ManagementException {
        ArrayList<String> alDeployed = new ArrayList<String>();
        String domainName = p_AdminHelper.getCurrentDomainName();
        String serverName = p_AdminHelper.getCurrentJonasServerName();
        ObjectName on = J2eeObjectName.JavaMailResources((String)domainName, (String)serverName, (String)"javax.mail.Session");
        for (ObjectName it_on : JonasManagementRepr.queryNames(on, serverName)) {
            String sName = it_on.getKeyProperty("name");
            if (sName == null) continue;
            alDeployed.add(sName);
        }
        Collections.sort(alDeployed);
        return alDeployed;
    }

    public static ArrayList getMailFilesDeployed(AdminHelper p_AdminHelper) throws ManagementException {
        ArrayList alDeployed = AdminJmxHelper.getSessionMailFilesDeployed(p_AdminHelper);
        alDeployed.addAll(AdminJmxHelper.getMimePartMailFilesDeployed(p_AdminHelper));
        Collections.sort(alDeployed);
        return alDeployed;
    }

    public static ArrayList getDatasourceFilesDeployable(String domainName, String serverName) throws ManagementException {
        ObjectName on = JonasObjectName.databaseService((String)domainName);
        return (ArrayList)JonasManagementRepr.getAttribute(on, "DataSourcePropertiesFiles", serverName);
    }

    public static ArrayList getDatasourceFilesDeployed(String domainName, String serverName) throws ManagementException {
        ArrayList<String> alDeployed = new ArrayList<String>();
        ObjectName ons = J2eeObjectName.JDBCDataSources((String)domainName, (String)serverName);
        Iterator itNames = JonasManagementRepr.queryNames(ons, serverName).iterator();
        String sName = null;
        while (itNames.hasNext()) {
            ObjectName on = (ObjectName)itNames.next();
            sName = on.getKeyProperty("name");
            if (sName == null) continue;
            alDeployed.add(sName);
        }
        Collections.sort(alDeployed);
        return alDeployed;
    }

    public static ArrayList getDatasourceDependences(String pDatasourceName, String domainName, String serverName) throws ManagementException {
        ObjectName jdbcDatasource = J2eeObjectName.getJDBCDataSource((String)domainName, (String)serverName, (String)pDatasourceName);
        Object[] asParam = new String[1];
        String[] asSignature = new String[]{"java.lang.String"};
        ArrayList<String> al = new ArrayList<String>();
        asParam[0] = (String)JonasManagementRepr.getAttribute(jdbcDatasource, "jndiName", serverName);
        if (JonasManagementRepr.isRegistered(JonasObjectName.ejbService((String)domainName), serverName)) {
            Iterator it = ((Set)JonasManagementRepr.invoke(JonasObjectName.ejbService((String)domainName), "getDataSourceDependence", asParam, asSignature, serverName)).iterator();
            while (it.hasNext()) {
                String sName = AdminJmxHelper.extractValueMbeanName(",name", it.next().toString());
                if (sName == null) continue;
                al.add(sName);
            }
            Collections.sort(al);
        }
        return al;
    }

    public static ArrayList getMailFactoryDependences(String p_MailFactoryName, AdminHelper p_AdminHelper) throws ManagementException {
        String type;
        String serverName;
        String jndiName = null;
        String domainName = p_AdminHelper.getCurrentDomainName();
        ObjectName on = J2eeObjectName.JavaMailResource((String)domainName, (String)p_MailFactoryName, (String)(serverName = p_AdminHelper.getCurrentJonasServerName()), (String)(type = "javax.mail.Session"));
        if (!JonasManagementRepr.isRegistered(on, serverName)) {
            type = "javax.mail.internet.MimePartDataSource";
            on = J2eeObjectName.JavaMailResource((String)domainName, (String)p_MailFactoryName, (String)serverName, (String)type);
        }
        jndiName = (String)JonasManagementRepr.getAttribute(on, "Name", serverName);
        Object[] asParam = new String[1];
        String[] asSignature = new String[]{"java.lang.String"};
        ArrayList<String> al = new ArrayList<String>();
        asParam[0] = jndiName;
        if (JonasManagementRepr.isRegistered(JonasObjectName.ejbService((String)domainName), serverName)) {
            Iterator it = ((Set)JonasManagementRepr.invoke(JonasObjectName.ejbService((String)domainName), "getMailFactoryDependence", asParam, asSignature, serverName)).iterator();
            while (it.hasNext()) {
                String sName = AdminJmxHelper.extractValueMbeanName(",name", it.next().toString());
                if (sName == null) continue;
                al.add(sName);
            }
            Collections.sort(al);
        }
        return al;
    }

    public static ArrayList getSessionMailFactoriesDeployed(AdminHelper p_AdminHelper) throws ManagementException {
        ArrayList<String> alDeployed = new ArrayList<String>();
        String domainName = p_AdminHelper.getCurrentDomainName();
        String serverName = p_AdminHelper.getCurrentJonasServerName();
        String type = "javax.mail.Session";
        ObjectName any_on = J2eeObjectName.JavaMailResources((String)domainName, (String)serverName, (String)type);
        for (ObjectName on : JonasManagementRepr.queryNames(any_on, serverName)) {
            String sName = on.getKeyProperty("name");
            if (sName == null) continue;
            alDeployed.add(sName);
        }
        Collections.sort(alDeployed);
        return alDeployed;
    }

    public static ArrayList getMimeMailPartFactoriesDeployed(AdminHelper p_AdminHelper) throws ManagementException {
        ArrayList<String> alDeployed = new ArrayList<String>();
        String domainName = p_AdminHelper.getCurrentDomainName();
        String serverName = p_AdminHelper.getCurrentJonasServerName();
        String type = "javax.mail.internet.MimePartDataSource";
        ObjectName any_on = J2eeObjectName.JavaMailResources((String)domainName, (String)serverName, (String)type);
        for (ObjectName on : JonasManagementRepr.queryNames(any_on, serverName)) {
            String sName = on.getKeyProperty("name");
            if (sName == null) continue;
            alDeployed.add(sName);
        }
        Collections.sort(alDeployed);
        return alDeployed;
    }

    public static ObjectName getTomcatSecurityRealm(String domainName, String serverName) throws MalformedObjectNameException {
        ObjectName pattern_realms = CatalinaObjectName.catalinaRealms();
        ObjectName realm_on = null;
        for (ObjectName on : JonasManagementRepr.queryNames(pattern_realms, serverName)) {
            String path = on.getKeyProperty("path");
            if (path != null) continue;
            realm_on = on;
            break;
        }
        return realm_on;
    }

    public static ArrayList<RealmItem> getTomcatSecurityRealms(String usedRealmName, String domainName, String serverName) throws MalformedObjectNameException {
        ArrayList<RealmItem> al = new ArrayList<RealmItem>();
        ObjectName pattern_realms = CatalinaObjectName.catalinaRealms();
        for (ObjectName on : JonasManagementRepr.queryNames(pattern_realms, serverName)) {
            String path = on.getKeyProperty("path");
            if (path == null) continue;
            String resourceName = (String)JonasManagementRepr.getAttribute(on, "resourceName", serverName);
            String resourceType = AdminJmxHelper.findSecurityFactorySubType(resourceName, domainName, serverName);
            al.add(new RealmItem(resourceName, resourceType, path, resourceName.equals(usedRealmName)));
        }
        Collections.sort(al, new RealmItemByNameComparator());
        return al;
    }

    public static ArrayList getSecurityMemoryFactories(String domainName, String serverName) throws MalformedObjectNameException {
        ArrayList<String> al = new ArrayList<String>();
        Iterator itNames = AdminJmxHelper.getListMBeanName(JonasObjectName.allSecurityMemoryFactories((String)domainName), serverName).iterator();
        while (itNames.hasNext()) {
            String sName = AdminJmxHelper.extractValueMbeanName(",name", itNames.next().toString());
            if (sName == null) continue;
            al.add(sName);
        }
        Collections.sort(al);
        return al;
    }

    public static ArrayList getSecurityDatasourceFactories(String domainName, String serverName) throws MalformedObjectNameException {
        ArrayList<String> al = new ArrayList<String>();
        Iterator itNames = AdminJmxHelper.getListMBeanName(JonasObjectName.allSecurityDatasourceFactories((String)domainName), serverName).iterator();
        while (itNames.hasNext()) {
            String sName = AdminJmxHelper.extractValueMbeanName(",name", itNames.next().toString());
            if (sName == null) continue;
            al.add(sName);
        }
        Collections.sort(al);
        return al;
    }

    public static ArrayList getSecurityLdapFactories(String domainName, String serverName) throws MalformedObjectNameException {
        ArrayList<String> al = new ArrayList<String>();
        Iterator itNames = AdminJmxHelper.getListMBeanName(JonasObjectName.allSecurityLdapFactories((String)domainName), serverName).iterator();
        while (itNames.hasNext()) {
            String sName = AdminJmxHelper.extractValueMbeanName(",name", itNames.next().toString());
            if (sName == null) continue;
            al.add(sName);
        }
        Collections.sort(al);
        return al;
    }

    public static String findSecurityFactorySubType(String p_NameFactory, String domainName, String serverName) throws MalformedObjectNameException {
        String sSubType = null;
        ObjectName on = null;
        Iterator itNames = AdminJmxHelper.getListMBeanName(JonasObjectName.allSecurityFactories((String)domainName), serverName).iterator();
        while (itNames.hasNext()) {
            on = new ObjectName(itNames.next().toString());
            String sName = on.getKeyProperty("name");
            if (!p_NameFactory.equals(sName)) continue;
            sSubType = on.getKeyProperty("subtype");
            break;
        }
        return sSubType;
    }

    public static ArrayList getUsers(String domainName, String p_Resource, String serverName) throws ManagementException, MalformedObjectNameException {
        ArrayList<String> al = new ArrayList<String>();
        Iterator itNames = AdminJmxHelper.getListMBeanName(JonasObjectName.allUsers((String)domainName, (String)p_Resource), serverName).iterator();
        while (itNames.hasNext()) {
            String sName = AdminJmxHelper.extractValueMbeanName(",name", itNames.next().toString());
            if (sName == null) continue;
            al.add(sName);
        }
        Collections.sort(al);
        return al;
    }

    public static ArrayList getRoles(String domainName, String p_Resource, String serverName) throws ManagementException, MalformedObjectNameException {
        ArrayList<String> al = new ArrayList<String>();
        Iterator itNames = AdminJmxHelper.getListMBeanName(JonasObjectName.allRoles((String)domainName, (String)p_Resource), serverName).iterator();
        while (itNames.hasNext()) {
            String sName = AdminJmxHelper.extractValueMbeanName(",name", itNames.next().toString());
            if (sName == null) continue;
            al.add(sName);
        }
        Collections.sort(al);
        return al;
    }

    public static ArrayList getGroups(String domainName, String p_Resource, String serverName) throws ManagementException, MalformedObjectNameException {
        ArrayList<String> al = new ArrayList<String>();
        Iterator itNames = AdminJmxHelper.getListMBeanName(JonasObjectName.allGroups((String)domainName, (String)p_Resource), serverName).iterator();
        while (itNames.hasNext()) {
            String sName = AdminJmxHelper.extractValueMbeanName(",name", itNames.next().toString());
            if (sName == null) continue;
            al.add(sName);
        }
        Collections.sort(al);
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getQueuesList(String domainName, String serverName) {
        Object object = s_Synchro;
        synchronized (object) {
            ObjectName jmsServMB = JonasObjectName.jmsService((String)domainName);
            Set queues = (Set)JonasManagementRepr.getAttribute(jmsServMB, "AllJmsQueueDestinationNames", serverName);
            ArrayList al = new ArrayList();
            Iterator itNames = queues.iterator();
            while (itNames.hasNext()) {
                al.add(itNames.next());
            }
            return al;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTopicsList(String domainName, String serverName) {
        Object object = s_Synchro;
        synchronized (object) {
            ObjectName jmsServMB = JonasObjectName.jmsService((String)domainName);
            Set topics = (Set)JonasManagementRepr.getAttribute(jmsServMB, "AllJmsTopicDestinationNames", serverName);
            ArrayList al = new ArrayList();
            Iterator itNames = topics.iterator();
            while (itNames.hasNext()) {
                al.add(itNames.next());
            }
            return al;
        }
    }

    public static ArrayList getMbeansLists(String serverName) throws ManagementException {
        ArrayList<MbeanItem> al = new ArrayList<MbeanItem>();
        Iterator it = AdminJmxHelper.getListMbean(null, serverName).iterator();
        while (it.hasNext()) {
            MbeanItem oItem = MbeanItem.build((ObjectName)it.next());
            al.add(oItem);
        }
        return al;
    }

    public static ArrayList[] getFamiliesMbeansLists(String serverName) throws ManagementException {
        ArrayList[] als = new ArrayList[3];
        for (int i = 0; i < 3; ++i) {
            als[i] = new ArrayList();
        }
        Iterator it = AdminJmxHelper.getListMbean(null, serverName).iterator();
        while (it.hasNext()) {
            MbeanItem oItem = MbeanItem.build((ObjectName)it.next());
            int i = oItem.getFamily();
            als[i].add(oItem);
        }
        return als;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTotalNbStatefulSessionBeans(String domainName, String serverName) {
        int nb = 0;
        ObjectName moduleOns = J2eeObjectName.getEJBModules((String)domainName, (String)serverName);
        Iterator it = null;
        Object object = s_Synchro;
        synchronized (object) {
            it = JonasManagementRepr.queryNames(moduleOns, serverName).iterator();
        }
        while (it.hasNext()) {
            ObjectName moduleOn = (ObjectName)it.next();
            String[] ejbs = (String[])JonasManagementRepr.getAttribute(moduleOn, "ejbs", serverName);
            for (int i = 0; i < ejbs.length; ++i) {
                String ejbON = ejbs[i];
                try {
                    ObjectName ejbOn = ObjectName.getInstance(ejbON);
                    String ejbType = ejbOn.getKeyProperty("j2eeType");
                    if (!"StatefulSessionBean".equals(ejbType)) continue;
                    ++nb;
                    continue;
                }
                catch (MalformedObjectNameException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getTotalEJB(String domainName, String serverName) {
        HashMap<String, Integer> table = new HashMap<String, Integer>();
        int nbStatefulSessionBean = 0;
        int nbStatelessSessionBean = 0;
        int nbEntityBean = 0;
        int nbMessageDrivenBean = 0;
        ObjectName moduleOns = J2eeObjectName.getEJBModules((String)domainName, (String)serverName);
        Iterator it = null;
        Object object = s_Synchro;
        synchronized (object) {
            it = JonasManagementRepr.queryNames(moduleOns, serverName).iterator();
        }
        while (it.hasNext()) {
            ObjectName moduleOn = (ObjectName)it.next();
            Map moduleTable = AdminJmxHelper.getTotalEJB(moduleOn);
            nbStatefulSessionBean += ((Integer)moduleTable.get("StatefulSessionBean")).intValue();
            nbStatelessSessionBean += ((Integer)moduleTable.get("StatelessSessionBean")).intValue();
            nbEntityBean += ((Integer)moduleTable.get("EntityBean")).intValue();
            nbMessageDrivenBean += ((Integer)moduleTable.get("MessageDrivenBean")).intValue();
        }
        table.put("StatefulSessionBean", nbStatefulSessionBean);
        table.put("StatelessSessionBean", nbStatelessSessionBean);
        table.put("EntityBean", nbEntityBean);
        table.put("MessageDrivenBean", nbMessageDrivenBean);
        return table;
    }

    public static Map getTotalEJB(ObjectName moduleOn) {
        return ContainerManagement.getInstance().getTotalEJB(moduleOn);
    }

    public static String getConnectionUrl(String remoteServerName, String domainName, String serverName) throws MalformedObjectNameException {
        ObjectName on = JonasObjectName.serverProxy((String)domainName, (String)remoteServerName);
        return (String)JonasManagementRepr.getAttribute(on, "ConnectionUrl", serverName);
    }
}

