/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.FaultTo;
import org.apache.axis.message.addressing.From;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.Recipient;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.RelatesTo;
import org.apache.axis.message.addressing.ReplyTo;
import org.apache.axis.message.addressing.To;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;
import org.w3c.dom.Element;

public class AddressingHeaders {
    private Action action = null;
    private ReplyTo replyTo = null;
    private To to = null;
    private FaultTo faultTo = null;
    private From from = null;
    private Recipient recipient = null;
    private MessageID messageID = null;
    private ArrayList relatesTo = new ArrayList();
    private ReferencePropertiesType referenceProperties = new ReferencePropertiesType();
    private boolean setMustUnderstand = false;

    public AddressingHeaders() {
    }

    public AddressingHeaders(EndpointReference epr) {
        this.to = new To(epr.getAddress());
        this.referenceProperties = epr.getProperties();
    }

    public AddressingHeaders(SOAPEnvelope env) throws Exception {
        this(env, null, true, false, true, new ArrayList(0));
    }

    public AddressingHeaders(SOAPEnvelope env, boolean process, boolean remove) throws Exception {
        this(env, null, process, remove, true, new ArrayList(0));
    }

    public AddressingHeaders(SOAPEnvelope env, String actorURI, boolean process, boolean remove) throws Exception {
        this(env, actorURI, process, remove, true, new ArrayList(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AddressingHeaders(SOAPEnvelope env, String actorURI, boolean process, boolean remove, boolean setMustUnderstand, List refPropsQNames) throws Exception {
        this.setMustUnderstand = setMustUnderstand;
        SOAPHeader header = env.getHeader();
        if (header == null) {
            return;
        }
        Iterator iter = header.examineHeaderElements(actorURI);
        while (iter.hasNext()) {
            javax.xml.soap.SOAPHeaderElement headerElement = (javax.xml.soap.SOAPHeaderElement)iter.next();
            Name name = headerElement.getElementName();
            if (AddressingUtils.isAddressingNamespaceURI(name.getURI())) {
                String localName = name.getLocalName();
                if (localName.equals("MessageID")) {
                    this.messageID = new MessageID(headerElement);
                } else if (localName.equals("To")) {
                    this.to = new To(headerElement);
                    MessageContext msgContext = AxisEngine.getCurrentMessageContext();
                    if (msgContext != null) {
                        msgContext.setProperty("addressing.namespace.URI", (Object)name.getURI());
                    }
                } else if (localName.equals("Action")) {
                    this.action = new Action(headerElement);
                } else if (localName.equals("From")) {
                    this.from = new From(headerElement);
                } else if (localName.equals("ReplyTo")) {
                    this.replyTo = new ReplyTo(headerElement);
                } else if (localName.equals("FaultTo")) {
                    this.faultTo = new FaultTo(headerElement);
                } else if (localName.equals("Recipient")) {
                    this.recipient = new Recipient(headerElement);
                } else {
                    if (!localName.equals("RelatesTo")) throw new Exception("Unsupported addressing header: " + localName);
                    this.relatesTo.add(new RelatesTo((SOAPElement)headerElement));
                }
            } else if (!this.processReferenceProperty(headerElement, refPropsQNames)) continue;
            if (remove) {
                headerElement.detachNode();
            }
            if (!process || !(headerElement instanceof SOAPHeaderElement)) continue;
            ((SOAPHeaderElement)headerElement).setProcessed(true);
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setAction(String uri) throws Exception {
        this.action = new Action(new URI(uri));
    }

    public To getTo() {
        return this.to;
    }

    public void setTo(To to) {
        this.to = to;
    }

    public void setMessageID(MessageID messageID) {
        this.messageID = messageID;
    }

    public void setReferenceProperties(ReferencePropertiesType refProps) {
        this.referenceProperties = refProps;
    }

    public ReferencePropertiesType getReferenceProperties() {
        return this.referenceProperties;
    }

    public void addReferenceProperty(Element refProp) {
        this.referenceProperties.add(refProp);
    }

    public void addReferenceProperty(MessageElement refProp) {
        this.referenceProperties.add(refProp);
    }

    public void toEnvelope(SOAPEnvelope env) throws Exception {
        this.toEnvelope(env, null);
    }

    public void toEnvelope(SOAPEnvelope env, String actorURI) throws Exception {
        if (env.getNamespaceURI("wsa") == null) {
            env.addNamespaceDeclaration("wsa", AddressingUtils.getAddressingNamespaceURI());
        }
        AddressingUtils.removeHeaders(env.getHeader(), actorURI);
        javax.xml.soap.SOAPHeaderElement header = null;
        if (this.messageID != null) {
            header = this.messageID.toSOAPHeaderElement(env, actorURI);
            header.setMustUnderstand(this.setMustUnderstand);
        }
        if (this.to != null) {
            header = this.to.toSOAPHeaderElement(env, actorURI);
            header.setMustUnderstand(this.setMustUnderstand);
        }
        if (this.action != null) {
            header = this.action.toSOAPHeaderElement(env, actorURI);
            header.setMustUnderstand(this.setMustUnderstand);
        }
        if (this.from != null) {
            header = this.from.toSOAPHeaderElement(env, actorURI);
            header.setMustUnderstand(this.setMustUnderstand);
        }
        if (this.replyTo != null) {
            header = this.replyTo.toSOAPHeaderElement(env, actorURI);
            header.setMustUnderstand(this.setMustUnderstand);
        }
        if (this.faultTo != null) {
            header = this.faultTo.toSOAPHeaderElement(env, actorURI);
            header.setMustUnderstand(this.setMustUnderstand);
        }
        if (this.recipient != null) {
            header = this.recipient.toSOAPHeaderElement(env, actorURI);
            header.setMustUnderstand(this.setMustUnderstand);
        }
        if (this.relatesTo != null) {
            for (int i = 0; i < this.relatesTo.size(); ++i) {
                RelatesTo rtp = (RelatesTo)this.relatesTo.get(i);
                header = rtp.toSOAPHeaderElement(env, actorURI);
                header.setMustUnderstand(this.setMustUnderstand);
            }
        }
        this.serializeReferenceProperties(env, actorURI);
    }

    public MessageID getMessageID() {
        return this.messageID;
    }

    public List getRelatesTo() {
        return this.relatesTo;
    }

    public void setRelatesTo(List v) {
        this.relatesTo.clear();
        this.relatesTo.addAll(v);
    }

    public void addRelatesTo(String uri, QName type) throws URI.MalformedURIException {
        this.relatesTo.add(new RelatesTo(uri, type));
    }

    public void setTo(AttributedURI uri) {
        this.to = new To(uri);
    }

    public EndpointReference getFrom() {
        return this.from;
    }

    public void setFrom(EndpointReference ref) {
        this.from = new From(ref);
    }

    public EndpointReference getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(EndpointReference ref) {
        this.replyTo = new ReplyTo(ref);
    }

    public EndpointReference getFaultTo() {
        return this.faultTo;
    }

    public void setFaultTo(EndpointReference epr) {
        this.faultTo = new FaultTo(epr);
    }

    private boolean processReferenceProperty(javax.xml.soap.SOAPHeaderElement headerElement, List refPropQNames) throws Exception {
        Name name = headerElement.getElementName();
        QName elementName = new QName(name.getURI(), name.getLocalName());
        if (refPropQNames == null || refPropQNames.contains(elementName)) {
            this.referenceProperties.add(headerElement);
            return true;
        }
        return false;
    }

    private void serializeReferenceProperties(SOAPEnvelope env, String actorURI) throws Exception {
        if (this.referenceProperties == null) {
            return;
        }
        javax.xml.soap.SOAPHeaderElement element = null;
        for (int i = 0; i < this.referenceProperties.size(); ++i) {
            Object refProp = this.referenceProperties.get(i);
            if (refProp instanceof javax.xml.soap.SOAPHeaderElement) {
                element = (javax.xml.soap.SOAPHeaderElement)refProp;
            } else if (refProp instanceof MessageElement) {
                MessageElement msgElement = (MessageElement)refProp;
                element = new SOAPHeaderElement(msgElement.getAsDOM());
            } else if (refProp instanceof Element) {
                Element refPropElement = (Element)refProp;
                element = new SOAPHeaderElement(refPropElement);
            } else {
                throw new Exception(refProp.getClass().getName());
            }
            SOAPHeader header = env.getHeader();
            if (header == null) {
                header = env.addHeader();
            }
            element.setActor(actorURI);
            header.addChildElement((SOAPElement)element);
        }
    }

    public boolean isSetMustUnderstand() {
        return this.setMustUnderstand;
    }

    public void setSetMustUnderstand(boolean setMustUnderstand) {
        this.setMustUnderstand = setMustUnderstand;
    }
}

