/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.remote.api;

import java.io.Serializable;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.TopicalLogger;

public class LoggerInfo
implements Serializable {
    public String[] topics;
    public int level;
    public String levelName;
    public String[] handlerNames;
    public boolean additivity;

    public LoggerInfo(TopicalLogger l) {
        this.topics = l.getTopic();
        this.level = l.getCurrentIntLevel();
        this.levelName = l.getCurrentLevel().getName();
        Handler[] hs = l.getHandler();
        this.handlerNames = new String[hs.length];
        for (int i = 0; i < hs.length; ++i) {
            this.handlerNames[i] = hs[i].getName();
        }
        this.additivity = l.getAdditivity();
    }

    public boolean isAdditivity() {
        return this.additivity;
    }

    public void setAdditivity(boolean additivity) {
        this.additivity = additivity;
    }

    public String[] getHandlerNames() {
        return this.handlerNames;
    }

    public void setHandlerNames(String[] handlerNames) {
        this.handlerNames = handlerNames;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public void setTopics(String[] topics) {
        this.topics = topics;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("topic=[");
        for (i = 0; i < this.topics.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.topics[i]);
        }
        sb.append("]");
        sb.append(", level=[");
        sb.append(this.levelName);
        sb.append("]");
        if (this.handlerNames.length > 0) {
            sb.append(", handler=[");
            for (i = 0; i < this.handlerNames.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.handlerNames[i]);
            }
            sb.append("]");
        }
        if (!this.additivity) {
            sb.append(", no handler inherited");
        }
        return sb.toString();
    }
}

