/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactoryManager;
import org.ow2.util.plan.fetcher.impl.LocalRepositoriesBaseDirConfiguration;
import org.ow2.util.plan.fetcher.impl.ResourceFetcherFactoryManagerImpl;

public class FetcherActivator
implements BundleActivator,
ServiceListener {
    private Log logger = LogFactory.getLog(FetcherActivator.class);
    ResourceFetcherFactoryManagerImpl fetcherManager = null;
    private ServiceRegistration fetcherManagerServiceRegistration = null;
    private BundleContext bundleContext = null;
    private ServiceRegistration configRegistration = null;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.fetcherManager = new ResourceFetcherFactoryManagerImpl();
        StringBuilder sb = new StringBuilder("(");
        sb.append("objectClass");
        sb.append("=");
        sb.append(IResourceFetcherFactory.class.getName());
        sb.append(")");
        context.addServiceListener((ServiceListener)this, sb.toString());
        this.fetcherManagerServiceRegistration = context.registerService(IResourceFetcherFactoryManager.class.getName(), (Object)this.fetcherManager, null);
        ServiceReference[] preFactories = context.getServiceReferences(IResourceFetcherFactory.class.getName(), null);
        if (preFactories != null) {
            for (ServiceReference ref : preFactories) {
                IResourceFetcherFactory fetcherFactory = (IResourceFetcherFactory)context.getService(ref);
                this.fetcherManager.addResourceFetcherFactory(fetcherFactory);
                this.logger.debug((Object)"Found one resource fetcher factory for {0} resources", new Object[]{fetcherFactory.getSupportedClass()});
            }
        }
        LocalRepositoriesBaseDirConfiguration config = new LocalRepositoriesBaseDirConfiguration(this.fetcherManager);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.ow2.util.plan.fetcher");
        this.configRegistration = context.registerService(ManagedService.class.getName(), (Object)config, props);
    }

    public void stop(BundleContext context) throws Exception {
        this.configRegistration.unregister();
        this.fetcherManagerServiceRegistration.unregister();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        IResourceFetcherFactory factory = (IResourceFetcherFactory)this.bundleContext.getService(serviceRef);
        switch (event.getType()) {
            case 1: {
                this.fetcherManager.addResourceFetcherFactory(factory);
                this.logger.debug((Object)"Added one resource fetcher factory for {0} resources", new Object[]{factory.getSupportedClass()});
                break;
            }
            case 4: {
                this.fetcherManager.removeResourceFetcherFactory(factory);
                this.logger.debug((Object)"Removed one resource fetcher factory for {0} resources", new Object[]{factory.getSupportedClass()});
                break;
            }
        }
    }
}

