/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.eclipse.persistence.exceptions.ValidationException;

public class SerializationHelper {
    public static Object clone(Serializable object) throws IOException, ClassNotFoundException {
        return SerializationHelper.deserialize(SerializationHelper.serialize(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Serializable obj, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw ValidationException.invalidNullMethodArguments();
        }
        ObjectOutputStream outStream = null;
        try {
            outStream = new ObjectOutputStream(outputStream);
            outStream.writeObject(obj);
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Serializable obj) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(512);
        SerializationHelper.serialize(obj, outStream);
        return outStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(InputStream inputStream) throws IOException, ClassNotFoundException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The inputStream argument cannot be null");
        }
        ObjectInputStream inStream = null;
        try {
            inStream = new ObjectInputStream(inputStream);
            Object object = inStream.readObject();
            return object;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Object deserialize(byte[] objectBytes) throws IOException, ClassNotFoundException {
        if (objectBytes == null) {
            throw ValidationException.invalidNullMethodArguments();
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(objectBytes);
        return SerializationHelper.deserialize(inStream);
    }
}

