/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.conf;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.conf.A3CMLCluster;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.DuplicateClusterException;
import fr.dyade.aaa.agent.conf.DuplicateDomainException;
import fr.dyade.aaa.agent.conf.DuplicateServerException;
import fr.dyade.aaa.agent.conf.Log;
import fr.dyade.aaa.agent.conf.UnknownClusterException;
import fr.dyade.aaa.agent.conf.UnknownDomainException;
import fr.dyade.aaa.agent.conf.UnknownServerException;
import fr.dyade.aaa.agent.conf.UnknownServiceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;

public class A3CMLConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Hashtable domains = new Hashtable();
    public Hashtable servers = new Hashtable();
    public Hashtable properties = new Hashtable();
    public Hashtable clusters = new Hashtable();

    public final void addDomain(A3CMLDomain domain) throws DuplicateDomainException {
        if (this.domains.containsKey(domain.name)) {
            throw new DuplicateDomainException("Duplicate domain " + domain.name);
        }
        this.domains.put(domain.name, domain);
    }

    public final A3CMLDomain removeDomain(String name) throws UnknownDomainException {
        A3CMLDomain domain = null;
        if (!this.domains.containsKey(name)) {
            throw new UnknownDomainException("Unknown domain " + name);
        }
        domain = (A3CMLDomain)this.domains.remove(name);
        return domain;
    }

    public final boolean containsDomain(String name) {
        return this.domains.containsKey(name);
    }

    public final A3CMLDomain getDomain(String name) throws UnknownDomainException {
        A3CMLDomain domain = (A3CMLDomain)this.domains.get(name);
        if (domain == null) {
            throw new UnknownDomainException("Unknown domain " + name);
        }
        return domain;
    }

    public final void addCluster(A3CMLCluster cluster) throws DuplicateClusterException {
        Short id = new Short(cluster.sid);
        if (this.clusters.containsKey(id)) {
            throw new DuplicateClusterException("Duplicate cluster " + cluster.sid);
        }
        this.clusters.put(id, cluster);
    }

    public final A3CMLCluster getCluster(short sid) throws UnknownClusterException {
        A3CMLCluster cluster = (A3CMLCluster)this.clusters.get(new Short(sid));
        if (cluster == null) {
            throw new UnknownClusterException("Unknown cluster id. #" + sid);
        }
        return cluster;
    }

    public final A3CMLCluster getCluster(String name) throws UnknownClusterException {
        Enumeration c = this.clusters.elements();
        while (c.hasMoreElements()) {
            A3CMLCluster cluster = (A3CMLCluster)c.nextElement();
            if (!cluster.name.equals(name)) continue;
            return cluster;
        }
        throw new UnknownClusterException("Unknown cluster id for cluster " + name);
    }

    public short getClusterIdByName(String name) throws UnknownClusterException {
        Enumeration c = this.clusters.elements();
        while (c.hasMoreElements()) {
            A3CMLCluster cluster = (A3CMLCluster)c.nextElement();
            if (!cluster.name.equals(name)) continue;
            return cluster.sid;
        }
        throw new UnknownClusterException("Unknown cluster " + name);
    }

    public final boolean containsCluster(String name) {
        try {
            this.getClusterIdByName(name);
        }
        catch (UnknownClusterException exc) {
            return false;
        }
        return true;
    }

    public final boolean containsCluster(short sid) {
        return this.clusters.containsKey(new Short(sid));
    }

    public final A3CMLCluster removeCluster(short sid) throws UnknownClusterException {
        A3CMLCluster cluster = null;
        Short id = new Short(sid);
        if (!this.clusters.containsKey(id)) {
            throw new UnknownClusterException("Unknown cluster id. #" + sid);
        }
        cluster = (A3CMLCluster)this.clusters.remove(id);
        return cluster;
    }

    public final A3CMLCluster removeCluster(String name) throws UnknownClusterException {
        return this.removeCluster(this.getClusterIdByName(name));
    }

    public final void addServer(A3CMLServer server) throws DuplicateServerException {
        Short id = new Short(server.sid);
        if (this.servers.containsKey(id)) {
            throw new DuplicateServerException("Duplicate server id. #" + server.sid);
        }
        this.servers.put(id, server);
    }

    public final A3CMLServer removeServer(short sid) throws UnknownServerException {
        A3CMLServer server = null;
        Short id = new Short(sid);
        if (!this.servers.containsKey(id)) {
            throw new UnknownServerException("Unknown server id. #" + sid);
        }
        server = (A3CMLServer)this.servers.remove(id);
        for (int i = 0; i < server.networks.size(); ++i) {
            A3CMLNetwork network = (A3CMLNetwork)server.networks.elementAt(i);
            A3CMLDomain domain = (A3CMLDomain)this.domains.get(network.domain);
            domain.removeServer(sid);
        }
        return server;
    }

    public final A3CMLServer removeServer(String name) throws UnknownServerException {
        return this.removeServer(this.getServerIdByName(name));
    }

    public final boolean containsServer(short sid) {
        return this.servers.containsKey(new Short(sid));
    }

    public short getServerIdByName(String name) throws UnknownServerException {
        Enumeration s = this.servers.elements();
        while (s.hasMoreElements()) {
            A3CMLServer server = (A3CMLServer)s.nextElement();
            if (!server.name.equals(name)) continue;
            return server.sid;
        }
        throw new UnknownServerException("Unknown server " + name);
    }

    public final boolean containsServer(String name) {
        try {
            this.getServerIdByName(name);
        }
        catch (UnknownServerException exc) {
            return false;
        }
        return true;
    }

    public final A3CMLServer getServer(short sid) throws UnknownServerException {
        return this.getServer(sid, (short)-1);
    }

    public final A3CMLServer getServer(short sid, short cid) throws UnknownServerException {
        A3CMLServer server = null;
        if (cid == -1) {
            server = (A3CMLServer)this.servers.get(new Short(sid));
        } else {
            try {
                A3CMLCluster cluster = this.getCluster(sid);
                server = cluster.getServer(cid);
            }
            catch (Exception exc) {
                throw new UnknownServerException(exc.getMessage());
            }
        }
        if (server == null) {
            throw new UnknownServerException("Unknown server id. #" + sid);
        }
        return server;
    }

    public final A3CMLServer getServer(String name) throws UnknownServerException {
        Enumeration s = this.servers.elements();
        while (s.hasMoreElements()) {
            A3CMLServer server = (A3CMLServer)s.nextElement();
            if (!server.name.equals(name)) continue;
            return server;
        }
        throw new UnknownServerException("Unknown server id for server " + name);
    }

    public final A3CMLProperty addProperty(A3CMLProperty prop) throws Exception {
        return this.properties.put(prop.name, prop);
    }

    public final A3CMLProperty removeProperty(String name) {
        return (A3CMLProperty)this.properties.remove(name);
    }

    public final boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public final A3CMLProperty getProperty(String name) {
        return (A3CMLProperty)this.properties.get(name);
    }

    public final A3CMLProperty getProperty(String name, short sid, short cid) throws Exception {
        A3CMLProperty prop = null;
        if (cid == -1) {
            A3CMLServer server = this.getServer(sid);
            prop = server.getProperty(name);
        } else {
            A3CMLCluster cluster = this.getCluster(sid);
            A3CMLServer server = cluster.getServer(cid);
            prop = server.getProperty(name);
            if (prop == null) {
                prop = cluster.getProperty(name);
            }
        }
        return prop;
    }

    public final String getJvmArgs(short sid) throws UnknownServerException {
        A3CMLServer server = this.getServer(sid);
        return server.getJvmArgs();
    }

    public final String getJvmArgs(String name) throws UnknownServerException {
        A3CMLServer server = this.getServer(name);
        return server.getJvmArgs();
    }

    public final String getServiceArgs(short sid, String classname) throws UnknownServerException, UnknownServiceException {
        A3CMLServer server = this.getServer(sid);
        return server.getServiceArgs(classname);
    }

    public final String getServiceArgs(String name, String classname) throws UnknownServerException, UnknownServiceException {
        A3CMLServer server = this.getServer(name);
        return server.getServiceArgs(classname);
    }

    public void configure(A3CMLServer root) throws Exception {
        A3CMLDomain domain;
        A3CMLNetwork network;
        short rootid = root.sid;
        Vector<A3CMLDomain> toExplore = new Vector<A3CMLDomain>();
        this.reset();
        Enumeration n = root.networks.elements();
        while (n.hasMoreElements()) {
            network = (A3CMLNetwork)n.nextElement();
            domain = (A3CMLDomain)this.domains.get(network.domain);
            domain.gateway = rootid;
            domain.hops = 1;
            toExplore.addElement(domain);
            Log.logger.log(BasicLevel.DEBUG, (Object)("configure - toExplore.add(" + domain + ")"));
        }
        root.visited = true;
        root.gateway = (short)-1;
        root.hops = 0;
        root.domain = "local";
        while (toExplore.size() > 0) {
            A3CMLDomain domain2 = (A3CMLDomain)toExplore.elementAt(0);
            toExplore.removeElementAt(0);
            A3CMLServer gateway = (A3CMLServer)this.servers.get(new Short(domain2.gateway));
            if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                Log.logger.log(BasicLevel.DEBUG, (Object)("configure - explore(" + domain2 + ")"));
            }
            Enumeration s = domain2.servers.elements();
            while (s.hasMoreElements()) {
                A3CMLServer server = (A3CMLServer)s.nextElement();
                if (server.visited) continue;
                if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                    Log.logger.log(BasicLevel.DEBUG, (Object)("configure - explore(" + server + ")"));
                }
                server.visited = true;
                if (domain2.gateway == rootid) {
                    server.gateway = (short)-1;
                    server.domain = domain2.name;
                } else {
                    server.gateway = domain2.gateway;
                    server.domain = gateway.domain;
                }
                server.hops = domain2.hops;
                Enumeration n2 = server.networks.elements();
                while (n2.hasMoreElements()) {
                    A3CMLNetwork network2 = (A3CMLNetwork)n2.nextElement();
                    A3CMLDomain d2 = (A3CMLDomain)this.domains.get(network2.domain);
                    if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                        Log.logger.log(BasicLevel.DEBUG, (Object)("configure - parse(" + d2 + ")"));
                    }
                    if (d2 == domain2) {
                        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                            Log.logger.log(BasicLevel.DEBUG, (Object)("configure - setPort(" + network2.port + ")"));
                        }
                        server.port = network2.port;
                        continue;
                    }
                    d2.hops = domain2.hops + 1;
                    d2.gateway = server.gateway == -1 ? server.sid : server.gateway;
                    toExplore.addElement(d2);
                    if (!Log.logger.isLoggable(BasicLevel.DEBUG)) continue;
                    Log.logger.log(BasicLevel.DEBUG, (Object)("configure - toExplore.add(" + d2 + ")"));
                }
            }
        }
        Enumeration s = this.servers.elements();
        while (s.hasMoreElements()) {
            A3CMLServer server = (A3CMLServer)s.nextElement();
            if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                Log.logger.log(BasicLevel.DEBUG, (Object)("configure - verify " + server));
            }
            if (server.visited) continue;
            throw new Exception(server + " inaccessible");
        }
        n = root.networks.elements();
        while (n.hasMoreElements()) {
            A3CMLServer server;
            int i;
            network = (A3CMLNetwork)n.nextElement();
            domain = (A3CMLDomain)this.domains.get(network.domain);
            if (!"fr.dyade.aaa.agent.HttpNetwork".equals(domain.network) && !"fr.dyade.aaa.agent.HttpsNetwork".equals(domain.network)) continue;
            short router = -1;
            for (i = 0; i < domain.servers.size(); ++i) {
                server = (A3CMLServer)domain.servers.elementAt(i);
                if (server.port <= 0 || server.sid == rootid) continue;
                router = server.sid;
                break;
            }
            if (router == -1) continue;
            for (i = 0; i < domain.servers.size(); ++i) {
                server = (A3CMLServer)domain.servers.elementAt(i);
                if (server.sid == router || server.sid == rootid) continue;
                server.gateway = router;
            }
        }
    }

    public A3CMLConfig getDomainConfig(String domainName) throws Exception {
        A3CMLConfig domainConf;
        block7: {
            if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                Log.logger.log(BasicLevel.DEBUG, (Object)("Config.getDomainConfig(" + domainName + ")"));
            }
            domainConf = new A3CMLConfig();
            A3CMLDomain dom = this.getDomain(domainName).duplicate();
            domainConf.addDomain(dom);
            for (int i = 0; i < dom.servers.size(); ++i) {
                A3CMLServer server = (A3CMLServer)dom.servers.elementAt(i);
                domainConf.servers.put(new Short(server.sid), server);
            }
            Enumeration p = this.properties.elements();
            while (p.hasMoreElements()) {
                A3CMLProperty property = (A3CMLProperty)p.nextElement();
                domainConf.addProperty(property.duplicate());
            }
            try {
                A3CMLDomain d0 = this.getDomain("D0");
                domainConf.addDomain(new A3CMLDomain(d0.name, d0.network));
                A3CMLServer s0 = domainConf.getServer(AgentServer.getServerId());
                d0 = domainConf.getDomain("D0");
                d0.addServer(s0);
                int i = 0;
                while (i < s0.networks.size()) {
                    A3CMLNetwork network = (A3CMLNetwork)s0.networks.elementAt(i);
                    if (!network.domain.equals("D0") && !network.domain.equals(domainName)) {
                        s0.networks.removeElement(network);
                        continue;
                    }
                    ++i;
                }
            }
            catch (UnknownServerException exc) {
                if (!Log.logger.isLoggable(BasicLevel.DEBUG)) break block7;
                Log.logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
        }
        return domainConf;
    }

    public A3CMLConfig getDomainConfig(String[] listDomainName) throws Exception {
        A3CMLConfig domainConf;
        block11: {
            if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                Log.logger.log(BasicLevel.DEBUG, (Object)("Config.getDomainConfig(" + listDomainName + ")"));
            }
            Hashtable context = new Hashtable();
            domainConf = new A3CMLConfig();
            Vector<String> domainList = new Vector<String>();
            for (int i = 0; i < listDomainName.length; ++i) {
                domainList.addElement(listDomainName[i]);
            }
            for (int n = 0; n < listDomainName.length; ++n) {
                String domainName = listDomainName[n];
                A3CMLDomain dom = this.getDomain(domainName).duplicate(context);
                domainConf.addDomain(dom);
                for (int i = 0; i < dom.servers.size(); ++i) {
                    A3CMLServer server = (A3CMLServer)dom.servers.elementAt(i);
                    int j = 0;
                    while (j < server.networks.size()) {
                        A3CMLNetwork network = (A3CMLNetwork)server.networks.elementAt(j);
                        if (!(network.domain.equals("D0") || network.domain.equals("transient") || domainList.contains(network.domain))) {
                            server.networks.removeElement(network);
                            continue;
                        }
                        ++j;
                    }
                    domainConf.servers.put(new Short(server.sid), server);
                }
            }
            Enumeration p = this.properties.elements();
            while (p.hasMoreElements()) {
                A3CMLProperty property = (A3CMLProperty)p.nextElement();
                domainConf.addProperty(property.duplicate());
            }
            try {
                A3CMLDomain d0 = this.getDomain("D0");
                domainConf.addDomain(new A3CMLDomain(d0.name, d0.network));
                A3CMLServer s0 = domainConf.getServer(AgentServer.getServerId());
                d0 = domainConf.getDomain("D0");
                d0.addServer(s0);
                int i = 0;
                while (i < s0.networks.size()) {
                    A3CMLNetwork network = (A3CMLNetwork)s0.networks.elementAt(i);
                    if (!network.domain.equals("D0") && !domainList.contains(network.domain)) {
                        s0.networks.removeElement(network);
                        continue;
                    }
                    ++i;
                }
            }
            catch (UnknownServerException exc) {
                if (!Log.logger.isLoggable(BasicLevel.DEBUG)) break block11;
                Log.logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
        }
        return domainConf;
    }

    public void save() throws IOException {
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, (Object)("Config.save(" + this + ")"));
        }
        AgentServer.getTransaction().save(this, "a3cmlconfig");
    }

    public static A3CMLConfig load() throws Exception {
        A3CMLConfig a3config;
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, (Object)"Config.load()");
        }
        if ((a3config = (A3CMLConfig)AgentServer.getTransaction().load("a3cmlconfig")) == null) {
            Log.logger.log(BasicLevel.WARN, (Object)"Unable to find configuration file.");
            throw new IOException("Unable to find configuration file .");
        }
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, (Object)("Config.load : a3cmlconfig = " + a3config));
        }
        return a3config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static A3CMLConfig getConfig(String path) throws Exception {
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, (Object)("Config.load(" + path + ")"));
        }
        A3CMLConfig a3config = null;
        File cfgFile = new File(path);
        if (cfgFile.exists() && cfgFile.isFile()) {
            if (cfgFile.length() == 0L) {
                Log.logger.log(BasicLevel.ERROR, (Object)(" \"" + cfgFile.getPath() + "\", is empty."));
                throw new IOException(" \"" + cfgFile.getPath() + "\", is empty.");
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(cfgFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                a3config = (A3CMLConfig)ois.readObject();
            }
            catch (Exception exc) {
                Log.logger.log(BasicLevel.WARN, (Object)("Can't load configuration: " + path), (Throwable)exc);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                Log.logger.log(BasicLevel.DEBUG, (Object)("Config.load : a3cmlconfig = " + a3config));
            }
            return a3config;
        }
        ClassLoader classLoader = null;
        InputStream is = null;
        try {
            classLoader = A3CMLConfig.class.getClassLoader();
            if (classLoader != null) {
                Log.logger.log(BasicLevel.WARN, (Object)("Trying to find [" + path + "] using " + classLoader + " class loader."));
                is = classLoader.getResourceAsStream(path);
            }
        }
        catch (Throwable t) {
            Log.logger.log(BasicLevel.WARN, (Object)("Can't find [" + path + "] using " + classLoader + " class loader."), t);
            is = null;
        }
        if (is == null) {
            Log.logger.log(BasicLevel.WARN, (Object)"Trying to find serialized config using ClassLoader.getSystemResource().");
            is = ClassLoader.getSystemResourceAsStream(path);
        }
        if (is != null) {
            ObjectInputStream ois = new ObjectInputStream(is);
            a3config = (A3CMLConfig)ois.readObject();
        }
        if (a3config == null) {
            Log.logger.log(BasicLevel.WARN, (Object)("Unable to find configuration file: " + path));
            throw new IOException("Unable to find configuration file: " + path);
        }
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, (Object)("Config.load : a3cmlconfig = " + a3config));
        }
        return a3config;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("(").append(super.toString());
        strBuf.append(",properties=").append(this.properties);
        strBuf.append(",domains=").append(this.domains);
        strBuf.append(",servers=").append(this.servers);
        strBuf.append(",clusters=").append(this.clusters);
        strBuf.append(")");
        return strBuf.toString();
    }

    public final String getServiceArgsHost(String hostname, String classname) throws Exception {
        Enumeration s = this.servers.elements();
        while (s.hasMoreElements()) {
            A3CMLServer server = (A3CMLServer)s.nextElement();
            if (!server.hostname.equals(hostname)) continue;
            try {
                String args = this.getServiceArgs(server.sid, classname);
                return args;
            }
            catch (Exception exc) {
            }
        }
        throw new UnknownServiceException("Unknown service \"" + classname + "\" on host " + hostname);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof A3CMLConfig) {
            A3CMLConfig config = (A3CMLConfig)obj;
            if (this.domains.equals(config.domains) && this.servers.equals(config.servers) && this.properties.equals(config.properties)) {
                return true;
            }
        }
        return false;
    }

    public void reset() {
        Enumeration s = this.servers.elements();
        while (s.hasMoreElements()) {
            A3CMLServer server = (A3CMLServer)s.nextElement();
            server.visited = false;
            server.gateway = (short)-1;
        }
        Enumeration d = this.domains.elements();
        while (d.hasMoreElements()) {
            A3CMLDomain domain = (A3CMLDomain)d.nextElement();
            domain.gateway = (short)-1;
        }
    }
}

