/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.common;

import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.EnvEntry;

public class EnvEntryDesc
implements IEnvEntryDesc {
    private String name;
    private Class type;
    private Object value;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnvEntryDesc(EnvEntry env) throws DeploymentDescException {
        this.name = env.getEnvEntryName();
        String t = env.getEnvEntryType();
        String v = null;
        if (env.getEnvEntryValue() != null) {
            v = env.getEnvEntryValue();
        }
        try {
            if (t.equals(Boolean.class.getName())) {
                this.type = Boolean.class;
                if (v != null) {
                    if (v.equalsIgnoreCase("true")) {
                        this.value = Boolean.TRUE;
                        return;
                    } else {
                        if (!v.equalsIgnoreCase("false")) throw new DeploymentDescException(v + " is not a valid value for env-entry " + this.name);
                        this.value = Boolean.FALSE;
                    }
                    return;
                } else {
                    this.value = Boolean.FALSE;
                }
                return;
            } else if (t.equals(String.class.getName())) {
                this.type = String.class;
                this.value = v != null ? v : new String();
                return;
            } else if (t.equals(Integer.class.getName())) {
                this.type = Integer.class;
                this.value = v != null ? new Integer(v) : new Integer(0);
                return;
            } else if (t.equals(Character.class.getName())) {
                this.type = Character.class;
                if (v != null) {
                    if (v.length() != 1) {
                        throw new DeploymentDescException("The value '" + v + "' is not a valid value for env-entry of type java.lang.Character.");
                    }
                    this.value = new Character(v.charAt(0));
                    return;
                } else {
                    this.value = new Character("".charAt(0));
                }
                return;
            } else if (t.equals(Double.class.getName())) {
                this.type = Double.class;
                this.value = v != null ? new Double(v) : new Double(0.0);
                return;
            } else if (t.equals(Byte.class.getName())) {
                this.type = Byte.class;
                this.value = v != null ? new Byte(v) : new Byte("");
                return;
            } else if (t.equals(Short.class.getName())) {
                this.type = Short.class;
                this.value = v != null ? new Short(v) : new Short("");
                return;
            } else if (t.equals(Long.class.getName())) {
                this.type = Long.class;
                this.value = v != null ? new Long(v) : new Long(0L);
                return;
            } else {
                if (!t.equals(Float.class.getName())) throw new DeploymentDescException(t + " is not a valid type for env-entry " + this.name);
                this.type = Float.class;
                this.value = v != null ? new Float(v) : new Float(0.0f);
            }
            return;
        }
        catch (NumberFormatException e) {
            throw new DeploymentDescException(v + " is not a valid value for env-entry " + this.name, e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetName()=" + this.getName());
        ret.append("\ngetType()=" + this.getType());
        if (this.hasValue()) {
            ret.append("\ngetValue()=" + this.getValue().toString());
        }
        return ret.toString();
    }
}

