/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapNamespaceContext
implements NamespaceContext {
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Node targetNode;

    public MapNamespaceContext() {
    }

    public MapNamespaceContext(Map<String, String> ns) {
        this();
        this.namespaces = ns;
    }

    public MapNamespaceContext(Node node) {
        this();
        this.targetNode = node;
    }

    public void setTargetNode(Node node) {
        this.targetNode = node;
    }

    public void addNamespace(String prefix, String namespaceURI) {
        this.namespaces.put(prefix, namespaceURI);
    }

    public void addNamespaces(Map<String, String> ns) {
        this.namespaces.putAll(ns);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.targetNode != null) {
            String s = this.targetNode.lookupNamespaceURI(prefix);
            if (prefix != null && s != null) {
                this.namespaces.put(prefix, s);
            }
        }
        return this.namespaces.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        for (Map.Entry<String, String> e : this.namespaces.entrySet()) {
            if (!e.getValue().equals(namespaceURI)) continue;
            return e.getKey();
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        return null;
    }

    public Map<String, String> getUsedNamespaces() {
        return this.namespaces;
    }
}

