/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.pool.lib;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.resource.internal.pool.Pool;

public class HArrayPoolMonitor
extends Thread {
    private Pool pool;
    private Logger logger = null;
    private long adjustPeriod = 30000L;
    private long samplingPeriod = 60000L;
    private long validationPeriod = 120000L;
    private long adjustTime = 0L;
    private long samplingTime = 0L;
    private long validationTime = 0L;
    private boolean stopped = false;

    public HArrayPoolMonitor(Pool pool, String jndiName) {
        super("HArrayPoolMonitor-" + jndiName);
        this.setDaemon(true);
        this.pool = pool;
        this.logger = Log.getLogger((String)"org.ow2.jonas.jca");
    }

    public void setAdjustPeriod(int sec) {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" to " + sec));
        }
        this.adjustPeriod = (long)sec * 1000L;
    }

    public void setSamplingPeriod(int sec) {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" to " + sec));
        }
        this.samplingPeriod = (long)sec * 1000L;
    }

    public void setValidationPeriod(int sec) {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)(" to " + sec));
        }
        this.validationPeriod = (long)sec * 1000L;
    }

    public void stopit() {
        this.stopped = true;
    }

    public void run() {
        this.resetTimes();
        while (!this.stopped) {
            long timeout = this.adjustTime;
            if (this.samplingTime < timeout) {
                timeout = this.samplingTime;
            }
            if (this.validationTime < timeout) {
                timeout = this.validationTime;
            }
            try {
                HArrayPoolMonitor.sleep(timeout);
                this.adjustTime -= timeout;
                this.samplingTime -= timeout;
                this.validationTime -= timeout;
                if (this.adjustTime <= 0L) {
                    this.pool.adjust();
                    this.adjustTime = this.adjustPeriod;
                }
                if (this.samplingTime <= 0L) {
                    this.pool.sampling();
                    this.samplingTime = this.samplingPeriod;
                }
                if (this.validationTime > 0L) continue;
                this.pool.validateMCs();
                this.validationTime = this.validationPeriod;
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.ERROR, (Object)"Exception in HArrayPoolMonitor", (Throwable)e);
                this.resetTimes();
            }
        }
    }

    private void resetTimes() {
        this.adjustTime = this.adjustPeriod;
        this.samplingTime = this.samplingPeriod;
        this.validationTime = this.validationPeriod;
    }
}

