/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class AddDataTest
extends ChannelTestBase {
    JChannel ch1;
    JChannel ch2;

    public AddDataTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.ch2 != null) {
            this.ch2.close();
        }
        if (this.ch1 != null) {
            this.ch1.close();
        }
    }

    public void testAdditionalData() throws Exception {
        try {
            for (int i = 1; i <= 5; ++i) {
                System.out.println("-- attempt # " + i + "/10");
                JChannel c = this.createChannel();
                HashMap<String, byte[]> m = new HashMap<String, byte[]>();
                m.put("additional_data", new byte[]{98, 101, 108, 97});
                ((Channel)c).down(new Event(56, m));
                ((Channel)c).connect("bla");
                IpAddress addr = (IpAddress)((Channel)c).getLocalAddress();
                System.out.println("address is " + addr);
                AddDataTest.assertNotNull((Object)addr.getAdditionalData());
                AddDataTest.assertEquals((int)98, (int)addr.getAdditionalData()[0]);
                ((Channel)c).close();
            }
        }
        catch (ChannelException e) {
            e.printStackTrace();
            AddDataTest.fail((String)e.toString());
        }
    }

    public void testBetweenTwoChannelsMcast() throws Exception {
        this._testWithProps(true);
    }

    public void testBetweenTwoChannelsUnicast() throws Exception {
        this._testWithProps(false);
    }

    public void testBetweenTwoChannelsWithBundlingMcast() throws Exception {
        this._testWithProps(true);
    }

    public void testBetweenTwoChannelsWithBundlingUnicast() throws Exception {
        this._testWithProps(false);
    }

    private void _testWithProps(boolean mcast) throws Exception {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("additional_data", new byte[]{98, 101, 108, 97});
        byte[] buf = new byte[1000];
        this.ch1 = this.createChannel();
        this.ch1.down(new Event(56, m));
        this.ch2 = this.createChannel();
        this.ch2.down(new Event(56, m));
        MyReceiver receiver = new MyReceiver();
        this.ch2.setReceiver(receiver);
        this.ch1.connect("group");
        this.ch2.connect("group");
        if (mcast) {
            this.ch1.send(new Message(null, null, buf));
        } else {
            Address dest = this.ch2.getLocalAddress();
            this.ch1.send(new Message(dest, null, buf));
        }
        Util.sleep(500L);
        List<Message> list = receiver.getMsgs();
        AddDataTest.assertTrue((!list.isEmpty() ? 1 : 0) != 0);
        Message msg = list.get(0);
        IpAddress src = (IpAddress)msg.getSrc();
        AddDataTest.assertNotNull((Object)src);
        AddDataTest.assertNotNull((Object)src.getAdditionalData());
        AddDataTest.assertEquals((int)4, (int)src.getAdditionalData().length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        final List<Message> msgs = new LinkedList<Message>();

        private MyReceiver() {
        }

        public List<Message> getMsgs() {
            return this.msgs;
        }

        public void clear() {
            this.msgs.clear();
        }

        @Override
        public void receive(Message msg) {
            System.out.println("received " + msg);
            this.msgs.add(msg);
        }
    }
}

