/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl.datasource;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.ow2.jonas.jndi.checker.api.IResourceChecker;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerInfo;
import org.ow2.jonas.jndi.checker.api.ResourceCheckpoints;
import org.ow2.jonas.jndi.interceptors.impl.datasource.ConnectionProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DatasourceWrapper
implements DataSource,
IResourceChecker {
    private static Log logger = LogFactory.getLog(DatasourceWrapper.class);
    private Long count = 0L;
    private boolean forceClose = true;
    private DataSource wrappedDataSource = null;
    private Map<Long, ConnectionProxy> openConnectionsMap = new HashMap<Long, ConnectionProxy>();

    public DatasourceWrapper(DataSource wrappedDataSource) {
        this.wrappedDataSource = wrappedDataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.wrapConnection(this.wrappedDataSource.getConnection(), Thread.currentThread().getStackTrace());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.wrapConnection(this.wrappedDataSource.getConnection(username, password), Thread.currentThread().getStackTrace());
    }

    protected synchronized Connection wrapConnection(Connection connection, StackTraceElement[] stackTraceElements) {
        ArrayList<StackTraceElement> listStack = new ArrayList<StackTraceElement>();
        boolean wrapperFound = false;
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (wrapperFound) {
                listStack.add(stackTraceElement);
            }
            if (!DatasourceWrapper.class.getName().equals(stackTraceElement.getClassName())) continue;
            wrapperFound = true;
        }
        StackTraceElement[] neWStackTraceElements = listStack.toArray(new StackTraceElement[listStack.size()]);
        Long l = this.count;
        Long l2 = this.count = Long.valueOf(this.count + 1L);
        ConnectionProxy connectionProxy = new ConnectionProxy(l, this, connection, neWStackTraceElements);
        this.openConnectionsMap.put(connectionProxy.getId(), connectionProxy);
        return (Connection)Proxy.newProxyInstance(this.wrappedDataSource.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)connectionProxy);
    }

    protected synchronized void remove(Long id) {
        this.openConnectionsMap.remove(id);
    }

    public synchronized void detect(IResourceCheckerInfo resourceCheckerInfo) {
        ResourceCheckpoints checkPoint = resourceCheckerInfo.getCheckPoint();
        Set<Long> keySet = this.openConnectionsMap.keySet();
        for (Long key : keySet) {
            ConnectionProxy connectionProxy = this.openConnectionsMap.get(key);
            if (this.forceClose) {
                logger.warn((Object)"JDBC connection not closed by the caller, close has been forced by the server. Stack trace of the getConnection() call is ''{0}''. Additional info ''{1}''", new Object[]{Arrays.asList(connectionProxy.getStackTraceElements()).toString().replace(",", "\n"), resourceCheckerInfo.getCallerInfo()});
            } else {
                logger.warn((Object)"JDBC connection not closed by the caller. Stack trace of the getConnection() call is ''{0}''. Additional info ''{1}''", new Object[]{Arrays.asList(connectionProxy.getStackTraceElements()).toString().replace(",", "\n"), resourceCheckerInfo.getCallerInfo()});
            }
            if (!this.forceClose) continue;
            try {
                connectionProxy.getWrappedConnection().close();
            }
            catch (SQLException e) {
                logger.error((Object)"Unable to force the close of the JDBC connection", new Object[]{e});
            }
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.wrappedDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.wrappedDataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.wrappedDataSource.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.wrappedDataSource.getLoginTimeout();
    }

    public String getMapperName() {
        Method getMapperNameMethod = null;
        try {
            getMapperNameMethod = this.wrappedDataSource.getClass().getMethod("getMapperName", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return (String)getMapperNameMethod.invoke((Object)this.wrappedDataSource, new Object[0]);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public void setForceClose(boolean forceClose) {
        this.forceClose = forceClose;
    }

    public boolean equals(Object other) {
        if (this == this.wrappedDataSource) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DatasourceWrapper otherDatasource = (DatasourceWrapper)other;
        return this.wrappedDataSource.equals(otherDatasource.wrappedDataSource);
    }

    public int hashCode() {
        return this.wrappedDataSource.hashCode();
    }
}

