/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.IllegalTimeoutException;
import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.WaiterInterruptedException;
import org.ow2.util.pool.impl.enhanced.api.basic.CreatePoolItemException;
import org.ow2.util.pool.impl.enhanced.api.basic.IBasicPool;
import org.ow2.util.pool.impl.enhanced.api.basic.IPoolItemFactory;
import org.ow2.util.pool.impl.enhanced.api.basic.IPoolItemRemoveListener;
import org.ow2.util.pool.impl.enhanced.api.basic.NoBusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.basic.PoolFactoryBroken;
import org.ow2.util.pool.impl.enhanced.api.basic.accessmanager.IAccessManager;
import org.ow2.util.pool.impl.enhanced.impl.PoolError;
import org.ow2.util.pool.impl.enhanced.impl.basic.FactoryState;
import org.ow2.util.pool.impl.enhanced.impl.basic.RemoveEntry;
import org.ow2.util.pool.impl.enhanced.impl.util.LockFactory;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.InfiniteWaitControl;
import org.ow2.util.pool.impl.enhanced.internal.actionscheduler.ActionSchedulerFactory;
import org.ow2.util.pool.impl.enhanced.internal.actionscheduler.IAction;
import org.ow2.util.pool.impl.enhanced.internal.actionscheduler.IActionScheduler;
import org.ow2.util.pool.impl.enhanced.internal.lock.api.ISignalClearableCondition;
import org.ow2.util.pool.impl.enhanced.internal.lock.impl.SignalClearableConditionProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPool<E>
implements IBasicPool<E> {
    private static final Log LOG = LogFactory.getLog(BasicPool.class);
    private Lock lock;
    private ISignalClearableCondition signalClearableCondition;
    private int usedPoolItem;
    private List<E> availablePoolItemList;
    private List<E> unmodifiableAvailablePoolItemList;
    private IPoolItemRemoveListener<? super E> poolItemRemoveCB;
    private IPoolItemFactory<? extends E> poolItemFactory;
    private int expectedSize;
    private IAccessManager<? super E> accessManager;
    private Object sizeMutex;
    private int brokenScheduledCreateItemCount;
    private int scheduledCreateItemCount;
    private IActionScheduler createItemActionScheduler;
    private IActionScheduler removeItemActionScheduler;
    private int delayedCount;
    private FactoryState factoryState;
    private long temporaryBrokenFactoryEndTime;
    private boolean sizeLockedToZero = false;
    protected static final InfiniteWaitControl INFINITE_WAIT_CONTROL = new InfiniteWaitControl();
    private RemoveEntry<E> firstTreatedRemoveEntry;
    private RemoveEntry<E> headRemoveEntry;
    private RemoveEntry<E> queueRemoveEntry;
    private Object removeMutex = new Object();

    public BasicPool(IPoolItemFactory<? extends E> poolItemFactory, int initPoolSize, IAccessManager<? super E> accessManager, Executor createItemExecutor, IPoolItemRemoveListener<? super E> poolItemRemoveCB, Executor removeItemExecutor) {
        if (initPoolSize < 0 || poolItemFactory == null || accessManager == null) {
            throw new IllegalArgumentException();
        }
        this.factoryState = FactoryState.WORKING;
        this.lock = LockFactory.createLock();
        this.signalClearableCondition = SignalClearableConditionProxy.createProxy(this.lock.newCondition());
        this.sizeMutex = new Object();
        this.scheduledCreateItemCount = 0;
        this.delayedCount = 0;
        this.availablePoolItemList = new ArrayList();
        this.unmodifiableAvailablePoolItemList = Collections.unmodifiableList(this.availablePoolItemList);
        this.accessManager = accessManager;
        this.poolItemFactory = poolItemFactory;
        this.expectedSize = initPoolSize;
        for (int i = 0; i < initPoolSize; ++i) {
            Object poolItem = null;
            do {
                try {
                    poolItem = poolItemFactory.createPoolItem();
                }
                catch (RuntimeException e) {
                    LOG.error((Object)"Factory failed", new Object[]{e});
                }
                catch (CreatePoolItemException e) {
                    LOG.debug((Object)"Factory failed", new Object[]{e});
                    Long brokenTime = e.getBrokenTime();
                    if (brokenTime == null) {
                        this.factoryState = FactoryState.BROKEN;
                    } else {
                        this.factoryState = FactoryState.TEMPORARY_BROKEN;
                        this.temporaryBrokenFactoryEndTime = System.currentTimeMillis() + brokenTime;
                    }
                    this.brokenScheduledCreateItemCount = initPoolSize - i;
                    break;
                }
            } while (poolItem == null);
            this.availablePoolItemList.add(poolItem);
        }
        this.usedPoolItem = 0;
        ActionSchedulerFactory actionSchedulerFactory = new ActionSchedulerFactory();
        this.createItemActionScheduler = actionSchedulerFactory.createActionScheduler(new IAction(){

            public Boolean call() {
                return BasicPool.this.createNewItem();
            }
        }, createItemExecutor);
        this.poolItemRemoveCB = poolItemRemoveCB;
        this.removeItemActionScheduler = actionSchedulerFactory.createActionScheduler(new IAction(){

            public Boolean call() {
                return BasicPool.this.callNextRemoveCallBack();
            }
        }, removeItemExecutor);
    }

    protected int getOneItem() {
        int position = 0;
        try {
            position = this.accessManager.choosePoolItemToGet(this.unmodifiableAvailablePoolItemList);
            if (position != -1 && (position < 0 || position >= this.availablePoolItemList.size())) {
                LOG.error((Object)"Access manager returns {0} which is an invalid value", new Object[]{position});
                position = 0;
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Access manager exception", new Object[]{e});
        }
        return position;
    }

    protected void createOneItem(E poolItem) {
        int position = 0;
        try {
            position = this.accessManager.createPoolItem(this.unmodifiableAvailablePoolItemList, poolItem);
            if (position < 0 || position > this.availablePoolItemList.size()) {
                LOG.error((Object)"Access manager returns {0} which is an invalid value", new Object[]{position});
                position = 0;
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Access manager exception", new Object[]{e});
        }
        this.availablePoolItemList.add(position, poolItem);
    }

    protected void putOneItem(E poolItem) {
        int position = 0;
        try {
            position = this.accessManager.putPoolItem(this.unmodifiableAvailablePoolItemList, poolItem);
            if (position < 0 || position > this.availablePoolItemList.size()) {
                LOG.error((Object)"Access manager returns {0} which is an invalid value", new Object[]{position});
                position = 0;
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Access manager exception", new Object[]{e});
        }
        this.availablePoolItemList.add(position, poolItem);
    }

    protected void releaseOneItem() {
        int position = 0;
        try {
            position = this.accessManager.choosePoolItemToRelease(this.unmodifiableAvailablePoolItemList);
            if (position < 0 || position >= this.availablePoolItemList.size()) {
                LOG.error((Object)"Access manager returns {0} which is an invalid value", new Object[]{position});
                position = 0;
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Access manager exception", new Object[]{e});
        }
        this.releasePoolItem(this.availablePoolItemList.remove(position));
    }

    protected void removeOneItem(E poolItem) {
        try {
            this.accessManager.removePoolItem(poolItem);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Access manager exception", new Object[]{e});
        }
        this.releasePoolItem(poolItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpectedSize(int expectedSize) {
        if (expectedSize < 0) {
            throw new IllegalArgumentException();
        }
        LOG.debug((Object)"Want mutex for setting size to {0}", new Object[]{expectedSize});
        int instanceToCreate = 0;
        int instanceToDelete = 0;
        Object object = this.sizeMutex;
        synchronized (object) {
            this.lock.lock();
            try {
                int unUsedPoolItem;
                int total;
                if (!this.sizeLockedToZero) {
                    if (this.expectedSize != expectedSize) {
                        LOG.debug((Object)"size will change from {0} to {1}", new Object[]{this.expectedSize, expectedSize});
                        this.expectedSize = expectedSize;
                    }
                } else if (this.expectedSize != 0) {
                    LOG.debug((Object)"size will change from {0} to zero", new Object[]{this.expectedSize});
                    this.expectedSize = 0;
                }
                if ((instanceToCreate = this.expectedSize - (total = this.usedPoolItem + (unUsedPoolItem = this.availablePoolItemList.size()))) < 0) {
                    instanceToDelete = Math.min(-instanceToCreate, unUsedPoolItem);
                    for (int i = 0; i < instanceToDelete; ++i) {
                        this.releaseOneItem();
                    }
                }
                switch (this.factoryState) {
                    case BROKEN: {
                        instanceToCreate -= this.brokenScheduledCreateItemCount;
                        if (this.availablePoolItemList.size() == 0) {
                            this.signalClearableCondition.signalAllUnclearable();
                        }
                        break;
                    }
                    case TEMPORARY_BROKEN: {
                        if (System.currentTimeMillis() < this.temporaryBrokenFactoryEndTime) {
                            instanceToCreate -= this.brokenScheduledCreateItemCount;
                            if (this.availablePoolItemList.size() == 0) {
                                this.signalClearableCondition.signalAllUnclearable();
                            }
                        } else if (this.brokenScheduledCreateItemCount != 0) {
                            instanceToCreate += this.brokenScheduledCreateItemCount;
                            this.brokenScheduledCreateItemCount = 0;
                            this.factoryState = FactoryState.WORKING;
                        }
                        break;
                    }
                    case WORKING: {
                        break;
                    }
                    default: {
                        throw new PoolError();
                    }
                }
                Object var9_8 = null;
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.lock.unlock();
                throw throwable;
            }
            if ((instanceToCreate -= this.scheduledCreateItemCount) <= 0) {
                if (this.brokenScheduledCreateItemCount > 0) {
                    this.brokenScheduledCreateItemCount += instanceToCreate;
                    if (this.brokenScheduledCreateItemCount < 0) {
                        instanceToCreate = this.brokenScheduledCreateItemCount;
                        this.brokenScheduledCreateItemCount = 0;
                    } else {
                        instanceToCreate = 0;
                    }
                }
                int cancelled = this.createItemActionScheduler.cancelAction(-instanceToCreate);
                this.scheduledCreateItemCount -= cancelled;
            } else {
                switch (this.factoryState) {
                    case BROKEN: 
                    case TEMPORARY_BROKEN: {
                        this.brokenScheduledCreateItemCount += instanceToCreate;
                        instanceToCreate = 0;
                        break;
                    }
                    case WORKING: {
                        this.scheduledCreateItemCount += instanceToCreate;
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
        }
        if (instanceToDelete > 0 && this.poolItemRemoveCB != null) {
            this.removeItemActionScheduler.scheduleAction(instanceToDelete);
        }
        if (instanceToCreate > 0) {
            this.createItemActionScheduler.scheduleAction(instanceToCreate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockSizeToZero() {
        Object object = this.sizeMutex;
        synchronized (object) {
            this.sizeLockedToZero = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockSizeToZero() {
        Object object = this.sizeMutex;
        synchronized (object) {
            this.sizeLockedToZero = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean createNewItem() {
        int instanceToCreate = 0;
        E poolItem = null;
        CreatePoolItemException createPoolItemException = null;
        do {
            Object object = this.sizeMutex;
            synchronized (object) {
                Object var9_16;
                block37: {
                    Object var7_13;
                    if (createPoolItemException == null) break block37;
                    this.lock.lock();
                    try {
                        block39: {
                            Long brokenTime;
                            block38: {
                                brokenTime = createPoolItemException.getBrokenTime();
                                if (brokenTime != null) break block38;
                                this.factoryState = FactoryState.BROKEN;
                                if (this.availablePoolItemList.size() == 0) {
                                    this.signalClearableCondition.signalAllUnclearable();
                                }
                                break block39;
                            }
                            switch (this.factoryState) {
                                case BROKEN: {
                                    break;
                                }
                                case TEMPORARY_BROKEN: {
                                    this.temporaryBrokenFactoryEndTime = Math.max(this.temporaryBrokenFactoryEndTime, System.currentTimeMillis() + brokenTime);
                                    break;
                                }
                                case WORKING: {
                                    this.temporaryBrokenFactoryEndTime = System.currentTimeMillis() + brokenTime;
                                    this.factoryState = FactoryState.TEMPORARY_BROKEN;
                                    if (this.availablePoolItemList.size() == 0) {
                                        this.signalClearableCondition.signalAllUnclearable();
                                    }
                                    break;
                                }
                                default: {
                                    throw new Error();
                                }
                            }
                        }
                        var7_13 = null;
                        this.lock.unlock();
                    }
                    catch (Throwable throwable) {
                        var7_13 = null;
                        this.lock.unlock();
                        throw throwable;
                    }
                }
                switch (this.factoryState) {
                    case BROKEN: {
                        --this.scheduledCreateItemCount;
                        ++this.brokenScheduledCreateItemCount;
                        return false;
                    }
                    case TEMPORARY_BROKEN: {
                        --this.scheduledCreateItemCount;
                        ++this.brokenScheduledCreateItemCount;
                        return false;
                    }
                    case WORKING: {
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
                this.lock.lock();
                try {
                    int unUsedPoolItem = this.availablePoolItemList.size();
                    int total = this.usedPoolItem + unUsedPoolItem;
                    instanceToCreate = this.expectedSize - total;
                    if (instanceToCreate <= 0) {
                        if (instanceToCreate != 0 && unUsedPoolItem != 0) {
                            LOG.error((Object)"Issue in algorithm : check remove / put methods", new Object[0]);
                        }
                        --this.scheduledCreateItemCount;
                        if (this.scheduledCreateItemCount == 0) {
                            this.sizeMutex.notifyAll();
                        }
                        boolean bl = false;
                        var9_16 = null;
                        this.lock.unlock();
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    var9_16 = null;
                    this.lock.unlock();
                    throw throwable;
                }
                var9_16 = null;
                this.lock.unlock();
            }
            LOG.debug((Object)"create new item", new Object[0]);
            try {
                poolItem = this.poolItemFactory.createPoolItem();
            }
            catch (RuntimeException e) {
                LOG.error((Object)"Factory failed", new Object[]{e});
            }
            catch (CreatePoolItemException e) {
                LOG.debug((Object)"Factory failed", new Object[]{e});
                createPoolItemException = e;
            }
        } while (poolItem == null);
        boolean instanceDeleted = false;
        Object object = this.sizeMutex;
        synchronized (object) {
            this.lock.lock();
            try {
                this.createOneItem(poolItem);
                int unUsedPoolItem = this.availablePoolItemList.size();
                int total = this.usedPoolItem + unUsedPoolItem;
                instanceToCreate = this.expectedSize - total;
                if (instanceToCreate < 0) {
                    int instanceToDelete = Math.min(-instanceToCreate, unUsedPoolItem);
                    if (instanceToDelete != 1) {
                        LOG.error((Object)"Issue in algorithm : check remove / put methods", new Object[0]);
                    }
                    this.releaseOneItem();
                    instanceDeleted = true;
                } else {
                    this.signalClearableCondition.signal();
                }
                if (this.delayedCount != 0) {
                    this.signalClearableCondition.signalAll();
                }
                Object var12_20 = null;
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var12_21 = null;
                this.lock.unlock();
                throw throwable;
            }
            --this.scheduledCreateItemCount;
            if (this.scheduledCreateItemCount == 0) {
                this.sizeMutex.notifyAll();
            }
        }
        if (instanceDeleted && this.poolItemRemoveCB != null) {
            this.callNextRemoveCallBack();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(IWaitControl timeout) throws TimeoutPoolException, IllegalTimeoutException, WaiterInterruptedException, InterruptedException, PoolFactoryBroken {
        E poolItem = null;
        boolean delayed = false;
        this.lock.lock();
        try {
            int size = this.availablePoolItemList.size();
            int poolItemToGetChoosed = -1;
            if (size != 0) {
                poolItemToGetChoosed = this.getOneItem();
                if (poolItemToGetChoosed == -1) {
                    ++this.delayedCount;
                    delayed = true;
                }
            } else {
                switch (this.factoryState) {
                    case BROKEN: {
                        throw new PoolFactoryBroken(null);
                    }
                    case TEMPORARY_BROKEN: {
                        throw new PoolFactoryBroken(this.temporaryBrokenFactoryEndTime);
                    }
                    case WORKING: {
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (poolItemToGetChoosed == -1) {
                if (!timeout.canContinueToWait()) {
                    throw new TimeoutPoolException();
                }
                block12: while (poolItemToGetChoosed == -1) {
                    if (!timeout.waitOnCondition(this.signalClearableCondition)) {
                        throw new TimeoutPoolException();
                    }
                    LOG.debug((Object)"wait notified or expired", new Object[0]);
                    size = this.availablePoolItemList.size();
                    if (size != 0) {
                        poolItemToGetChoosed = this.getOneItem();
                        if (delayed || poolItemToGetChoosed != -1) continue;
                        ++this.delayedCount;
                        delayed = true;
                        continue;
                    }
                    if (delayed) {
                        --this.delayedCount;
                        delayed = false;
                    }
                    switch (this.factoryState) {
                        case BROKEN: {
                            throw new PoolFactoryBroken(null);
                        }
                        case TEMPORARY_BROKEN: {
                            throw new PoolFactoryBroken(this.temporaryBrokenFactoryEndTime);
                        }
                        case WORKING: {
                            continue block12;
                        }
                    }
                    throw new Error();
                }
            }
            ++this.usedPoolItem;
            poolItem = this.availablePoolItemList.remove(poolItemToGetChoosed);
            if (size == 1) {
                this.signalClearableCondition.clearAllSignal();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"pool {0}/{1}", new Object[]{this.usedPoolItem, this.availablePoolItemList.size() + this.usedPoolItem});
            }
            Object var7_6 = null;
            if (delayed) {
                --this.delayedCount;
            }
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (delayed) {
                --this.delayedCount;
            }
            this.lock.unlock();
            throw throwable;
        }
        return poolItem;
    }

    @Override
    public E get() throws WaiterInterruptedException, InterruptedException, PoolFactoryBroken {
        try {
            return this.get(INFINITE_WAIT_CONTROL);
        }
        catch (TimeoutPoolException e) {
            throw new Error("get(INFINITE_TIMEOUT) should not return a TimeoutPoolException");
        }
        catch (IllegalTimeoutException e) {
            throw new Error("get(INFINITE_TIMEOUT) should not return a IllegalTimeoutException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E poolItem) throws NotABusyPoolItemException {
        if (poolItem == null) {
            throw new NotABusyPoolItemException();
        }
        boolean instanceDeleted = false;
        this.lock.lock();
        try {
            if (this.usedPoolItem <= 0) {
                throw new NoBusyPoolItemException();
            }
            int remainToDelete = this.usedPoolItem - this.expectedSize;
            --this.usedPoolItem;
            this.putOneItem(poolItem);
            if (remainToDelete <= 0) {
                if (this.delayedCount == 0) {
                    this.signalClearableCondition.signal();
                } else {
                    this.signalClearableCondition.signalAll();
                }
            } else {
                this.releaseOneItem();
                instanceDeleted = true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"pool {0}/{1} (used/total)", new Object[]{this.usedPoolItem, this.availablePoolItemList.size() + this.usedPoolItem});
            }
            Object var5_4 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
        if (instanceDeleted && this.poolItemRemoveCB != null) {
            this.removeItemActionScheduler.scheduleAction(1);
        }
    }

    protected IPoolItemFactory<? extends E> getPoolItemFactory() {
        return this.poolItemFactory;
    }

    protected IAccessManager<? super E> getReleaseListener() {
        return this.accessManager;
    }

    protected void setUsedPoolItem(int usedPoolItem) {
        this.usedPoolItem = usedPoolItem;
    }

    protected List<E> getAvailablePoolItemList() {
        return this.availablePoolItemList;
    }

    protected int getExpectedSize() {
        return this.expectedSize;
    }

    protected int getUsedPoolItem() {
        return this.usedPoolItem;
    }

    protected int getUnUsedPoolItem() {
        return this.availablePoolItemList.size();
    }

    protected final Lock getLock() {
        return this.lock;
    }

    protected ISignalClearableCondition getSignalClearableCondition() {
        return this.signalClearableCondition;
    }

    protected int getDelayedCount() {
        return this.delayedCount;
    }

    protected void setDelayedCount(int delayedCount) {
        this.delayedCount = delayedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAllWaiters() {
        this.lock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"begin interrupt {0}/{1} (used/total)", new Object[]{this.usedPoolItem, this.availablePoolItemList.size() + this.usedPoolItem});
            }
            this.signalClearableCondition.signalAllUnclearable();
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releasePoolItem(E releasePoolItem) {
        if (this.poolItemRemoveCB != null) {
            Object object = this.removeMutex;
            synchronized (object) {
                RemoveEntry<E> nextQueueRemoveEntry = new RemoveEntry<E>(releasePoolItem, null);
                if (this.headRemoveEntry == null) {
                    this.headRemoveEntry = nextQueueRemoveEntry;
                }
                if (this.queueRemoveEntry == null) {
                    this.firstTreatedRemoveEntry = nextQueueRemoveEntry;
                } else {
                    this.queueRemoveEntry.setNext(nextQueueRemoveEntry);
                }
                this.queueRemoveEntry = nextQueueRemoveEntry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPool() throws InterruptedException {
        this.setExpectedSize(0);
        Object object = this.sizeMutex;
        synchronized (object) {
            while (this.scheduledCreateItemCount != 0) {
                this.sizeMutex.wait();
                if (this.scheduledCreateItemCount >= 0) continue;
                throw new Error("wait not possible, pool buggy");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitAllRemoveListenerCompleted() throws InterruptedException {
        RemoveEntry<E> lastWaitForRemoveEntry;
        if (this.poolItemRemoveCB == null) {
            return;
        }
        RemoveEntry<E> removeEntry = this.removeMutex;
        synchronized (removeEntry) {
            RemoveEntry<E> firstWaitForRemoveEntry = this.firstTreatedRemoveEntry;
            if (firstWaitForRemoveEntry == null) {
                return;
            }
            lastWaitForRemoveEntry = this.queueRemoveEntry;
        }
        removeEntry = lastWaitForRemoveEntry;
        synchronized (removeEntry) {
            while (!lastWaitForRemoveEntry.isCallBackComplete()) {
                lastWaitForRemoveEntry.wait();
            }
        }
        for (RemoveEntry<E> currentWaitForRemoveEntry = firstWaitForRemoveEntry; currentWaitForRemoveEntry != lastWaitForRemoveEntry; currentWaitForRemoveEntry = currentWaitForRemoveEntry.getNext()) {
            RemoveEntry<E> removeEntry2 = currentWaitForRemoveEntry;
            synchronized (removeEntry2) {
                while (!currentWaitForRemoveEntry.isCallBackComplete()) {
                    currentWaitForRemoveEntry.wait();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean callNextRemoveCallBack() {
        RemoveEntry<E> previousHeadRemoveEntry;
        Object object = this.removeMutex;
        synchronized (object) {
            previousHeadRemoveEntry = this.headRemoveEntry;
            if (previousHeadRemoveEntry == null) {
                return false;
            }
            this.headRemoveEntry = this.headRemoveEntry.getNext();
        }
        try {
            this.poolItemRemoveCB.poolItemRemoved(previousHeadRemoveEntry.getPoolItem());
        }
        catch (RuntimeException e) {
            LOG.error((Object)"poolItemRemoved failed", new Object[]{e});
        }
        object = previousHeadRemoveEntry;
        synchronized (object) {
            previousHeadRemoveEntry.setCallBackComplete(true);
            previousHeadRemoveEntry.notifyAll();
        }
        object = this.removeMutex;
        synchronized (object) {
            if (this.firstTreatedRemoveEntry == previousHeadRemoveEntry) {
                this.firstTreatedRemoveEntry = this.firstTreatedRemoveEntry.getNext();
                while (this.firstTreatedRemoveEntry != null) {
                    RemoveEntry<E> removeEntry = this.firstTreatedRemoveEntry;
                    synchronized (removeEntry) {
                        if (!this.firstTreatedRemoveEntry.isCallBackComplete()) {
                            break;
                        }
                        this.firstTreatedRemoveEntry = this.firstTreatedRemoveEntry.getNext();
                    }
                }
                if (this.firstTreatedRemoveEntry == null) {
                    this.queueRemoveEntry = null;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(E poolItem) throws NotABusyPoolItemException {
        if (poolItem == null) {
            throw new NotABusyPoolItemException();
        }
        boolean scheduleCreation = false;
        Object object = this.sizeMutex;
        synchronized (object) {
            int instanceToCreate = 0;
            this.lock.lock();
            try {
                if (this.usedPoolItem <= 0) {
                    throw new NoBusyPoolItemException();
                }
                this.removeOneItem(poolItem);
                --this.usedPoolItem;
                int unUsedPoolItem = this.availablePoolItemList.size();
                int total = this.usedPoolItem + unUsedPoolItem;
                instanceToCreate = this.expectedSize - total;
                if (instanceToCreate < 0 && unUsedPoolItem != 0) {
                    LOG.error((Object)"issue in setExpectedSize, remove method should not make this stuff", new Object[0]);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"pool {0}/{1} (used/total)", new Object[]{this.usedPoolItem, this.availablePoolItemList.size() + this.usedPoolItem});
                }
                Object var8_7 = null;
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.lock.unlock();
                throw throwable;
            }
            if ((instanceToCreate -= this.scheduledCreateItemCount) > 0) {
                ++this.scheduledCreateItemCount;
                scheduleCreation = true;
                if (instanceToCreate != 1) {
                    LOG.error((Object)"issue in setExpectedSize, remove method should not schedule more than one instance creation", new Object[0]);
                }
            }
        }
        if (this.poolItemRemoveCB != null) {
            this.removeItemActionScheduler.scheduleAction(1);
        }
        if (scheduleCreation) {
            this.createItemActionScheduler.scheduleAction(1);
        }
    }

    protected List<E> getUnmodifiableAvailablePoolItemList() {
        return this.unmodifiableAvailablePoolItemList;
    }

    protected long getTemporaryBrokenFactoryEndTime() {
        return this.temporaryBrokenFactoryEndTime;
    }

    protected FactoryState getFactoryState() {
        return this.factoryState;
    }
}

