/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.limited;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.impl.limited.TooManyWaiterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitedWaiterPool<E>
implements IPool<E> {
    private static final Log LOG = LogFactory.getLog(LimitedWaiterPool.class);
    public static final int NO_LIMIT_WAITER = -1;
    private Object mutex;
    private int maxWaiter;
    private int currentWaiter;
    private IPool<E> pool;

    public LimitedWaiterPool(IPool<E> pool) {
        this(pool, -1);
    }

    public LimitedWaiterPool(IPool<E> pool, int maxWaiter) {
        if (maxWaiter < 0 && maxWaiter != -1) {
            throw new IllegalArgumentException();
        }
        this.mutex = new Object();
        this.pool = pool;
        this.maxWaiter = maxWaiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(IWaitControl timeout) throws PoolException, InterruptedException {
        this.addWaiter();
        try {
            E e = this.pool.get(timeout);
            return e;
        }
        finally {
            this.removeWaiter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWaiter() throws TooManyWaiterException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.maxWaiter != -1 && this.currentWaiter >= this.maxWaiter) {
                throw new TooManyWaiterException();
            }
            ++this.currentWaiter;
            LOG.debug((Object)"there is {0} waiters ", new Object[]{this.currentWaiter});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWaiter() throws TooManyWaiterException {
        Object object = this.mutex;
        synchronized (object) {
            --this.currentWaiter;
            if (this.currentWaiter == 0) {
                this.mutex.notifyAll();
            }
            LOG.debug((Object)"there is {0} waiters ", new Object[]{this.currentWaiter});
        }
    }

    @Override
    public void put(E e) throws NotABusyPoolItemException {
        this.pool.put(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxWaiter(int maxWaiter) {
        if (maxWaiter < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.mutex;
        synchronized (object) {
            this.maxWaiter = maxWaiter;
        }
    }

    @Override
    public void signalAllWaiters() {
        this.pool.signalAllWaiters();
    }

    @Override
    public void remove(E poolItem) throws NotABusyPoolItemException {
        this.pool.remove(poolItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitEmptyWaiterInPool() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.currentWaiter != 0) {
                this.mutex.wait();
            }
        }
    }
}

