/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.timer;

import java.util.ArrayList;
import java.util.Iterator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.timer.Batch;
import org.ow2.jonas.lib.timer.Clock;
import org.ow2.jonas.lib.timer.TimerEvent;
import org.ow2.jonas.lib.timer.TimerEventListener;
import org.ow2.jonas.lib.timer.TraceTimer;

public class TimerManager {
    private static Batch batchThread;
    private static Clock clockThread;
    private static final long PERIOD_MAX = 30000L;
    private static final long PERIOD_MIN = 100L;
    private long period;
    private long minremtime = 30000L;
    private ArrayList timerList = new ArrayList();
    private ArrayList expiredList = new ArrayList();
    private static TimerManager unique;
    private static boolean shuttingdown;

    private TimerManager() {
        batchThread = new Batch(this);
        batchThread.start();
        clockThread = new Clock(this);
        clockThread.start();
    }

    public static TimerManager getInstance() {
        if (unique == null) {
            unique = new TimerManager();
        }
        return unique;
    }

    public static void stop(boolean force) {
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Stop TimerManager");
        }
        shuttingdown = true;
        while (clockThread.isAlive() || batchThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"TimerManager has stopped");
        }
    }

    public static void stop() {
        TimerManager.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clock() {
        ArrayList arrayList = this.timerList;
        synchronized (arrayList) {
            while (true) {
                if (shuttingdown) {
                    this.period = 1L;
                } else {
                    this.period = 30000L;
                    if (this.minremtime < this.period) {
                        this.period = this.minremtime < 100L ? 100L : this.minremtime;
                    }
                }
                try {
                    this.timerList.wait(this.period);
                }
                catch (InterruptedException e) {
                    TraceTimer.logger.log(BasicLevel.ERROR, (Object)"Timer interrupted");
                }
                int found = 0;
                boolean empty = true;
                this.minremtime = 30000L;
                Iterator i = this.timerList.iterator();
                while (i.hasNext()) {
                    long remtime;
                    TimerEvent t = (TimerEvent)i.next();
                    if (!t.isStopped()) {
                        empty = false;
                    }
                    if ((remtime = t.update()) <= 0L) {
                        if (t.valid()) {
                            this.expiredList.add(t);
                            ++found;
                            if (t.ispermanent() && !shuttingdown) {
                                remtime = t.restart();
                                if (remtime < this.minremtime) {
                                    this.minremtime = remtime;
                                }
                            } else {
                                i.remove();
                            }
                        } else {
                            i.remove();
                        }
                    } else if (remtime < this.minremtime) {
                        this.minremtime = remtime;
                    }
                    t = null;
                }
                if (found > 0) {
                    this.timerList.notifyAll();
                    continue;
                }
                if (empty && shuttingdown) break;
            }
            this.timerList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch() {
        while (!(shuttingdown && this.timerList.isEmpty() && this.expiredList.isEmpty())) {
            TimerEvent t;
            ArrayList arrayList = this.timerList;
            synchronized (arrayList) {
                while (this.expiredList.isEmpty()) {
                    if (shuttingdown) {
                        TraceTimer.logger.log(BasicLevel.WARN, (Object)"TimerManager shutting down");
                        return;
                    }
                    try {
                        this.timerList.wait();
                    }
                    catch (Exception e) {
                        TraceTimer.logger.log(BasicLevel.ERROR, (Object)"Exception in Batch: ", (Throwable)e);
                    }
                }
                t = (TimerEvent)this.expiredList.remove(0);
            }
            try {
                t.process();
            }
            catch (Exception e) {
                TraceTimer.logger.log(BasicLevel.WARN, (Object)("Ignoring exception: " + e));
                e.printStackTrace();
            }
        }
        TraceTimer.logger.log(BasicLevel.WARN, (Object)"TimerManager stopped");
    }

    public TimerEvent addTimer(TimerEventListener tel, long timeout, Object arg, boolean permanent) {
        return this.addTimerMs(tel, timeout * 1000L, arg, permanent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerEvent addTimerMs(TimerEventListener tel, long timeout, Object arg, boolean permanent) {
        TimerEvent te = new TimerEvent(tel, timeout, arg, permanent);
        ArrayList arrayList = this.timerList;
        synchronized (arrayList) {
            this.timerList.add(te);
            if (timeout < this.minremtime) {
                this.minremtime = timeout;
            }
            this.timerList.notifyAll();
        }
        return te;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimer(TimerEvent te) {
        ArrayList arrayList = this.timerList;
        synchronized (arrayList) {
            this.timerList.remove(this.timerList.indexOf(te));
        }
    }

    static {
        unique = null;
        shuttingdown = false;
    }
}

