/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Date;
import java.util.Map;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.lib.BasicComparator;

public class Equal
extends BasicComparator {
    private static final long serialVersionUID = 4990026954535396685L;
    private int strength = 0;

    public Equal() {
    }

    public Equal(int strength) {
        this.strength = strength;
    }

    public Equal(Expression l, Expression r) {
        super(l, r);
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        ((Equal)clone).strength = this.strength;
        return clone;
    }

    public boolean evaluate(Object op1, Object op2) {
        boolean res = false;
        if (op1 instanceof Character) {
            Character o1 = (Character)op1;
            Character o2 = (Character)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof Long) {
            Long o1 = (Long)op1;
            Long o2 = (Long)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof Short) {
            Short o1 = (Short)op1;
            Short o2 = (Short)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof Integer) {
            Integer o1 = (Integer)op1;
            Integer o2 = (Integer)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof Float) {
            Float o1 = (Float)op1;
            Float o2 = (Float)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof Double) {
            Double o1 = (Double)op1;
            Double o2 = (Double)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof Byte) {
            Byte o1 = (Byte)op1;
            Byte o2 = (Byte)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof Date) {
            Date o1 = (Date)op1;
            Date o2 = (Date)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof Time) {
            Time o1 = (Time)op1;
            Time o2 = (Time)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof Timestamp) {
            Timestamp o1 = (Timestamp)op1;
            Timestamp o2 = (Timestamp)op2;
            res = o1.compareTo(o2) == 0;
        } else if (op1 instanceof String) {
            Collator myCollator = Collator.getInstance();
            myCollator.setStrength(this.strength);
            String o1 = (String)op1;
            String o2 = (String)op2;
            res = myCollator.compare(o1, o2) == 0;
        }
        return res;
    }

    public boolean evaluate(int op1, int op2) {
        return op1 == op2;
    }

    public boolean evaluate(int op1, short op2) {
        return op1 == op2;
    }

    public boolean evaluate(int op1, long op2) {
        return (long)op1 == op2;
    }

    public boolean evaluate(int op1, float op2) {
        return (float)op1 == op2;
    }

    public boolean evaluate(int op1, double op2) {
        return (double)op1 == op2;
    }

    public boolean evaluate(float op1, float op2) {
        return op1 == op2;
    }

    public boolean evaluate(float op1, short op2) {
        return op1 == (float)op2;
    }

    public boolean evaluate(float op1, int op2) {
        return op1 == (float)op2;
    }

    public boolean evaluate(float op1, long op2) {
        return op1 == (float)op2;
    }

    public boolean evaluate(float op1, double op2) {
        return (double)op1 == op2;
    }

    public boolean evaluate(char op1, char op2) {
        return op1 == op2;
    }

    public boolean evaluate(long op1, short op2) {
        return op1 == (long)op2;
    }

    public boolean evaluate(long op1, int op2) {
        return op1 == (long)op2;
    }

    public boolean evaluate(long op1, long op2) {
        return op1 == op2;
    }

    public boolean evaluate(long op1, float op2) {
        return (float)op1 == op2;
    }

    public boolean evaluate(long op1, double op2) {
        return (double)op1 == op2;
    }

    public boolean evaluate(double op1, short op2) {
        return op1 == (double)op2;
    }

    public boolean evaluate(double op1, int op2) {
        return op1 == (double)op2;
    }

    public boolean evaluate(double op1, long op2) {
        return op1 == (double)op2;
    }

    public boolean evaluate(double op1, float op2) {
        return op1 == (double)op2;
    }

    public boolean evaluate(double op1, double op2) {
        return op1 == op2;
    }

    public boolean evaluate(boolean op1, boolean op2) {
        return op1 == op2;
    }

    public boolean evaluate(String op1, String op2) {
        Collator myCollator = Collator.getInstance();
        myCollator.setStrength(this.strength);
        return myCollator.compare(op1, op2) == 0;
    }

    public String getOperatorString() {
        return "==";
    }
}

