/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JEntityContext;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntitySwitch;
import org.ow2.jonas.lib.ejb21.JEntitySwitchCST;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public class JEntitySwitchCRW
extends JEntitySwitchCST {
    public JEntitySwitchCRW() {
        this.lockpolicy = 5;
    }

    protected void initpolicy(JEntityFactory bf) {
        this.lazyregister = !bf.isPrefetch();
    }

    public void waitmyturn(Transaction tx) {
        if (tx != null) {
            int waitcount = 0;
            Transaction lastrunning = null;
            while (this.runningtx != null && !tx.equals(this.runningtx)) {
                if (TraceEjb.isDebugSynchro()) {
                    TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: WAIT end IT"));
                }
                this.blockedtx.add(tx);
                if (waitcount > 0 && this.runningtx.equals(lastrunning) && this.bf.isDeadLocked(this.runningtx)) {
                    this.blockedtx.remove(tx);
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (SystemException e) {
                        TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ident + "getICtx IT: unexpected exception setting rollbackonly"));
                    }
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + "getICtx IT: transaction rolled back"));
                    throw new TransactionRolledbackLocalException("possible deadlock");
                }
                lastrunning = this.runningtx;
                ++waitcount;
                ++this.waiters;
                try {
                    this.wait(this.deadlockTimeout);
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: NOTIFIED"));
                    }
                }
                catch (InterruptedException e) {
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: INTERRUPTED"));
                    }
                }
                catch (Exception e) {
                    throw new EJBException("JEntitySwitch synchronization pb", e);
                }
                finally {
                    --this.waiters;
                    this.blockedtx.remove(tx);
                }
                int status = 4;
                try {
                    status = tx.getStatus();
                }
                catch (SystemException e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ident + "getICtx IT: unexpected exception getting transaction status"));
                }
                switch (status) {
                    case 1: 
                    case 4: 
                    case 9: {
                        TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + "getICtx IT: transaction rolled back"));
                        throw new TransactionRolledbackLocalException("rollback occured while waiting");
                    }
                }
            }
        }
    }

    public synchronized JEntityContext mapICtx(Transaction tx, JEntityContext bctx, boolean forced, boolean holdit, boolean checkreentrance) {
        if (!this.reentrant && checkreentrance) {
            if (this.runningtx != null && this.countIT > 0 && tx != null && tx.equals(this.runningtx)) {
                throw new EJBException("non-reentrant bean accessed twice in same transaction");
            }
            if (tx == null && this.countIH > 0) {
                throw new EJBException("non-reentrant bean accessed twice outside transaction");
            }
        }
        this.waitmyturn(tx);
        this.estimestamp = System.currentTimeMillis() + 2000L;
        if (this.isdetached) {
            JEntityFactory fact = this.bf;
            JEntitySwitch old = fact.existEJB(this.getPrimaryKey(), this);
            if (old != null) {
                throw new NoSuchObjectLocalException("Inactivity timeout expired");
            }
            if (TraceEjb.isDebugSwapper()) {
                TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("*** Reuse " + this.ident + " after timeout"));
            }
            this.isdetached = false;
        }
        boolean newtrans = false;
        boolean isdirty = false;
        JEntityContext jec = this.itContext;
        if (forced) {
            if (jec != null) {
                this.discardContext(tx, false, true);
            }
            this.itContext = jec = bctx;
            isdirty = jec.initEntityContext(this);
            newtrans = true;
        } else {
            if (this.isremoved) {
                TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + " has been removed."));
                throw new NoSuchObjectLocalException("Try to access a bean previously removed");
            }
            if (jec != null) {
                if (this.todiscard) {
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + " has been discarded."));
                    throw new NoSuchObjectLocalException("Try to access a bean previously discarded");
                }
                if (bctx != null) {
                    this.bf.releaseJContext(bctx, 2);
                }
                if (this.runningtx == null) {
                    newtrans = true;
                }
                jec.reuseEntityContext(newtrans);
            } else {
                jec = bctx != null ? bctx : this.bf.getJContext(this);
                isdirty = jec.initEntityContext(this);
                jec.activate(true);
                this.itContext = jec;
                newtrans = true;
            }
        }
        if (tx != null) {
            if (newtrans && (!this.lazyregister || isdirty)) {
                try {
                    this.registerCtx(tx, jec);
                }
                catch (IllegalStateException e) {
                    TraceEjb.synchro.log(BasicLevel.WARN, (Object)(this.ident + "mapICtx IT: not registered!"), (Throwable)e);
                    throw e;
                }
            }
            if (holdit) {
                ++this.countIT;
            }
        } else if (holdit) {
            ++this.countIH;
            if (this.shared && this.countIH == 1) {
                jec.activate(false);
            }
        }
        return jec;
    }
}

