/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.carol.rmi.exception.NoSuchObjectExceptionHelper;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.jonas.Version;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerInfo;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerManager;
import org.ow2.jonas.jndi.checker.api.ResourceCheckpoints;
import org.ow2.jonas.lib.ejb21.BeanFactory;
import org.ow2.jonas.lib.ejb21.EJBInvocation;
import org.ow2.jonas.lib.ejb21.EJBResourceCheckerInfo;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JObjectInputStream;
import org.ow2.jonas.lib.ejb21.JStatefulFactory;
import org.ow2.jonas.lib.ejb21.JTimerHandle;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.jonas.lib.timer.TraceTimer;
import org.ow2.jonas.lib.util.DirFilter;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.util.event.api.IEventDispatcher;

public abstract class JFactory
implements BeanFactory {
    protected JContainer cont;
    protected boolean stopped = false;
    protected JNamingManager naming = null;
    protected TransactionManager tm = null;
    protected WorkManager wm = null;
    protected Context JNDICtx = null;
    protected String ejbname = null;
    protected BeanDesc dd;
    protected Properties ejb10Env = null;
    protected TimerService myTimerService = null;
    protected boolean txbeanmanaged = false;
    protected Class<?> beanclass = null;
    protected File passivationDir;
    protected int minPoolSize;
    protected int maxCacheSize;
    protected boolean isClusterReplicated;
    private boolean iiopProtocolAvailable = false;
    protected int timerTxAttr;
    protected String ejbTimeoutSignature;
    protected IEventDispatcher dispatcher;
    private IResourceCheckerManager resourceCheckerManager = null;

    public JFactory() {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
    }

    public void stopContainer() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public File getPassivationDir() {
        return this.passivationDir;
    }

    public JFactory(BeanDesc dd, JContainer cont) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.init(dd, cont);
    }

    public void init(BeanDesc dd, JContainer cont) {
        String cln;
        this.cont = cont;
        this.dd = dd;
        this.naming = cont.getContainerNaming();
        this.tm = cont.getTransactionManager();
        this.wm = cont.getWorkManager();
        this.ejbname = dd.getEjbName();
        this.ejb10Env = dd.getEjb10Environment();
        this.maxCacheSize = dd.getCacheMax();
        this.minPoolSize = dd.getPoolMin();
        this.isClusterReplicated = dd.isClusterReplicated();
        String string = cln = dd.getFullWrpHomeName() != null ? dd.getFullWrpHomeName() : dd.getFullWrpLocalHomeName();
        if (cln != null) {
            this.checkJonasVersion(cln);
        }
        try {
            JComponentContextFactory ccf = cont.getComponentContextFactory();
            if (ccf == null) {
                throw new EJBException("No Component Context Factory");
            }
            this.JNDICtx = ccf.createComponentContext(this.ejbname);
            cont.setBeanEnvironment(this.JNDICtx, dd);
        }
        catch (NamingException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot build naming for this component", (Throwable)e);
            throw new EJBException("Cannot build naming for this component", (Exception)e);
        }
        String cn = null;
        try {
            cn = dd.getFullDerivedBeanName();
            this.beanclass = cont.getClassLoader().loadClass(cn);
        }
        catch (ClassNotFoundException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("failed to find class " + cn + e));
            throw new EJBException("Container failed to find class " + cn, (Exception)e);
        }
        this.timerTxAttr = dd.getTimerTxAttribute();
        this.ejbTimeoutSignature = dd.getEjbTimeoutSignature();
        String protocol = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
        if (protocol.equals("iiop")) {
            this.iiopProtocolAvailable = true;
        }
        String pds = cont.getTmpDirName() + File.separator + dd.getIdentifier();
        this.passivationDir = new File(pds);
        if (!this.passivationDir.isDirectory()) {
            this.passivationDir.mkdir();
            TraceEjb.factory.log(BasicLevel.DEBUG, (Object)("created: " + pds));
        }
    }

    public WorkManager getWorkManager() {
        return this.wm;
    }

    public abstract void initInstancePool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartTimers() {
        String[] timerList = this.getFileList(this.passivationDir, null, ".tim");
        for (int i = 0; i < timerList.length; ++i) {
            File file = new File(this.passivationDir, timerList[i]);
            Timer timer = null;
            ObjectInputStream ois = null;
            try {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("restarting: " + timerList[i]));
                ois = new JObjectInputStream(new FileInputStream(file), this.cont.getClassLoader());
                JTimerHandle th = (JTimerHandle)ois.readObject();
                timer = th.restartTimer();
                file.delete();
                ois.close();
                continue;
            }
            catch (Exception e) {
                TraceTimer.logger.log(BasicLevel.ERROR, (Object)("Cannot restart timer: " + timerList[i]));
                TraceTimer.logger.log(BasicLevel.ERROR, (Object)("For bean: " + this.passivationDir));
                TraceTimer.logger.log(BasicLevel.ERROR, (Object)("Exception: " + e));
                if (timer == null) continue;
                try {
                    timer.cancel();
                }
                catch (Exception ign) {
                    TraceTimer.logger.log(BasicLevel.ERROR, (Object)("Cancel timer: " + e));
                }
                continue;
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception ig) {
                        TraceTimer.logger.log(BasicLevel.WARN, (Object)("Cannot close ObjectInputStream: " + ig));
                    }
                }
            }
        }
    }

    protected boolean isClassAvailable(String className, boolean unique) {
        className = className.replace('.', '/') + ".class";
        Enumeration<URL> e = null;
        try {
            e = ((URLClassLoader)this.cont.getClassLoader()).findResources(className);
        }
        catch (IOException e1) {
            return false;
        }
        if (e.hasMoreElements()) {
            e.nextElement();
            return unique ? !e.hasMoreElements() : true;
        }
        return false;
    }

    public String getEJBName() {
        return this.ejbname;
    }

    public abstract int getPoolSize();

    public BeanDesc getDeploymentDescriptor() {
        return this.dd;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public JContainer getContainer() {
        return this.cont;
    }

    public Hashtable getEnv() {
        return this.naming.getEnv();
    }

    public InitialContext getInitialContext() {
        return this.naming.getInitialContext();
    }

    public abstract TimerService getTimerService();

    public Properties getEjb10Environment() {
        return this.ejb10Env;
    }

    public boolean isTxBeanManaged() {
        return this.txbeanmanaged;
    }

    public Context setComponentContext() {
        Context oldctx = this.naming.setComponentContext(this.JNDICtx);
        if (TraceEjb.isDebugLoaderLog() && oldctx == null) {
            TraceEjb.loaderlog.log(BasicLevel.DEBUG, (Object)"previous ctx was null");
        }
        return oldctx;
    }

    public void resetComponentContext(Context oldctx) {
        if (TraceEjb.isDebugLoaderLog() && oldctx == null) {
            TraceEjb.loaderlog.log(BasicLevel.DEBUG, (Object)"to null");
        }
        this.naming.resetComponentContext(oldctx);
    }

    public int getTimerTxAttribute() {
        return this.timerTxAttr;
    }

    public String getEjbTimeoutSignature() {
        return this.ejbTimeoutSignature;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getCacheSize() {
        throw new IllegalStateException();
    }

    public void checkSecurity(EJBInvocation ejbInv) {
        String runAsRoleDD = null;
        try {
            if (ejbInv != null && ejbInv.methodPermissionSignature != null && ejbInv.methodPermissionSignature.length() != 0) {
                this.cont.checkSecurity(this.ejbname, ejbInv, this.dd.getRunAsRole() != null);
            }
            if ((runAsRoleDD = this.dd.getRunAsRole()) != null) {
                SecurityCurrent current = SecurityCurrent.getCurrent();
                if (current != null) {
                    SecurityContext sctx = current.getSecurityContext();
                    if (sctx == null) {
                        if (TraceEjb.isDebugSecurity()) {
                            TraceEjb.security.log(BasicLevel.DEBUG, (Object)("runas : Security context is null, create a new one in ejb " + this.ejbname));
                        }
                        sctx = new SecurityContext();
                        current.setSecurityContext(sctx);
                    }
                    String principalName = this.dd.getRunAsPrincipalName();
                    String[] runAsRoles = this.dd.getDeploymentDesc().getRolesForRunAsPrincipal(principalName);
                    if (runAsRoles == null) {
                        runAsRoles = new String[]{runAsRoleDD};
                    }
                    if (TraceEjb.isDebugSecurity()) {
                        TraceEjb.security.log(BasicLevel.DEBUG, (Object)"runAs roles are ");
                        for (int r = 0; r < runAsRoles.length; ++r) {
                            TraceEjb.security.log(BasicLevel.DEBUG, (Object)("Role[" + r + "] = " + runAsRoles[r]));
                        }
                        TraceEjb.security.log(BasicLevel.DEBUG, (Object)("RunAs principal name = " + principalName));
                    }
                    sctx.pushRunAs(runAsRoleDD, principalName, runAsRoles);
                } else {
                    TraceEjb.security.log(BasicLevel.ERROR, (Object)("Can't push runas role as security current is null in ejb " + this.ejbname));
                }
            }
        }
        catch (RuntimeException re) {
            if (runAsRoleDD != null) {
                SecurityCurrent current = SecurityCurrent.getCurrent();
                if (current != null) {
                    SecurityContext sctx = current.getSecurityContext();
                    if (sctx == null) {
                        if (TraceEjb.isDebugSecurity()) {
                            TraceEjb.security.log(BasicLevel.DEBUG, (Object)("runas : Security context is  null  in ejb " + this.ejbname));
                        }
                    } else {
                        sctx.popRunAs();
                    }
                } else if (TraceEjb.isDebugSecurity()) {
                    TraceEjb.security.log(BasicLevel.DEBUG, (Object)("Can't pop runas role as security current is null in ejb " + this.ejbname));
                }
            }
            if (TraceEjb.isDebugSecurity()) {
                TraceEjb.logger.log(BasicLevel.DEBUG, (Object)"Security Runtime Exception", (Throwable)re);
            }
            throw re;
        }
    }

    public RequestCtx preInvoke(int txa) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        RequestCtx rctx = null;
        try {
            rctx = new RequestCtx(txa);
            rctx.cloader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.myClassLoader());
            this.resourceCheckerManager.push();
            rctx.jndiCtx = this.setComponentContext();
            this.checkTransaction(rctx);
        }
        catch (RuntimeException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"unexpected Runtime Exception", (Throwable)e);
            throw e;
        }
        return rctx;
    }

    public void postInvoke(RequestCtx rctx) {
        block45: {
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
            }
            try {
                String runAsRoleDD = this.dd.getRunAsRole();
                if (runAsRoleDD != null) {
                    SecurityCurrent current = SecurityCurrent.getCurrent();
                    if (current != null) {
                        SecurityContext sctx = current.getSecurityContext();
                        if (sctx == null) {
                            TraceEjb.security.log(BasicLevel.ERROR, (Object)("runas: Security context is null  in ejb " + this.ejbname));
                        } else {
                            sctx.popRunAs();
                        }
                    } else {
                        TraceEjb.security.log(BasicLevel.ERROR, (Object)("Can't pop runas role as security current is null in ejb " + this.ejbname));
                    }
                }
                if (rctx.mustCommit) {
                    try {
                        Transaction t = this.tm.getTransaction();
                        if (t == null) {
                            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("Transaction disappeared: " + rctx.currTx));
                            Thread.dumpStack();
                            throw new EJBException("null transaction");
                        }
                        if (rctx.currTx != t) {
                            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("Transaction changed: " + rctx.currTx));
                            Thread.dumpStack();
                            throw new EJBException("bad transaction :" + t);
                        }
                    }
                    catch (Exception e) {
                        throw new EJBException("Cannot get current transaction:", e);
                    }
                    if (rctx.sysExc != null) {
                        TraceEjb.logger.log(BasicLevel.ERROR, (Object)"system exception raised by request:", rctx.sysExc);
                        try {
                            this.tm.rollback();
                        }
                        catch (Exception e) {
                            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"exception during rollback:", (Throwable)e);
                        }
                    } else {
                        HaService haService = this.cont.getHaService();
                        try {
                            switch (this.tm.getStatus()) {
                                case 0: {
                                    if (this.isClusterReplicated && haService != null && haService.isStarted()) {
                                        haService.replicate();
                                    }
                                    if (TraceEjb.isDebugTx()) {
                                        TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("committing transaction: " + rctx.currTx));
                                    }
                                    this.tm.commit();
                                    if (this.isClusterReplicated && haService != null && haService.isStarted()) {
                                        haService.replicateCommit(true);
                                    }
                                    break;
                                }
                                case 1: {
                                    if (TraceEjb.isDebugTx()) {
                                        TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("rolling back transaction: " + rctx.currTx));
                                    }
                                    this.tm.rollback();
                                    if (this.isClusterReplicated && haService != null && haService.isStarted()) {
                                        haService.replicateCommit(false);
                                    }
                                    break;
                                }
                                default: {
                                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)("unexpected transaction status " + this.tm.getStatus()));
                                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)("transaction: " + rctx.currTx));
                                    Thread.dumpStack();
                                    if (this.isClusterReplicated && haService != null && haService.isStarted()) {
                                        haService.replicateCommit(false);
                                    }
                                    throw new EJBException("unexpected transaction status :" + this.tm.getStatus());
                                }
                            }
                        }
                        catch (RollbackException e) {
                            TraceEjb.logger.log(BasicLevel.WARN, (Object)"Could not commit transaction (rolled back)");
                            if (this.isClusterReplicated && haService != null && haService.isStarted()) {
                                haService.replicateCommit(false);
                            }
                            throw new TransactionRolledbackLocalException("Could not commit transaction", (Exception)((Object)e));
                        }
                        catch (Exception e) {
                            TraceEjb.logger.log(BasicLevel.WARN, (Object)("Could not commit transaction:" + e));
                            if (this.isClusterReplicated && haService != null && haService.isStarted()) {
                                haService.replicateCommit(false);
                            }
                            throw new EJBException("Container exception", e);
                        }
                    }
                }
                if (!(this instanceof JStatefulFactory)) {
                    this.resourceCheckerManager.detect((IResourceCheckerInfo)new EJBResourceCheckerInfo(this, ResourceCheckpoints.EJB_POST_INVOKE));
                }
                this.resourceCheckerManager.pop();
                Thread.currentThread().setContextClassLoader(rctx.cloader);
                Transaction tx = rctx.clientTx;
                if (tx != null) {
                    try {
                        if (TraceEjb.isDebugTx()) {
                            TraceEjb.tx.log(BasicLevel.DEBUG, (Object)"resuming transaction");
                        }
                        this.tm.resume(tx);
                    }
                    catch (Exception e) {
                        TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot resume transaction", (Throwable)e);
                    }
                }
                this.resetComponentContext(rctx.jndiCtx);
                if (rctx.sysExc == null) break block45;
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"system exception in business method:", rctx.sysExc);
                if (rctx.sysExc instanceof TransactionRolledbackLocalException) {
                    TraceEjb.logger.log(BasicLevel.DEBUG, (Object)"The transaction is already rolled back");
                    throw new TransactionRolledbackLocalException(rctx.sysExc.getMessage());
                }
                Transaction currentTx = null;
                try {
                    currentTx = this.tm.getTransaction();
                    if (currentTx != null && rctx.clientTx == null) {
                        TraceEjb.logger.log(BasicLevel.WARN, (Object)"Client transaction will rollback");
                        currentTx.setRollbackOnly();
                        if (rctx.bmcalled) {
                            throw new TransactionRolledbackLocalException(rctx.sysExc.getMessage());
                        }
                    }
                }
                catch (SystemException e) {
                    TraceEjb.logger.log(BasicLevel.DEBUG, (Object)"cannot set rollback only current tx:", (Throwable)e);
                }
                return;
            }
            catch (TransactionRolledbackLocalException e) {
                throw e;
            }
            catch (EJBException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"ejbexception: ", (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"unexpected runtime exception: ", (Throwable)e);
                throw e;
            }
        }
    }

    public RequestCtx preInvokeRemote(int txa) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            return this.preInvoke(txa);
        }
        catch (TransactionRequiredLocalException e) {
            TransactionRequiredException tr = new TransactionRequiredException(e.getMessage());
            tr.detail = e;
            throw tr;
        }
        catch (TransactionRolledbackLocalException e) {
            TransactionRolledbackException tr = new TransactionRolledbackException(e.getMessage());
            tr.detail = e;
            throw tr;
        }
        catch (NoSuchObjectLocalException e) {
            throw NoSuchObjectExceptionHelper.create((Throwable)e);
        }
        catch (EJBException e) {
            RemoteException re = new RemoteException(e.getMessage());
            re.detail = e;
            throw re;
        }
    }

    public void postInvokeRemote(RequestCtx rctx) throws RemoteException {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.postInvoke(rctx);
        }
        catch (TransactionRequiredLocalException e) {
            throw new TransactionRequiredException(e.getMessage());
        }
        catch (TransactionRolledbackLocalException e) {
            throw new TransactionRolledbackException(e.getMessage());
        }
        catch (NoSuchObjectLocalException e) {
            throw new NoSuchObjectException(e.getMessage());
        }
        catch (EJBException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    abstract void checkTransaction(RequestCtx var1);

    private void checkTransactionInteroperability(int txa) {
        if (this.tm.nonJotmTransactionContext()) {
            switch (txa) {
                case 5: {
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)"mandatory and tx from another vendor");
                    throw new EJBException("Doesn't support transaction interoperability");
                }
                case 2: {
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)"required and tx from another vendor");
                    throw new EJBException("Doesn't support transaction interoperability");
                }
                case 3: {
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)"supports and tx from another vendor");
                    throw new EJBException("Doesn't support transaction interoperability");
                }
            }
        }
    }

    protected void checkTransactionContainer(RequestCtx rctx) {
        int txa = rctx.txAttr;
        if (txa == 0) {
            return;
        }
        rctx.mustCommit = false;
        Transaction cltx = null;
        Transaction currtx = null;
        try {
            currtx = this.tm.getTransaction();
        }
        catch (SystemException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"system exception while getting transaction:", (Throwable)e);
        }
        if (this.iiopProtocolAvailable) {
            this.checkTransactionInteroperability(txa);
        }
        if (txa == 6 && currtx != null) {
            TraceEjb.logger.log(BasicLevel.WARN, (Object)"never and transaction not null");
            throw new EJBException("Never attribute = caller must not be in a transaction");
        }
        if (txa == 5 && currtx == null) {
            TraceEjb.logger.log(BasicLevel.WARN, (Object)"mandatory and not in transaction");
            throw new TransactionRequiredLocalException("Mandatory attribute = caller must be in a transaction");
        }
        if (currtx != null && (txa == 4 || txa == 1)) {
            try {
                cltx = this.tm.suspend();
                if (cltx != null && TraceEjb.isDebugTx()) {
                    TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("Suspending client tx:" + cltx));
                }
                currtx = null;
            }
            catch (SystemException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot suspend transaction:\n", (Throwable)e);
                throw new EJBException("Cannot suspend transaction", (Exception)((Object)e));
            }
        }
        if (txa == 4 || txa == 2 && currtx == null) {
            try {
                this.tm.begin();
                rctx.mustCommit = true;
                currtx = this.tm.getTransaction();
                if (TraceEjb.isDebugTx()) {
                    TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("Start tx: " + currtx));
                }
            }
            catch (NotSupportedException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot start a transaction: NotSupportedException");
                throw new EJBException("Nested Transactions Not Supported", (Exception)((Object)e));
            }
            catch (SystemException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot start a transaction:\n", (Throwable)e);
                throw new EJBException("Cannot start a transaction: SystemException", (Exception)((Object)e));
            }
        }
        rctx.currTx = currtx;
        rctx.clientTx = cltx;
    }

    protected void checkJonasVersion(String clName) {
        String fdName = "JONAS_VERSION";
        String gVersion = null;
        try {
            String resourceName = clName.replace('.', '/') + ".class";
            Enumeration<URL> e = null;
            try {
                e = this.cont.getClassLoader().getResources(resourceName);
            }
            catch (IOException ioe) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)("failed to find class " + clName + ioe));
                throw new EJBException("Container failed to find class " + clName, (Exception)ioe);
            }
            int nbCls = 0;
            String urls = "";
            while (e.hasMoreElements()) {
                ++nbCls;
                urls = urls + e.nextElement() + "\n";
            }
            if (nbCls > 1) {
                TraceEjb.logger.log(BasicLevel.WARN, (Object)("there are " + nbCls + " resources for the class " + clName + ". Some problems can occur because it's the first resource which will be loaded. The list of resources is : \n" + urls));
            }
            Class<?> cl = this.cont.getClassLoader().loadClass(clName);
            Field fd = cl.getDeclaredField("JONAS_VERSION");
            gVersion = (String)fd.get(null);
        }
        catch (ClassNotFoundException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("failed to find class " + clName), (Throwable)e);
            return;
        }
        catch (NoSuchFieldException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("failed to find field " + fdName + " of class " + clName), (Throwable)e);
            return;
        }
        catch (IllegalAccessException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)("failed to get the value of the field " + fdName + " of class " + clName), (Throwable)e);
            return;
        }
        if (!Version.getNumber().equals(gVersion)) {
            TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ejbname + "(Ver. " + gVersion + ") bean not deployed with the same JOnAS version(" + Version.getNumber() + "). You have to redeploy " + this.cont.getFileName() + "."));
        }
    }

    public ClassLoader myClassLoader() {
        return this.cont.getClassLoader();
    }

    public String[] getFileList(File dir, String prefix, String suffix) {
        return dir.list((FilenameFilter)new DirFilter(prefix, suffix));
    }

    public IEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(IEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public IResourceCheckerManager getResourceCheckerManager() {
        return this.resourceCheckerManager;
    }

    public void setResourceCheckerManager(IResourceCheckerManager resourceCheckerManager) {
        this.resourceCheckerManager = resourceCheckerManager;
    }
}

