/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.jaxws.description.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescriptionWSDL;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.jonas.ws.axis2.jaxws.description.impl.DescriptionUtils;
import org.ow2.jonas.ws.axis2.jaxws.description.impl.EndpointDescriptionImpl;
import org.ow2.jonas.ws.axis2.jaxws.description.impl.OperationDescriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EndpointInterfaceDescriptionImpl
implements EndpointInterfaceDescription,
EndpointInterfaceDescriptionJava,
EndpointInterfaceDescriptionWSDL {
    private EndpointDescriptionImpl parentEndpointDescription;
    private ArrayList<OperationDescription> operationDescriptions = new ArrayList();
    private Class seiClass;
    private DescriptionBuilderComposite dbc;
    private static final Log log = LogFactory.getLog(EndpointInterfaceDescriptionImpl.class);
    private WebService webServiceAnnotation;
    private String webServiceTargetNamespace;
    private String webService_Name;
    private SOAPBinding soapBindingAnnotation;
    private SOAPBinding.Style soapBindingStyle;
    public static final SOAPBinding.Style SOAPBinding_Style_DEFAULT = SOAPBinding.Style.DOCUMENT;
    private SOAPBinding.Use soapBindingUse;
    public static final SOAPBinding.Use SOAPBinding_Use_DEFAULT = SOAPBinding.Use.LITERAL;
    private SOAPBinding.ParameterStyle soapParameterStyle;
    public static final SOAPBinding.ParameterStyle SOAPBinding_ParameterStyle_DEFAULT = SOAPBinding.ParameterStyle.WRAPPED;

    void addOperation(OperationDescription operation) {
        this.operationDescriptions.add(operation);
    }

    EndpointInterfaceDescriptionImpl(Class sei, EndpointDescriptionImpl parent) {
        this.seiClass = sei;
        this.parentEndpointDescription = parent;
        for (Method method : EndpointInterfaceDescriptionImpl.getSEIMethods(this.seiClass)) {
            OperationDescriptionImpl operation = new OperationDescriptionImpl(method, (EndpointInterfaceDescription)this);
            this.addOperation(operation);
        }
    }

    EndpointInterfaceDescriptionImpl(EndpointDescriptionImpl parent) {
        this.parentEndpointDescription = parent;
        AxisService axisService = this.parentEndpointDescription.getAxisService();
        if (axisService != null) {
            ArrayList publishedOperations = axisService.getPublishedOperations();
            for (AxisOperation axisOperation : publishedOperations) {
                this.addOperation(new OperationDescriptionImpl(axisOperation, (EndpointInterfaceDescription)this));
            }
        }
    }

    EndpointInterfaceDescriptionImpl(DescriptionBuilderComposite dbc, EndpointDescriptionImpl parent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating a EndpointInterfaceDescription for a generic WSDL-less provider");
        }
        this.parentEndpointDescription = parent;
        this.dbc = dbc;
        AxisOperation genericProviderAxisOp = null;
        try {
            genericProviderAxisOp = AxisOperationFactory.getOperationDescription((String)"http://www.w3.org/2006/01/wsdl/in-out");
        }
        catch (AxisFault e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to build AxisOperation for generic Provider; caught exception.", (Throwable)e);
            }
            throw ExceptionFactory.makeWebServiceException((String)"Caught exception trying to create AxisOperation", (Throwable)e);
        }
        genericProviderAxisOp.setName(new QName("jaxwsNoWSDLProviderOperation"));
        OperationDescriptionImpl opDesc = new OperationDescriptionImpl(genericProviderAxisOp, (EndpointInterfaceDescription)this);
        this.addOperation(opDesc);
        AxisService axisService = this.getEndpointDescription().getAxisService();
        axisService.addOperation(genericProviderAxisOp);
    }

    EndpointInterfaceDescriptionImpl(DescriptionBuilderComposite dbc, boolean isClass, EndpointDescriptionImpl parent) {
        this.parentEndpointDescription = parent;
        this.dbc = dbc;
        this.getEndpointDescription().getAxisService().setTargetNamespace(this.getEndpointDescriptionImpl().getTargetNamespace());
        Iterator<MethodDescriptionComposite> iter = this.retrieveReleventMethods(dbc);
        if (log.isDebugEnabled()) {
            log.debug((Object)"EndpointInterfaceDescriptionImpl: Finished retrieving methods");
        }
        MethodDescriptionComposite mdc = null;
        while (iter.hasNext()) {
            mdc = iter.next();
            mdc.setDeclaringClass(dbc.getClassName());
            if (!DescriptionUtils.createOperationDescription(mdc.getMethodName())) continue;
            AxisService axisService = this.getEndpointDescription().getAxisService();
            AxisOperation axisOperation = axisService.getOperation(OperationDescriptionImpl.determineOperationQName(mdc));
            OperationDescriptionImpl operation = new OperationDescriptionImpl(mdc, this, axisOperation);
            if (axisOperation == null) {
                operation.addToAxisService(axisService);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("EID: Just added operation= " + operation.getOperationName()));
            }
            this.addOperation(operation);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"EndpointInterfaceDescriptionImpl: Finished Adding operations");
        }
    }

    private static Method[] getSEIMethods(Class sei) {
        Method[] seiMethods = sei.getMethods();
        ArrayList<Method> methodList = new ArrayList<Method>();
        if (sei != null) {
            for (Method method : seiMethods) {
                if (method.getDeclaringClass().getName().equals("java.lang.Object")) continue;
                methodList.add(method);
                if (Modifier.isPublic(method.getModifiers())) continue;
                ExceptionFactory.makeWebServiceException((String)"SEI methods must be public");
            }
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    void updateWithSEI(Class sei) {
        if (this.seiClass != null && this.seiClass != sei) {
            throw new UnsupportedOperationException("The seiClass is already set; reseting it is not supported");
        }
        if (this.seiClass != null && this.seiClass == sei) {
            return;
        }
        if (sei != null) {
            this.seiClass = sei;
            for (Method seiMethod : EndpointInterfaceDescriptionImpl.getSEIMethods(this.seiClass)) {
                if (this.getOperation(seiMethod) != null) continue;
                QName seiOperationQName = OperationDescriptionImpl.determineOperationQName(seiMethod);
                OperationDescription[] updateOpDesc = this.getOperation(seiOperationQName);
                if (updateOpDesc == null || updateOpDesc.length == 0) {
                    OperationDescriptionImpl operation = new OperationDescriptionImpl(seiMethod, (EndpointInterfaceDescription)this);
                    this.addOperation(operation);
                    continue;
                }
                boolean addOpDesc = true;
                for (OperationDescription checkOpDesc : updateOpDesc) {
                    if (checkOpDesc.getSEIMethod() != null || DescriptionUtils.isAsync(seiMethod)) continue;
                    ((OperationDescriptionImpl)checkOpDesc).setSEIMethod(seiMethod);
                    addOpDesc = false;
                    break;
                }
                if (!addOpDesc) continue;
                OperationDescriptionImpl operation = new OperationDescriptionImpl(seiMethod, (EndpointInterfaceDescription)this);
                this.addOperation(operation);
            }
        }
    }

    public OperationDescription[] getOperationForJavaMethod(String javaMethodName) {
        if (DescriptionUtils.isEmpty(javaMethodName)) {
            return null;
        }
        ArrayList<OperationDescription> matchingOperations = new ArrayList<OperationDescription>();
        for (OperationDescription operation : this.getOperations()) {
            if (!javaMethodName.equals(operation.getJavaMethodName())) continue;
            matchingOperations.add(operation);
        }
        if (matchingOperations.size() == 0) {
            return null;
        }
        return matchingOperations.toArray(new OperationDescription[0]);
    }

    public OperationDescription getOperation(String operationName) {
        if (DescriptionUtils.isEmpty(operationName)) {
            return null;
        }
        OperationDescription matchingOperation = null;
        for (OperationDescription operation : this.getOperations()) {
            if (!operationName.equals(operation.getOperationName())) continue;
            matchingOperation = operation;
            break;
        }
        return matchingOperation;
    }

    public OperationDescription[] getOperations() {
        return this.operationDescriptions.toArray(new OperationDescription[0]);
    }

    EndpointDescriptionImpl getEndpointDescriptionImpl() {
        return this.parentEndpointDescription;
    }

    public EndpointDescription getEndpointDescription() {
        return this.parentEndpointDescription;
    }

    public OperationDescription[] getOperation(QName operationQName) {
        OperationDescription[] returnOperations = null;
        if (!DescriptionUtils.isEmpty(operationQName)) {
            OperationDescription[] allOperations;
            ArrayList<OperationDescription> matchingOperations = new ArrayList<OperationDescription>();
            for (OperationDescription operation : allOperations = this.getOperations()) {
                if (!operation.getName().getLocalPart().equals(operationQName.getLocalPart())) continue;
                matchingOperations.add(operation);
            }
            if (matchingOperations.size() > 0) {
                returnOperations = matchingOperations.toArray(new OperationDescription[0]);
            }
        }
        return returnOperations;
    }

    public OperationDescription[] getDispatchableOperation(QName operationQName) {
        OperationDescription[] returnOperations = null;
        OperationDescription[] allMatchingOperations = this.getOperation(operationQName);
        if (allMatchingOperations != null && allMatchingOperations.length > 0) {
            ArrayList<OperationDescription> dispatchableOperations = new ArrayList<OperationDescription>();
            for (OperationDescription operation : allMatchingOperations) {
                if (operation.isJAXWSAsyncClientMethod()) continue;
                dispatchableOperations.add(operation);
            }
            if (dispatchableOperations.size() > 0) {
                returnOperations = dispatchableOperations.toArray(new OperationDescription[0]);
            }
        }
        return returnOperations;
    }

    public OperationDescription[] getDispatchableOperations() {
        OperationDescription[] returnOperations = null;
        OperationDescription[] allMatchingOperations = this.getOperations();
        if (allMatchingOperations != null && allMatchingOperations.length > 0) {
            ArrayList<OperationDescription> dispatchableOperations = new ArrayList<OperationDescription>();
            for (OperationDescription operation : allMatchingOperations) {
                if (operation.isJAXWSAsyncClientMethod()) continue;
                dispatchableOperations.add(operation);
            }
            if (dispatchableOperations.size() > 0) {
                returnOperations = dispatchableOperations.toArray(new OperationDescription[0]);
            }
        }
        return returnOperations;
    }

    public OperationDescription getOperation(Method seiMethod) {
        OperationDescription returnOperation = null;
        if (seiMethod != null) {
            OperationDescription[] allOperations;
            for (OperationDescription operation : allOperations = this.getOperations()) {
                if (operation.getSEIMethod() == null || !operation.getSEIMethod().equals(seiMethod)) continue;
                returnOperation = operation;
            }
        }
        return returnOperation;
    }

    public Class getSEIClass() {
        return this.seiClass;
    }

    public SOAPBinding getAnnoSoapBinding() {
        if (this.soapBindingAnnotation == null) {
            if (this.dbc != null) {
                this.soapBindingAnnotation = this.dbc.getSoapBindingAnnot();
            } else if (this.seiClass != null) {
                this.soapBindingAnnotation = this.seiClass.getAnnotation(SOAPBinding.class);
            }
        }
        return this.soapBindingAnnotation;
    }

    public SOAPBinding.Style getSoapBindingStyle() {
        return this.getAnnoSoapBindingStyle();
    }

    public SOAPBinding.Style getAnnoSoapBindingStyle() {
        if (this.soapBindingStyle == null) {
            this.soapBindingStyle = this.getAnnoSoapBinding() != null && this.getAnnoSoapBinding().style() != null ? this.getAnnoSoapBinding().style() : SOAPBinding_Style_DEFAULT;
        }
        return this.soapBindingStyle;
    }

    public SOAPBinding.Use getSoapBindingUse() {
        return this.getAnnoSoapBindingUse();
    }

    public SOAPBinding.Use getAnnoSoapBindingUse() {
        if (this.soapBindingUse == null) {
            this.soapBindingUse = this.getAnnoSoapBinding() != null && this.getAnnoSoapBinding().use() != null ? this.getAnnoSoapBinding().use() : SOAPBinding_Use_DEFAULT;
        }
        return this.soapBindingUse;
    }

    public SOAPBinding.ParameterStyle getSoapBindingParameterStyle() {
        return this.getAnnoSoapBindingParameterStyle();
    }

    public SOAPBinding.ParameterStyle getAnnoSoapBindingParameterStyle() {
        if (this.soapParameterStyle == null) {
            this.soapParameterStyle = this.getAnnoSoapBinding() != null && this.getAnnoSoapBinding().parameterStyle() != null ? this.getAnnoSoapBinding().parameterStyle() : SOAPBinding_ParameterStyle_DEFAULT;
        }
        return this.soapParameterStyle;
    }

    Iterator<MethodDescriptionComposite> retrieveReleventMethods(DescriptionBuilderComposite dbc) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"retrieveReleventMethods: Enter");
        }
        ArrayList<Object> retrieveList = new ArrayList<MethodDescriptionComposite>();
        if (dbc.isInterface()) {
            retrieveList.addAll(this.retrieveSEIMethodsChain(dbc));
        } else {
            retrieveList = this.retrieveImplicitSEIMethods(dbc);
            DescriptionBuilderComposite tempDBC = dbc;
            while (!DescriptionUtils.isEmpty(tempDBC.getSuperClassName()) && !DescriptionUtils.javifyClassName(tempDBC.getSuperClassName()).equals("java.lang.Object")) {
                DescriptionBuilderComposite superDBC = this.getEndpointDescriptionImpl().getServiceDescriptionImpl().getDBCMap().get(tempDBC.getSuperClassName());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("superclass name for this DBC is:" + tempDBC.getSuperClassName()));
                }
                if (superDBC == null) {
                    throw ExceptionFactory.makeWebServiceException((String)"EndpointInterfaceDescriptionImpl: cannot find super class that was specified for this class");
                }
                if (superDBC.getWebServiceAnnot() != null) {
                    retrieveList.addAll(this.retrieveImplicitSEIMethods(superDBC));
                } else {
                    for (MethodDescriptionComposite mdc : dbc.getMethodDescriptionsList()) {
                        if (DescriptionUtils.isExcludeTrue(mdc)) continue;
                        mdc.setDeclaringClass(superDBC.getClassName());
                        retrieveList.add(mdc);
                    }
                }
                tempDBC = superDBC;
            }
            retrieveList = this.removeOverriddenMethods(retrieveList, dbc);
        }
        return retrieveList.iterator();
    }

    private HashMap<String, Integer> getClassHierarchy(DescriptionBuilderComposite dbc) {
        HashMap<String, DescriptionBuilderComposite> dbcMap = this.getEndpointDescriptionImpl().getServiceDescriptionImpl().getDBCMap();
        HashMap<String, Integer> hierarchyMap = new HashMap<String, Integer>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Putting class at base level: " + dbc.getClassName()));
        }
        hierarchyMap.put(dbc.getClassName(), 0);
        DescriptionBuilderComposite superDBC = dbcMap.get(dbc.getSuperClassName());
        int i = 1;
        while (superDBC != null && !superDBC.getClassName().equals("java.lang.Object")) {
            hierarchyMap.put(superDBC.getClassName(), i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Putting class: " + superDBC.getClassName() + " at hierarchy rank: " + i));
            }
            ++i;
            superDBC = dbcMap.get(superDBC.getSuperClassName());
        }
        return hierarchyMap;
    }

    private ArrayList<MethodDescriptionComposite> removeOverriddenMethods(ArrayList<MethodDescriptionComposite> methodList, DescriptionBuilderComposite dbc) {
        HashMap<String, Integer> hierarchyMap = this.getClassHierarchy(dbc);
        ArrayList<MethodDescriptionComposite> returnMethods = new ArrayList<MethodDescriptionComposite>();
        for (int i = 0; i < methodList.size(); ++i) {
            if (!this.notFound(returnMethods, methodList.get(i))) continue;
            returnMethods.add(EndpointInterfaceDescriptionImpl.getBaseMethod(methodList.get(i), i, methodList, hierarchyMap));
        }
        return returnMethods;
    }

    private boolean notFound(ArrayList<MethodDescriptionComposite> mdcList, MethodDescriptionComposite mdc) {
        for (MethodDescriptionComposite method : mdcList) {
            if (!mdc.compare((Object)method)) continue;
            return false;
        }
        return true;
    }

    private static MethodDescriptionComposite getBaseMethod(MethodDescriptionComposite mdc, int index, ArrayList<MethodDescriptionComposite> methodList, HashMap<String, Integer> hierarchyMap) {
        int baseLevel = hierarchyMap.get(mdc.getDeclaringClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Base method: " + mdc.getMethodName() + " initial level: " + baseLevel));
        }
        while (index < methodList.size()) {
            MethodDescriptionComposite compareMDC = methodList.get(index);
            if (mdc.equals(compareMDC)) {
                int compareLevel;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found equivalent methods: " + mdc.getMethodName()));
                }
                if ((compareLevel = hierarchyMap.get(compareMDC.getDeclaringClass()).intValue()) < baseLevel) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found method lower in hierarchy chain: " + compareMDC.getMethodName() + " of class: " + compareMDC.getMethodName()));
                    }
                    mdc = compareMDC;
                    baseLevel = compareLevel;
                }
            }
            ++index;
        }
        return mdc;
    }

    private ArrayList<MethodDescriptionComposite> retrieveImplicitSEIMethods(DescriptionBuilderComposite dbc) {
        ArrayList<Object> retrieveList = new ArrayList();
        retrieveList = DescriptionUtils.getMethodsWithFalseExclusions(dbc);
        if (retrieveList == null || retrieveList.size() == 0) {
            Iterator iter = null;
            List mdcList = dbc.getMethodDescriptionsList();
            if (mdcList != null) {
                for (MethodDescriptionComposite mdc : dbc.getMethodDescriptionsList()) {
                    if (DescriptionUtils.isExcludeTrue(mdc)) continue;
                    mdc.setDeclaringClass(dbc.getClassName());
                    retrieveList.add(mdc);
                }
            }
        }
        return retrieveList;
    }

    private ArrayList<MethodDescriptionComposite> retrieveSEIMethods(DescriptionBuilderComposite dbc) {
        ArrayList<MethodDescriptionComposite> retrieveList = new ArrayList<MethodDescriptionComposite>();
        Iterator iter = null;
        List mdcList = dbc.getMethodDescriptionsList();
        if (mdcList != null) {
            for (MethodDescriptionComposite mdc : dbc.getMethodDescriptionsList()) {
                mdc.setDeclaringClass(dbc.getClassName());
                retrieveList.add(mdc);
            }
        }
        return retrieveList;
    }

    private ArrayList<MethodDescriptionComposite> retrieveSEIMethodsChain(DescriptionBuilderComposite tmpDBC) {
        DescriptionBuilderComposite dbc = tmpDBC;
        ArrayList<MethodDescriptionComposite> retrieveList = new ArrayList();
        retrieveList = this.retrieveSEIMethods(dbc);
        Iterator iter = null;
        List interfacesList = dbc.getInterfacesList();
        if (interfacesList != null) {
            for (String interfaceName : dbc.getInterfacesList()) {
                DescriptionBuilderComposite superInterface = this.getEndpointDescriptionImpl().getServiceDescriptionImpl().getDBCMap().get(interfaceName);
                retrieveList.addAll(this.retrieveSEIMethodsChain(superInterface));
            }
        }
        return retrieveList;
    }

    private Definition getWSDLDefinition() {
        return ((ServiceDescriptionWSDL)this.getEndpointDescription().getServiceDescription()).getWSDLDefinition();
    }

    public PortType getWSDLPortType() {
        PortType portType = null;
        Definition wsdlDefn = this.getWSDLDefinition();
        if (wsdlDefn != null) {
            String tns = this.getEndpointDescription().getTargetNamespace();
            String localPart = this.getEndpointDescription().getName();
            if (localPart != null) {
                portType = wsdlDefn.getPortType(new QName(tns, localPart));
            }
        }
        return portType;
    }

    public String getTargetNamespace() {
        return this.getAnnoWebServiceTargetNamespace();
    }

    public WebService getAnnoWebService() {
        if (this.webServiceAnnotation == null) {
            if (this.dbc != null) {
                this.webServiceAnnotation = this.dbc.getWebServiceAnnot();
            } else if (this.seiClass != null) {
                this.webServiceAnnotation = this.seiClass.getAnnotation(WebService.class);
            }
        }
        return this.webServiceAnnotation;
    }

    public String getAnnoWebServiceTargetNamespace() {
        if (this.webServiceTargetNamespace == null) {
            this.webServiceTargetNamespace = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().targetNamespace()) ? this.getAnnoWebService().targetNamespace() : (this.dbc != null ? DescriptionUtils.makeNamespaceFromPackageName(DescriptionUtils.getJavaPackageName(this.dbc.getClassName()), "http") : DescriptionUtils.makeNamespaceFromPackageName(DescriptionUtils.getJavaPackageName(this.seiClass), "http"));
        }
        return this.webServiceTargetNamespace;
    }

    public String getAnnoWebServiceName() {
        if (this.webService_Name == null) {
            this.webService_Name = this.getAnnoWebService() != null && !DescriptionUtils.isEmpty(this.getAnnoWebService().name()) ? this.getAnnoWebService().name() : "";
        }
        return this.webService_Name;
    }

    public String getName() {
        return this.getAnnoWebServiceName();
    }

    public QName getPortType() {
        String name = this.getName();
        String tns = this.getTargetNamespace();
        return new QName(tns, name);
    }

    public String toString() {
        String newline = "\n";
        String sameline = "; ";
        StringBuffer string = new StringBuffer();
        try {
            string.append(super.toString());
            string.append("\n");
            string.append("Name: " + this.getName());
            string.append("; ");
            string.append("PortType: " + this.getPortType());
            string.append("\n");
            string.append("SOAP Style: " + this.getSoapBindingStyle());
            string.append("; ");
            string.append("SOAP Use: " + this.getSoapBindingUse());
            string.append("; ");
            string.append("SOAP Paramater Style: " + this.getSoapBindingParameterStyle());
            string.append("\n");
            OperationDescription[] operations = this.getOperations();
            if (operations != null && operations.length > 0) {
                string.append("Number of operations: " + operations.length);
                for (OperationDescription operation : operations) {
                    string.append("\n");
                    string.append("Operation: " + operation.toString());
                }
            } else {
                string.append("OperationDescription array is null");
            }
        }
        catch (Throwable t) {
            string.append("\n");
            string.append("Complete debug information not currently available for EndpointInterfaceDescription");
            return string.toString();
        }
        return string.toString();
    }
}

