/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.conf;

import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNat;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.A3CMLService;
import fr.dyade.aaa.agent.conf.A3CMLWrapper;
import java.io.Reader;
import java.util.Vector;
import org.kxml.Attribute;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.XmlParser;

public class A3CMLKXmlWrapper
implements A3CMLWrapper {
    protected A3CMLConfig a3cmlconfig = null;
    String configName = "default";
    String conf = null;
    A3CMLDomain domain = null;
    A3CMLServer server = null;
    A3CMLNetwork network = null;
    A3CMLService service = null;
    A3CMLProperty property = null;
    String jvmArgs = null;
    A3CMLNat nat = null;

    public static final String getValue(Vector atts, String qName) {
        if (atts != null) {
            for (int i = 0; i < atts.size(); ++i) {
                if (!((Attribute)atts.elementAt(i)).getName().equals(qName)) continue;
                return ((Attribute)atts.elementAt(i)).getValue();
            }
        }
        return null;
    }

    public A3CMLConfig parse(Reader reader, String configName) throws Exception {
        this.configName = configName;
        this.a3cmlconfig = new A3CMLConfig();
        XmlParser parser2 = new XmlParser(reader);
        ParseEvent event = parser2.read();
        while (event.getType() != 8) {
            switch (event.getType()) {
                case 0: {
                    break;
                }
                case 64: {
                    String name = event.getName();
                    if (name.equals("config")) {
                        this.conf = A3CMLKXmlWrapper.getValue(event.getAttributes(), "name");
                        if (this.conf != null) break;
                        this.conf = configName;
                        break;
                    }
                    if (!configName.equals(this.conf)) break;
                    Vector atts = event.getAttributes();
                    if (name.equals("domain")) {
                        this.domain = new A3CMLDomain(A3CMLKXmlWrapper.getValue(atts, "name"), A3CMLKXmlWrapper.getValue(atts, "network"));
                        break;
                    }
                    if (name.equals("server")) {
                        short sid;
                        try {
                            sid = Short.parseShort(A3CMLKXmlWrapper.getValue(atts, "id"));
                        }
                        catch (NumberFormatException exc) {
                            throw new Exception("bad value for server id: " + A3CMLKXmlWrapper.getValue(atts, "id"));
                        }
                        this.server = new A3CMLServer(sid, A3CMLKXmlWrapper.getValue(atts, "name"), A3CMLKXmlWrapper.getValue(atts, "hostname"));
                        break;
                    }
                    if (name.equals("network")) {
                        int port;
                        try {
                            port = Integer.parseInt(A3CMLKXmlWrapper.getValue(atts, "port"));
                        }
                        catch (NumberFormatException exc) {
                            throw new Exception("bad value for network port: " + A3CMLKXmlWrapper.getValue(atts, "port"));
                        }
                        this.network = new A3CMLNetwork(A3CMLKXmlWrapper.getValue(atts, "domain"), port);
                        break;
                    }
                    if (name.equals("service")) {
                        this.service = new A3CMLService(A3CMLKXmlWrapper.getValue(atts, "class"), A3CMLKXmlWrapper.getValue(atts, "args"));
                        break;
                    }
                    if (name.equals("property")) {
                        this.property = new A3CMLProperty(A3CMLKXmlWrapper.getValue(atts, "name"), A3CMLKXmlWrapper.getValue(atts, "value"));
                        break;
                    }
                    if (name.equals("nat")) {
                        this.nat = new A3CMLNat(Short.parseShort(A3CMLKXmlWrapper.getValue(atts, "sid")), A3CMLKXmlWrapper.getValue(atts, "hostname"), Integer.parseInt(A3CMLKXmlWrapper.getValue(atts, "port")));
                        break;
                    }
                    if (name.equals("jvmArgs")) {
                        this.jvmArgs = A3CMLKXmlWrapper.getValue(atts, "value");
                        break;
                    }
                    throw new Exception("unknown element \"" + name + "\"");
                }
                case 16: {
                    String name = event.getName();
                    if (name.equals("config")) {
                        this.conf = null;
                        break;
                    }
                    if (!configName.equals(this.conf)) break;
                    if (name.equals("domain")) {
                        this.a3cmlconfig.addDomain(this.domain);
                        this.domain = null;
                        break;
                    }
                    if (name.equals("server")) {
                        this.a3cmlconfig.addServer(this.server);
                        this.server = null;
                        break;
                    }
                    if (name.equals("network")) {
                        if (this.server != null) {
                            this.server.addNetwork(this.network);
                            this.a3cmlconfig.getDomain(this.network.domain).addServer(this.server);
                        }
                        this.network = null;
                        break;
                    }
                    if (name.equals("service")) {
                        if (this.server != null) {
                            this.server.addService(this.service);
                        }
                        this.service = null;
                        break;
                    }
                    if (name.equals("property")) {
                        if (this.server == null) {
                            this.a3cmlconfig.addProperty(this.property);
                        } else {
                            this.server.addProperty(this.property);
                        }
                        this.property = null;
                        break;
                    }
                    if (name.equals("nat")) {
                        if (this.server != null) {
                            this.server.addNat(this.nat);
                        }
                        this.nat = null;
                        break;
                    }
                    if (name.equals("jvmArgs")) {
                        if (this.server != null && this.jvmArgs != null) {
                            this.server.jvmArgs = this.jvmArgs;
                        }
                        this.jvmArgs = null;
                        break;
                    }
                    throw new Exception("unknown element \"" + name + "\"");
                }
            }
            event = parser2.read();
        }
        return this.a3cmlconfig;
    }
}

