/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

import fr.dyade.aaa.common.EmptyQueueException;
import fr.dyade.aaa.common.StoppedQueueException;
import java.util.Vector;

public class Queue
extends Vector {
    private static final long serialVersionUID = 1L;
    private boolean stopping;
    private boolean closed;

    public Queue() {
        this.start();
    }

    public synchronized void push(Object item) {
        if (this.stopping) {
            throw new StoppedQueueException();
        }
        this.addElement(item);
        this.notify();
    }

    public synchronized Object get() throws InterruptedException {
        while (this.size() == 0 && !this.closed) {
            this.wait();
        }
        if (this.closed) {
            throw new InterruptedException();
        }
        return this.elementAt(0);
    }

    public synchronized Object pop() {
        if (this.size() == 0) {
            throw new EmptyQueueException();
        }
        Object obj = this.elementAt(0);
        this.removeElementAt(0);
        if (this.stopping && this.size() == 0) {
            this.notify();
        }
        return obj;
    }

    public synchronized Object getAndPop() throws InterruptedException {
        while (this.size() == 0 && !this.closed) {
            this.wait();
        }
        if (this.closed) {
            throw new InterruptedException();
        }
        Object obj = this.elementAt(0);
        this.removeElementAt(0);
        if (this.stopping && this.size() == 0) {
            this.notify();
        }
        return obj;
    }

    public void start() {
        this.stopping = false;
        this.closed = false;
    }

    public synchronized void stop() throws InterruptedException {
        this.stopping = true;
        if (this.size() != 0) {
            this.wait();
        }
    }

    public synchronized void close() {
        this.stopping = true;
        this.closed = true;
        this.notifyAll();
    }
}

