/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.reader;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.schemastream.ISchemaStreamFactory;
import org.ow2.util.plan.reader.IReader;
import org.ow2.util.plan.reader.ReaderException;
import org.ow2.util.plan.reader.ReaderValidationEventHandler;

public abstract class AbsReader
implements IReader {
    private static final Log logger = LogFactory.getLog(AbsReader.class);
    protected Unmarshaller unMarshaller = null;
    protected Class[] unmarshallClasses = null;
    protected Schema unmarshallerSchema = null;
    protected ISchemaStreamFactory schemaStreamFactory = null;

    public AbsReader() throws Exception {
        this.initUnmarshallClasses();
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance((String)this.getContextPathString(), (ClassLoader)AbsReader.class.getClassLoader());
        }
        catch (JAXBException e) {
            logger.error((Object)"JAXB context creation error", new Object[0]);
            throw e;
        }
        this.unMarshaller = jaxbContext.createUnmarshaller();
        this.setValidationEventHandler(new ReaderValidationEventHandler(1));
    }

    protected JAXBElement getRootElement(File file) throws IOException, JAXBException {
        return (JAXBElement)this.unMarshaller.unmarshal(file);
    }

    protected abstract void initUnmarshallClasses();

    protected abstract void buildUnmarshallerSchema() throws Exception;

    public void setValidationEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.unMarshaller.setEventHandler(handler);
    }

    public ValidationEventHandler getValidationEventHandler() throws JAXBException {
        return this.unMarshaller.getEventHandler();
    }

    private String getContextPathString() {
        if (this.unmarshallClasses.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.unmarshallClasses[0].getPackage().getName());
        for (int i = 1; i < this.unmarshallClasses.length; ++i) {
            sb.append(':');
            sb.append(this.unmarshallClasses[i].getPackage().getName());
        }
        return sb.toString();
    }

    public void setValidation(boolean validate) throws ReaderException {
        if (!validate) {
            this.unMarshaller.setSchema(null);
        } else {
            if (this.schemaStreamFactory != null) {
                try {
                    this.buildUnmarshallerSchema();
                }
                catch (Exception e) {
                    throw new ReaderException(e);
                }
            }
            if (this.unmarshallerSchema != null) {
                this.unMarshaller.setSchema(this.unmarshallerSchema);
            } else {
                throw new ReaderException("Cannot validate with a null schema object");
            }
        }
    }

    public boolean isValidating() {
        return this.unMarshaller.getSchema() == null;
    }

    public void setSchemaStreamFactory(ISchemaStreamFactory factory) {
        this.schemaStreamFactory = factory;
    }

    public ISchemaStreamFactory getSchemaStreamFactory() {
        return this.schemaStreamFactory;
    }
}

