/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.enc.java;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.ow2.carol.jndi.enc.java.JavaNameParser;
import org.ow2.carol.util.configuration.TraceCarol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompNamingContext
implements Context {
    private Hashtable<Object, Object> myEnv = null;
    private Hashtable<String, Object> bindings = new Hashtable();
    private static NameParser myParser = new JavaNameParser();
    private String compId;

    public CompNamingContext(String id, Hashtable<?, ?> env) {
        if (env != null) {
            this.myEnv = new Hashtable(env);
        }
        this.compId = id;
    }

    public CompNamingContext(String id) {
        this(id, new Hashtable());
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            if (TraceCarol.isDebugjndiEncCarol()) {
                TraceCarol.debugjndiEncCarol("empty name");
            }
            return this;
        }
        if (n.size() == 1) {
            Object ret = this.bindings.get(name);
            if (ret == null) {
                if (TraceCarol.isDebugjndiEncCarol()) {
                    TraceCarol.debugjndiEncCarol(" " + name + " not found.");
                }
                throw new NameNotFoundException(name);
            }
            if (ret instanceof LinkRef) {
                InitialContext ictx = new InitialContext();
                RefAddr ra = ((Reference)ret).get(0);
                try {
                    ret = ictx.lookup((String)ra.getContent());
                }
                catch (Exception e) {
                    NamingException ne = new NamingException(e.getMessage());
                    ne.setRootCause(e);
                    TraceCarol.error("unexpected exception " + e.getMessage(), e);
                    throw ne;
                }
            }
            if (ret instanceof Reference) {
                try {
                    Object o;
                    ret = o = NamingManager.getObjectInstance(ret, n, this, this.myEnv);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException ne = new NamingException(e.getMessage());
                    ne.setRootCause(e);
                    throw ne;
                }
                if (ret == null) {
                    TraceCarol.error("Can not build an object with the reference " + name);
                    throw new NamingException("Can not build an object with the reference '" + name + "'");
                }
            }
            return ret;
        }
        String suffix = n.getSuffix(1).toString();
        Context subctx = this.lookupCtx(n.get(0));
        return subctx.lookup(suffix);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            TraceCarol.error("CompNamingContext bind empty name ?");
            throw new InvalidNameException("CompNamingContext cannot bind empty name");
        }
        if (n.size() == 1) {
            if (this.bindings.get(name) != null) {
                TraceCarol.error("CompNamingContext: trying to overbind");
                throw new NameAlreadyBoundException("CompNamingContext: Use rebind to bind over a name");
            }
            this.bindings.put(name, obj);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            try {
                subctx = this.lookupCtx(n.get(0));
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(n.get(0));
            }
            subctx.bind(suffix, obj);
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            TraceCarol.error("CompNamingContext rebind empty name ?");
            throw new InvalidNameException("CompNamingContext cannot rebind empty name");
        }
        if (n.size() == 1) {
            this.bindings.put(name, obj);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            try {
                subctx = this.lookupCtx(n.get(0));
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(n.get(0));
            }
            subctx.rebind(suffix, obj);
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            TraceCarol.error("CompNamingContext unbind empty name ?");
            throw new InvalidNameException("CompNamingContext cannot unbind empty name");
        }
        if (n.size() == 1) {
            if (this.bindings.get(name) == null) {
                TraceCarol.error("CompNamingContext nothing to unbind");
                throw new NameNotFoundException(name);
            }
            this.bindings.remove(name);
        } else {
            String suffix = n.getSuffix(1).toString();
            Context subctx = this.lookupCtx(n.get(0));
            subctx.unbind(suffix);
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol("CompNamingContext rename " + oldName + " in " + newName);
        }
        Object obj = this.lookupLink(oldName);
        this.rebind(newName, obj);
        this.unbind(oldName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if (name.length() == 0) {
            return new ListOfNames(this.bindings);
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            return ((Context)obj).list("");
        }
        TraceCarol.error("CompNamingContext: can only list a Context");
        throw new NotContextException(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if (name.length() == 0) {
            return new ListOfBindings(this.bindings);
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            return ((Context)obj).listBindings("");
        }
        TraceCarol.error("CompNamingContext: can only list a Context");
        throw new NotContextException(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        TraceCarol.error("CompNamingContext try to destroySubcontext " + name);
        throw new OperationNotSupportedException("CompNamingContext: destroySubcontext");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            TraceCarol.error("CompNamingContext createSubcontext with empty name ?");
            throw new InvalidNameException("CompNamingContext cannot create empty Subcontext");
        }
        Context ctx = null;
        if (n.size() == 1) {
            ctx = new CompNamingContext(this.compId, this.myEnv);
            this.bindings.put(name, ctx);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            name = n.get(0);
            try {
                subctx = this.lookupCtx(name);
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(name);
            }
            ctx = subctx.createSubcontext(suffix);
        }
        return ctx;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        TraceCarol.error("CompNamingContext lookupLink not implemented yet!");
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return myParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        TraceCarol.error("CompNamingContext composeName not implemented!");
        throw new OperationNotSupportedException("CompNamingContext composeName");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        TraceCarol.error("CompNamingContext composeName " + name + " " + prefix);
        throw new OperationNotSupportedException("CompNamingContext composeName");
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        TraceCarol.debugjndiEncCarol(propName);
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        TraceCarol.debugjndiEncCarol(propName);
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol("");
        }
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv;
    }

    @Override
    public void close() throws NamingException {
        this.myEnv = null;
    }

    @Override
    public String getNameInNamespace() {
        return this.compId;
    }

    private Context lookupCtx(String name) throws NamingException {
        Object obj = this.bindings.get(name);
        if (obj == null) {
            throw new NameNotFoundException(name);
        }
        if (obj instanceof CompNamingContext) {
            return (Context)obj;
        }
        throw new NameAlreadyBoundException(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ListOfBindings
    extends NamingEnum<Binding> {
        ListOfBindings(Hashtable<String, Object> bindings) {
            super(bindings);
        }

        @Override
        public Binding next() throws NamingException {
            String name = this.getNames().nextElement();
            return new Binding(name, this.getBindings().get(name));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ListOfNames
    extends NamingEnum<NameClassPair> {
        ListOfNames(Hashtable<String, Object> bindings) {
            super(bindings);
        }

        @Override
        public NameClassPair next() throws NamingException {
            String name = this.getNames().nextElement();
            String className = CompNamingContext.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NamingEnum<T extends NameClassPair>
    implements NamingEnumeration<T> {
        private Enumeration<String> names;
        private Hashtable<String, Object> bindings;

        NamingEnum(Hashtable<String, Object> bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        @Override
        public abstract T next() throws NamingException;

        @Override
        public void close() {
        }

        @Override
        public T nextElement() {
            try {
                return (T)this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        protected Hashtable<String, ?> getBindings() {
            return this.bindings;
        }

        protected Enumeration<String> getNames() {
            return this.names;
        }
    }
}

