/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class TypeReference
extends Expression {
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void aboutToResolve(Scope scope) {
    }

    public static final TypeReference baseTypeReference(int baseType, int dim) {
        if (dim == 0) {
            switch (baseType) {
                case 6: {
                    return new SingleTypeReference(TypeBinding.VOID.simpleName, 0L);
                }
                case 5: {
                    return new SingleTypeReference(TypeBinding.BOOLEAN.simpleName, 0L);
                }
                case 2: {
                    return new SingleTypeReference(TypeBinding.CHAR.simpleName, 0L);
                }
                case 9: {
                    return new SingleTypeReference(TypeBinding.FLOAT.simpleName, 0L);
                }
                case 8: {
                    return new SingleTypeReference(TypeBinding.DOUBLE.simpleName, 0L);
                }
                case 3: {
                    return new SingleTypeReference(TypeBinding.BYTE.simpleName, 0L);
                }
                case 4: {
                    return new SingleTypeReference(TypeBinding.SHORT.simpleName, 0L);
                }
                case 10: {
                    return new SingleTypeReference(TypeBinding.INT.simpleName, 0L);
                }
            }
            return new SingleTypeReference(TypeBinding.LONG.simpleName, 0L);
        }
        switch (baseType) {
            case 6: {
                return new ArrayTypeReference(TypeBinding.VOID.simpleName, dim, 0L);
            }
            case 5: {
                return new ArrayTypeReference(TypeBinding.BOOLEAN.simpleName, dim, 0L);
            }
            case 2: {
                return new ArrayTypeReference(TypeBinding.CHAR.simpleName, dim, 0L);
            }
            case 9: {
                return new ArrayTypeReference(TypeBinding.FLOAT.simpleName, dim, 0L);
            }
            case 8: {
                return new ArrayTypeReference(TypeBinding.DOUBLE.simpleName, dim, 0L);
            }
            case 3: {
                return new ArrayTypeReference(TypeBinding.BYTE.simpleName, dim, 0L);
            }
            case 4: {
                return new ArrayTypeReference(TypeBinding.SHORT.simpleName, dim, 0L);
            }
            case 10: {
                return new ArrayTypeReference(TypeBinding.INT.simpleName, dim, 0L);
            }
        }
        return new ArrayTypeReference(TypeBinding.LONG.simpleName, dim, 0L);
    }

    public void checkBounds(Scope scope) {
    }

    public abstract TypeReference copyDims(int var1);

    public int dimensions() {
        return 0;
    }

    public abstract char[] getLastToken();

    public char[][] getParameterizedTypeName() {
        return this.getTypeName();
    }

    protected abstract TypeBinding getTypeBinding(Scope var1);

    public abstract char[][] getTypeName();

    public boolean isTypeReference() {
        return true;
    }

    public TypeBinding resolveSuperType(ClassScope scope) {
        if (this.resolveType(scope) == null) {
            return null;
        }
        if (this.resolvedType.isTypeVariable()) {
            this.resolvedType = new ProblemReferenceBinding(this.getTypeName(), (ReferenceBinding)this.resolvedType, 9);
            this.reportInvalidType(scope);
            return null;
        }
        return this.resolvedType;
    }

    public final TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveType(BlockScope scope, boolean checkBounds) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        this.resolvedType = this.getTypeBinding(scope);
        TypeBinding type = this.resolvedType;
        if (type == null) {
            return null;
        }
        if (!type.isValidBinding()) {
            this.reportInvalidType(scope);
            return null;
        }
        if (type.isArrayType() && ((ArrayBinding)type).leafComponentType == TypeBinding.VOID) {
            scope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (this.isTypeUseDeprecated(type, scope)) {
            this.reportDeprecatedType(type, scope);
        }
        if ((type = scope.environment().convertToRawType(type)).leafComponentType().isRawType() && (this.bits & 0x40000000) == 0 && scope.compilerOptions().getSeverity(0x200000000000L) != -1) {
            scope.problemReporter().rawTypeReference(this, type);
        }
        this.resolvedType = type;
        return this.resolvedType;
    }

    public TypeBinding resolveType(ClassScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        this.resolvedType = this.getTypeBinding(scope);
        TypeBinding type = this.resolvedType;
        if (type == null) {
            return null;
        }
        if (!type.isValidBinding()) {
            this.reportInvalidType(scope);
            return null;
        }
        if (type.isArrayType() && ((ArrayBinding)type).leafComponentType == TypeBinding.VOID) {
            scope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (this.isTypeUseDeprecated(type, scope)) {
            this.reportDeprecatedType(type, scope);
        }
        if ((type = scope.environment().convertToRawType(type)).leafComponentType().isRawType() && (this.bits & 0x40000000) == 0 && scope.compilerOptions().getSeverity(0x200000000000L) != -1) {
            scope.problemReporter().rawTypeReference(this, type);
        }
        this.resolvedType = type;
        return this.resolvedType;
    }

    public TypeBinding resolveTypeArgument(BlockScope blockScope, ReferenceBinding genericType, int rank) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveTypeArgument(ClassScope classScope, ReferenceBinding genericType, int rank) {
        return this.resolveType(classScope);
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().invalidType(this, this.resolvedType);
    }

    protected void reportDeprecatedType(TypeBinding type, Scope scope) {
        scope.problemReporter().deprecatedType(type, this);
    }

    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    public abstract void traverse(ASTVisitor var1, ClassScope var2);
}

