/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import [Lorg.springframework.core.io.Resource;;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.URIEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourceEditorRegistrar
implements PropertyEditorRegistrar {
    private final ResourceLoader resourceLoader;

    public ResourceEditorRegistrar(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        ResourceEditor baseEditor = new ResourceEditor(this.resourceLoader);
        registry.registerCustomEditor(Resource.class, baseEditor);
        registry.registerCustomEditor(InputStream.class, new InputStreamEditor(baseEditor));
        registry.registerCustomEditor(File.class, new FileEditor(baseEditor));
        registry.registerCustomEditor(URL.class, new URLEditor(baseEditor));
        ClassLoader classLoader = this.resourceLoader.getClassLoader();
        registry.registerCustomEditor(Class.class, new ClassEditor(classLoader));
        registry.registerCustomEditor(URI.class, new URIEditor(classLoader));
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            registry.registerCustomEditor(Resource;.class, new ResourceArrayPropertyEditor((ResourcePatternResolver)this.resourceLoader));
        }
    }
}

