/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.eclipse.persistence.internal.helper.TimeZoneHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatThreadLocal
extends ThreadLocal<DateFormat> {
    protected SimpleDateFormat simpleDateFormat;
    protected TimeZoneHolder timeZoneHolder;

    public DateFormatThreadLocal(String formatStr, TimeZoneHolder timeZoneHolder) {
        this.simpleDateFormat = new SimpleDateFormat(formatStr);
        this.timeZoneHolder = timeZoneHolder;
    }

    @Override
    public DateFormat get() {
        TimeZone tz;
        if (this.timeZoneHolder != null && (tz = this.timeZoneHolder.getTimeZone()) != null && !this.simpleDateFormat.getTimeZone().equals(tz)) {
            this.simpleDateFormat.setTimeZone(tz);
        }
        return (DateFormat)super.get();
    }

    @Override
    protected DateFormat initialValue() {
        return this.simpleDateFormat;
    }
}

