/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.statistic;

import java.util.HashMap;
import java.util.Map;
import javax.management.j2ee.statistics.CountStatistic;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocation;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.api.jmx.EZBMBeanAttribute;
import org.ow2.easybeans.api.statistic.EZBStatistic;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBJmxComponent;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.statistic.AbstractStatistic;
import org.ow2.easybeans.statistic.AbstractStatisticFactory;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.jmx.impl.AbstractMBeanAttribute;

public class MeanCallTimeStatisticFactory
extends AbstractStatisticFactory {
    public MeanCallTimeStatisticFactory(EZBEventComponent eventComponent, EZBJmxComponent jmxComponent) {
        super(J2EEManagedObjectNamingHelper.getAllJ2EEManagedObjectsFilter(), eventComponent, jmxComponent);
    }

    public EZBStatistic createStatistic(String statisticProviderId) {
        return new MeanCallTimeStatistic(statisticProviderId);
    }

    public class MeanCallTimeStatistic
    extends AbstractStatistic {
        private long total;
        private long count;
        private Map<Long, EZBEventBeanInvocationBegin> pendingCall;

        public MeanCallTimeStatistic(String statisticProviderId) {
            super(statisticProviderId.matches(J2EEManagedObjectNamingHelper.getAllMethodsFilter()) ? "averageProcessingTime_" + statisticProviderId.substring(statisticProviderId.lastIndexOf("/") + 1) : "averageProcessingTime", "The average processing time", "ms", MeanCallTimeStatisticFactory.this.getStatisticFactoryId(), statisticProviderId, MeanCallTimeStatisticFactory.this.getEventComponent(), MeanCallTimeStatisticFactory.this.getJmxComponent());
            this.pendingCall = new HashMap<Long, EZBEventBeanInvocationBegin>();
            this.addEventListener(new MeanCallTimeEventListener());
            this.addMBeanAttribute(new MeanCallTimeMBeanAttribute());
        }

        public synchronized void reset() {
            super.reset();
            this.total = 0L;
            this.count = 0L;
        }

        public synchronized String getValue() {
            return (this.count > 0L ? this.total / this.count : 0L) + this.getUnit();
        }

        public synchronized CountStatistic getJSR77Statistic() {
            return new CountStatistic(){

                public String getName() {
                    return MeanCallTimeStatistic.this.getName();
                }

                public String getDescription() {
                    return MeanCallTimeStatistic.this.getDescription();
                }

                public String getUnit() {
                    return MeanCallTimeStatistic.this.getUnit();
                }

                public long getStartTime() {
                    return MeanCallTimeStatistic.this.getStartTime();
                }

                public long getLastSampleTime() {
                    return MeanCallTimeStatistic.this.getLastSampleTime();
                }

                public long getCount() {
                    if (MeanCallTimeStatistic.this.count > 0L) {
                        return MeanCallTimeStatistic.this.total / MeanCallTimeStatistic.this.count;
                    }
                    return 0L;
                }
            };
        }

        private class MeanCallTimeMBeanAttribute
        extends AbstractMBeanAttribute
        implements EZBMBeanAttribute {
            public String getMBeanProviderFilter() {
                return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(MeanCallTimeStatistic.this.getStatisticProviderId());
            }

            public MeanCallTimeMBeanAttribute() {
                super(MeanCallTimeStatistic.this.getName(), MeanCallTimeStatistic.this.getUnit(), MeanCallTimeStatistic.this.getDescription(), true, false, false);
            }

            public Object getValue(String id) {
                if (MeanCallTimeStatistic.this.count > 0L) {
                    return MeanCallTimeStatistic.this.total / MeanCallTimeStatistic.this.count;
                }
                return 0;
            }

            public void setValue(String id, Object value) {
            }
        }

        private class MeanCallTimeEventListener
        implements EZBEventListener {
            private String eventProviderFilter;

            public MeanCallTimeEventListener() {
                this.eventProviderFilter = J2EEManagedObjectNamingHelper.getAllRelativeMethodsFilter(MeanCallTimeStatistic.this.getStatisticProviderId());
            }

            public String getEventProviderFilter() {
                return this.eventProviderFilter;
            }

            public boolean accept(IEvent event) {
                try {
                    return ((EZBEventBeanInvocation)event).getEventProviderId().matches(this.getEventProviderFilter());
                }
                catch (Throwable error) {
                    return false;
                }
            }

            public EventPriority getPriority() {
                return EventPriority.ASYNC_LOW;
            }

            public synchronized void handle(IEvent event) {
                if (EZBEventBeanInvocationBegin.class.isAssignableFrom(event.getClass())) {
                    EZBEventBeanInvocationBegin e = (EZBEventBeanInvocationBegin)event;
                    MeanCallTimeStatistic.this.pendingCall.put(e.getInvocationNumber(), e);
                } else {
                    EZBEventBeanInvocation eventEnd = (EZBEventBeanInvocation)event;
                    EZBEventBeanInvocation eventBegin = (EZBEventBeanInvocation)MeanCallTimeStatistic.this.pendingCall.remove(eventEnd.getInvocationNumber());
                    MeanCallTimeStatistic.this.count++;
                    MeanCallTimeStatistic.this.total += eventEnd.getTime() - eventBegin.getTime();
                    MeanCallTimeStatistic.this.setLastSampleTime(System.currentTimeMillis());
                }
            }
        }
    }
}

