/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.smartclient.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.easybeans.component.smartclient.api.Message;
import org.ow2.easybeans.component.smartclient.message.ClassAnswer;
import org.ow2.easybeans.component.smartclient.message.ClassNotFound;
import org.ow2.easybeans.component.smartclient.message.ClassRequest;
import org.ow2.easybeans.component.smartclient.message.ProviderURLAnswer;
import org.ow2.easybeans.component.smartclient.message.ProviderURLRequest;
import org.ow2.easybeans.component.smartclient.message.ResourceAnswer;
import org.ow2.easybeans.component.smartclient.message.ResourceRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AskingClassLoader
extends URLClassLoader {
    private static Logger logger = Logger.getLogger(AskingClassLoader.class.getName());
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private InetSocketAddress socketAddress = null;
    private static int nbClasses = 0;
    private static int nbResources = 0;
    private static long nbBytes = 0L;
    private static long timeToDownload = 0L;

    public AskingClassLoader(String host, int portNumber) {
        this(host, portNumber, Thread.currentThread().getContextClassLoader(), new URL[0]);
    }

    public AskingClassLoader(String host, int portNumber, URL[] urls) {
        this(host, portNumber, Thread.currentThread().getContextClassLoader(), urls);
    }

    public AskingClassLoader(String host, int portNumber, ClassLoader parentClassLoader, URL[] urls) {
        super(urls, parentClassLoader);
        this.socketAddress = new InetSocketAddress(host, portNumber);
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        }
        catch (IllegalStateException e) {
            logger.log(Level.FINE, "Cannot add a new hook", e);
        }
    }

    private SocketChannel getChannel() {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
        }
        catch (IOException e) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Cannot open a channel", e);
        }
        try {
            channel.connect(this.socketAddress);
        }
        catch (IOException e) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Cannot connect the channel", e);
        }
        return channel;
    }

    private void cleanChannel(SocketChannel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Cannot close the given channel", e);
            }
        }
    }

    public ByteBuffer sendRequest(Message message, SocketChannel channel) {
        try {
            channel.write(message.getMessage());
        }
        catch (IOException e) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Cannot send the given message '" + message + "'.", e);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
        ByteBuffer completeBuffer = null;
        try {
            int length = 0;
            boolean finished = false;
            while (!finished && channel.read(buffer) != -1) {
                if (buffer.position() >= 6 && completeBuffer == null) {
                    length = buffer.getInt(2);
                    completeBuffer = ByteBuffer.allocate(6 + length + 1024);
                }
                buffer.flip();
                completeBuffer.put(buffer);
                buffer.clear();
                if (completeBuffer.position() < 6 + length) continue;
                completeBuffer.limit(6 + length);
                completeBuffer.position(6);
                finished = true;
                break;
            }
        }
        catch (Exception e) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Cannot read the answer from the server.", e);
        }
        return completeBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            SocketChannel channel = null;
            try {
                long tStart = System.currentTimeMillis();
                channel = this.getChannel();
                ByteBuffer answerBuffer = this.sendRequest(new ClassRequest(name), channel);
                byte opCode = this.getOpCode(answerBuffer, channel);
                timeToDownload += System.currentTimeMillis() - tStart;
                switch (opCode) {
                    case 2: {
                        ClassAnswer classAnswer = new ClassAnswer(answerBuffer);
                        try {
                            clazz = this.loadClass(name, classAnswer.getByteCode());
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException("Cannot find the class", e);
                        }
                        ++nbClasses;
                        nbBytes += (long)classAnswer.getByteCode().length;
                        if (!Boolean.getBoolean("smart.debug.verbose")) return clazz;
                        System.out.println("Downloaded class '" + name + "'.");
                        return clazz;
                    }
                    case 3: {
                        ClassNotFound classNotFound = new ClassNotFound(answerBuffer);
                        throw new ClassNotFoundException("The class '" + classNotFound.getName() + "' was not found on the remote side");
                    }
                    default: {
                        throw new ClassNotFoundException("Invalid opCode '" + opCode + "' received");
                    }
                }
            }
            finally {
                this.cleanChannel(channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getProviderURL() {
        String providerURL = null;
        SocketChannel channel = null;
        try {
            long tStart = System.currentTimeMillis();
            channel = this.getChannel();
            ByteBuffer answerBuffer = this.sendRequest(new ProviderURLRequest(), channel);
            byte opCode = this.getOpCode(answerBuffer, channel);
            timeToDownload += System.currentTimeMillis() - tStart;
            switch (opCode) {
                case 8: {
                    ProviderURLAnswer providerURLAnswer = new ProviderURLAnswer(answerBuffer);
                    providerURL = providerURLAnswer.getProviderURL();
                    return providerURL;
                }
                default: {
                    throw new IllegalStateException("Invalid opCode '" + opCode + "' received");
                }
            }
        }
        finally {
            this.cleanChannel(channel);
        }
    }

    private byte getOpCode(ByteBuffer buffer, SocketChannel channel) {
        if (buffer == null) {
            throw new IllegalStateException("Empty buffer received");
        }
        byte version = buffer.get(0);
        if (version != 1) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Invalid protocol version : waiting '1', got '" + version + "'.");
        }
        byte opCode = buffer.get(1);
        int length = buffer.getInt(2);
        if (length < 0) {
            this.cleanChannel(channel);
            throw new IllegalStateException("Invalid length for client '" + length + "'.");
        }
        return opCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized URL findResource(String name) {
        URL url = null;
        url = super.findResource(name);
        if (url != null) {
            return url;
        }
        if (name.startsWith("META-INF")) {
            return null;
        }
        SocketChannel channel = null;
        try {
            long tStart = System.currentTimeMillis();
            channel = this.getChannel();
            ByteBuffer answerBuffer = this.sendRequest(new ResourceRequest(name), channel);
            byte opCode = this.getOpCode(answerBuffer, channel);
            timeToDownload += System.currentTimeMillis() - tStart;
            switch (opCode) {
                case 5: {
                    ResourceAnswer resourceAnswer = new ResourceAnswer(answerBuffer);
                    String resourceName = resourceAnswer.getResourceName();
                    byte[] bytes = resourceAnswer.getBytes();
                    ++nbResources;
                    nbBytes += (long)resourceAnswer.getBytes().length;
                    File fConfDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "easybeans-smart");
                    if (!fConfDir.exists()) {
                        fConfDir.mkdir();
                    }
                    String[] tokens = resourceName.split("/");
                    StringBuilder sb = new StringBuilder();
                    for (String token : tokens) {
                        if (sb.length() > 0) {
                            sb.append(File.separator);
                        }
                        sb.append(token);
                    }
                    File urlFile = new File(fConfDir, sb.toString());
                    if (!urlFile.getParentFile().exists()) {
                        urlFile.getParentFile().mkdir();
                    }
                    FileOutputStream fos = new FileOutputStream(urlFile);
                    fos.write(bytes);
                    fos.close();
                    url = urlFile.toURI().toURL();
                    return url;
                }
                case 6: {
                    url = null;
                    return url;
                }
                default: {
                    throw new IllegalStateException("Invalid opCode '" + opCode + "' received");
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Cannot handle : findResource '" + name + "'", e);
            return url;
        }
        finally {
            this.cleanChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(String className, byte[] bytecode) throws IOException {
        Class clazz = null;
        try {
            AskingClassLoader loader = this;
            Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            try {
                clazz = (Class)method.invoke((Object)loader, className, bytecode, 0, bytecode.length);
            }
            finally {
                method.setAccessible(false);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Cannot define class with name '" + className + "'.");
            ioe.initCause(e);
            throw ioe;
        }
        return clazz;
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            if (Boolean.getBoolean("smart.debug")) {
                System.out.println("Downloaded '" + nbClasses + "' classes, '" + nbResources + "' resources for a total of '" + nbBytes + "' bytes and it took '" + timeToDownload + "' ms.");
            }
        }
    }
}

